/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import java.util.StringTokenizer;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.common.Opcodes;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.UnaryCPInstruction;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.lineage.LineageItemUtils;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.Operator;

public class StringInitCPInstruction
extends UnaryCPInstruction {
    public static final String DELIM = " ";
    private final long _rlen;
    private final long _clen;
    private final String _data;

    private StringInitCPInstruction(Operator op, CPOperand in, CPOperand out, long rows, long cols, int blen, String data, String opcode, String inst) {
        super(CPInstruction.CPType.StringInit, op, in, out, opcode, inst);
        this._rlen = rows;
        this._clen = cols;
        this._data = data;
    }

    public long getRows() {
        return this._rlen;
    }

    public long getCols() {
        return this._clen;
    }

    public static StringInitCPInstruction parseInstruction(String str) {
        String opcode = InstructionUtils.getOpCode(str);
        if (!opcode.equals(Opcodes.STRINGINIT.toString())) {
            throw new DMLRuntimeException("Unsupported opcode: " + opcode);
        }
        String[] s = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(s, 5);
        CPOperand out = new CPOperand(s[s.length - 1]);
        long rows = s[1].contains("\u00b6") ? -1L : Double.valueOf(s[1]).longValue();
        long cols = s[2].contains("\u00b6") ? -1L : Double.valueOf(s[2]).longValue();
        int blen = Integer.parseInt(s[3]);
        String data = s[4];
        return new StringInitCPInstruction(null, null, out, rows, cols, blen, data, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        String outName = this.output.getName();
        MatrixBlock outBlk = new MatrixBlock((int)this._rlen, (int)this._clen, false);
        StringTokenizer st = new StringTokenizer(this._data, DELIM);
        int len = st.countTokens();
        if ((long)len != this._rlen * this._clen) {
            throw new DMLRuntimeException("Invalid matrix string intialization: dimensions=[" + this._rlen + "x" + this._clen + "] vs numValues=" + len);
        }
        for (int i = 0; i < len; ++i) {
            String sval = st.nextToken();
            Double dval = Double.parseDouble(sval);
            int rix = (int)((long)i / this._clen);
            int cix = (int)((long)i % this._clen);
            outBlk.set(rix, cix, dval);
        }
        outBlk.recomputeNonZeros();
        outBlk.examSparsity();
        ec.setMatrixOutput(outName, outBlk);
    }

    @Override
    public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
        CPOperand rlen = new CPOperand(String.valueOf(this.getRows()), Types.ValueType.INT64, Types.DataType.SCALAR, true);
        CPOperand clen = new CPOperand(String.valueOf(this.getCols()), Types.ValueType.INT64, Types.DataType.SCALAR, true);
        CPOperand data = new CPOperand(this._data, Types.ValueType.STRING, Types.DataType.SCALAR, true);
        return Pair.of((Object)this.output.getName(), (Object)new LineageItem(this.getOpcode(), LineageItemUtils.getLineage(ec, rlen, clen, data)));
    }
}

