/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.indexes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.indexes.AColIndex;
import org.apache.sysds.runtime.compress.colgroup.indexes.ColIndexFactory;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.indexes.IIterate;
import org.apache.sysds.runtime.compress.colgroup.indexes.RangeIndex;

public class TwoRangesIndex
extends AColIndex {
    protected final RangeIndex idx1;
    protected final RangeIndex idx2;

    public TwoRangesIndex(RangeIndex lower, RangeIndex higher) {
        this.idx1 = lower;
        this.idx2 = higher;
    }

    @Override
    public int size() {
        return this.idx1.size() + this.idx2.size();
    }

    @Override
    public int get(int i) {
        if (i < this.idx1.size()) {
            return this.idx1.get(i);
        }
        return this.idx2.get(i - this.idx1.size());
    }

    @Override
    public IColIndex shift(int i) {
        return new TwoRangesIndex(this.idx1.shift(i), this.idx2.shift(i));
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(IColIndex.ColIndexType.TWORANGE.ordinal());
        out.writeInt(this.idx1.get(0));
        out.writeInt(this.idx1.size());
        out.writeInt(this.idx2.get(0));
        out.writeInt(this.idx2.size());
    }

    public static TwoRangesIndex read(DataInput in) throws IOException {
        int l1 = in.readInt();
        int u1 = in.readInt() + l1;
        int l2 = in.readInt();
        int u2 = in.readInt() + l2;
        return new TwoRangesIndex(new RangeIndex(l1, u1), new RangeIndex(l2, u2));
    }

    @Override
    public long getExactSizeOnDisk() {
        return 17L;
    }

    @Override
    public long estimateInMemorySize() {
        return TwoRangesIndex.estimateInMemorySizeStatic();
    }

    public static long estimateInMemorySizeStatic() {
        return 32L + RangeIndex.estimateInMemorySizeStatic() * 2L;
    }

    @Override
    public IIterate iterator() {
        return new TwoRangesIterator();
    }

    @Override
    public int findIndex(int i) {
        int aix = this.idx1.findIndex(i);
        if (aix < -1 * this.idx1.size()) {
            int bix = this.idx2.findIndex(i);
            if (bix < 0) {
                return aix + bix + 1;
            }
            return this.idx1.size() + bix;
        }
        return aix;
    }

    @Override
    public IColIndex.SliceResult slice(int l, int u) {
        if (u <= this.idx1.get(0)) {
            return new IColIndex.SliceResult(0, 0, null);
        }
        if (l >= this.idx2.get(this.idx2.size() - 1)) {
            return new IColIndex.SliceResult(0, 0, null);
        }
        if (l <= this.idx1.get(0) && u >= this.idx2.get(this.idx2.size() - 1)) {
            RangeIndex ids1 = this.idx1.shift(-l);
            RangeIndex ids2 = this.idx2.shift(-l);
            return new IColIndex.SliceResult(0, this.size(), new TwoRangesIndex(ids1, ids2));
        }
        IColIndex.SliceResult sa = this.idx1.slice(l, u);
        IColIndex.SliceResult sb = this.idx2.slice(l, u);
        if (sa.ret == null) {
            return new IColIndex.SliceResult(this.idx1.size() + sb.idStart, this.idx1.size() + sb.idEnd, sb.ret);
        }
        if (sb.ret == null) {
            return sa;
        }
        IColIndex c = sa.ret.combine(sb.ret);
        return new IColIndex.SliceResult(sa.idStart, sa.idStart + sb.idEnd, c);
    }

    @Override
    public boolean equals(IColIndex other) {
        if (other instanceof TwoRangesIndex) {
            TwoRangesIndex otri = (TwoRangesIndex)other;
            return this.idx1.equals(otri.idx1) && this.idx2.equals(otri.idx2);
        }
        if (other instanceof RangeIndex) {
            return false;
        }
        return other.equals(this);
    }

    @Override
    public IColIndex combine(IColIndex other) {
        int sr = other.size();
        int sl = this.size();
        int[] ret = new int[sr + sl];
        int pl = 0;
        int pr = 0;
        int i = 0;
        while (pl < sl && pr < sr) {
            int vr;
            int vl = this.get(pl);
            if (vl < (vr = other.get(pr))) {
                ret[i++] = vl;
                ++pl;
                continue;
            }
            ret[i++] = vr;
            ++pr;
        }
        while (pl < sl) {
            ret[i++] = this.get(pl++);
        }
        while (pr < sr) {
            ret[i++] = other.get(pr++);
        }
        return ColIndexFactory.create(ret);
    }

    @Override
    public boolean isContiguous() {
        return false;
    }

    @Override
    public int[] getReorderingIndex() {
        throw new DMLCompressionException("not valid to get reordering Index for range");
    }

    @Override
    public boolean isSorted() {
        return true;
    }

    @Override
    public IColIndex sort() {
        throw new DMLCompressionException("range is always sorted");
    }

    @Override
    public boolean contains(int i) {
        return this.idx1.contains(i) || this.idx2.contains(i);
    }

    @Override
    public double avgOfIndex() {
        return (this.idx1.avgOfIndex() * (double)this.idx1.size() + this.idx2.avgOfIndex() * (double)this.idx2.size()) / (double)this.size();
    }

    @Override
    public int hashCode() {
        return this.idx1.hashCode() * 811 + this.idx2.hashCode();
    }

    @Override
    public boolean containsAny(IColIndex idx) {
        return this.idx1.containsAny(idx) || this.idx2.containsAny(idx);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[");
        sb.append(this.idx1.get(0));
        sb.append(" -> ");
        sb.append(this.idx1.get(this.idx1.size()));
        sb.append(" And ");
        sb.append(this.idx2.get(0));
        sb.append(" -> ");
        sb.append(this.idx2.get(this.idx2.size()));
        sb.append("]");
        return sb.toString();
    }

    protected class TwoRangesIterator
    implements IIterate {
        IIterate a;
        IIterate b;
        boolean aDone;

        protected TwoRangesIterator() {
            this.a = TwoRangesIndex.this.idx1.iterator();
            this.b = TwoRangesIndex.this.idx2.iterator();
            this.aDone = false;
        }

        @Override
        public int next() {
            if (!this.aDone) {
                int v = this.a.next();
                this.aDone = !this.a.hasNext();
                return v;
            }
            return this.b.next();
        }

        @Override
        public boolean hasNext() {
            return this.a.hasNext() || this.b.hasNext();
        }

        @Override
        public int v() {
            if (!this.aDone) {
                return this.a.v();
            }
            return this.b.v();
        }

        @Override
        public int i() {
            if (!this.aDone) {
                return this.a.i();
            }
            return this.a.i() + this.b.i();
        }
    }
}

