/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.parser;

import java.util.HashMap;
import org.apache.sysds.common.Types;
import org.apache.sysds.parser.ConstIdentifier;
import org.apache.sysds.parser.DataIdentifier;
import org.apache.sysds.parser.Expression;
import org.apache.sysds.parser.IndexPair;
import org.apache.sysds.parser.IndexedIdentifier;

public abstract class Identifier
extends Expression {
    protected Types.DataType _dataType = Types.DataType.UNKNOWN;
    protected Types.ValueType _valueType = Types.ValueType.UNKNOWN;
    protected long _dim1 = -1L;
    protected long _dim2 = -1L;
    protected int _blocksize = -1;
    protected long _nnz = -1L;
    protected Types.FileFormat _format;

    public Identifier() {
        this.setOutput(this);
        this._format = null;
    }

    public void setProperties(Identifier i) {
        if (i == null) {
            return;
        }
        this._dataType = i.getDataType();
        this._valueType = i.getValueType();
        if (i instanceof IndexedIdentifier) {
            this._dim1 = ((IndexedIdentifier)i).getOrigDim1();
            this._dim2 = ((IndexedIdentifier)i).getOrigDim2();
        } else {
            this._dim1 = i.getDim1();
            this._dim2 = i.getDim2();
        }
        this._blocksize = i.getBlocksize();
        this._nnz = i.getNnz();
        this._format = i.getFileFormat();
    }

    public void setDimensionValueProperties(Identifier i) {
        if (i instanceof IndexedIdentifier) {
            IndexedIdentifier ixi = (IndexedIdentifier)i;
            this._dim1 = ixi.getOrigDim1();
            this._dim2 = ixi.getOrigDim2();
        } else {
            this._dim1 = i.getDim1();
            this._dim2 = i.getDim2();
        }
        this._nnz = i.getNnz();
        this._dataType = i.getDataType();
        this._valueType = i.getValueType();
    }

    public void setDataType(Types.DataType dt) {
        this._dataType = dt;
    }

    public void setValueType(Types.ValueType vt) {
        this._valueType = vt;
    }

    public void setFileFormat(Types.FileFormat ft) {
        this._format = ft;
    }

    public void setDimensions(long dim1, long dim2) {
        this._dim1 = dim1;
        this._dim2 = dim2;
    }

    public void setNnz(long nnzs) {
        this._nnz = nnzs;
    }

    public long getDim1() {
        return this._dim1;
    }

    public long getDim2() {
        return this._dim2;
    }

    public Types.DataType getDataType() {
        return this._dataType;
    }

    public Types.ValueType getValueType() {
        return this._valueType;
    }

    public Types.FileFormat getFileFormat() {
        return this._format;
    }

    public int getBlocksize() {
        return this._blocksize;
    }

    public void setBlocksize(int blen) {
        this._blocksize = blen;
    }

    public long getNnz() {
        return this._nnz;
    }

    @Override
    public void validateExpression(HashMap<String, DataIdentifier> ids, HashMap<String, ConstIdentifier> constVars, boolean conditional) {
        if (this.getOutput() instanceof DataIdentifier) {
            String name = ((DataIdentifier)this.getOutput()).getName();
            Identifier id = ids.get(name);
            if (id == null) {
                this.raiseValidateError("Undefined Variable (" + name + ") used in statement", false, "Invalid Parameters");
            }
            this.getOutput().setProperties(id);
            if (this.getOutput() instanceof IndexedIdentifier) {
                IndexedIdentifier ixId = (IndexedIdentifier)this.getOutput();
                Expression[] exp = new Expression[]{ixId.getRowLowerBound(), ixId.getRowUpperBound(), ixId.getColLowerBound(), ixId.getColUpperBound()};
                String[] msg = new String[]{"row lower", "row upper", "column lower", "column upper"};
                for (int i = 0; i < 4; ++i) {
                    if (exp[i] == null) continue;
                    exp[i].validateExpression(ids, constVars, conditional);
                    if (exp[i].getOutput().getDataType() != Types.DataType.MATRIX) continue;
                    this.raiseValidateError("Matrix values for " + msg[i] + " index bound are not supported, which includes indexed identifiers.", conditional);
                }
                if (this.getOutput().getDataType() == Types.DataType.LIST) {
                    int dim1 = ((IndexedIdentifier)this.getOutput()).getRowUpperBound() == null ? 1 : -1;
                    ((IndexedIdentifier)this.getOutput()).setDimensions(dim1, 1L);
                } else {
                    IndexPair updatedIndices = ((IndexedIdentifier)this.getOutput()).calculateIndexedDimensions(ids, constVars, conditional);
                    ((IndexedIdentifier)this.getOutput()).setDimensions(updatedIndices._row, updatedIndices._col);
                }
            }
        } else {
            this.getOutput().setProperties(this.getOutput());
        }
    }

    public void computeDataType() {
        this._dataType = this._dim1 == 0L && this._dim2 == 0L ? Types.DataType.SCALAR : (this._dim1 >= 1L || this._dim2 >= 1L ? Types.DataType.MATRIX : Types.DataType.UNKNOWN);
    }

    public void setBooleanProperties() {
        this._dataType = Types.DataType.SCALAR;
        this._valueType = Types.ValueType.BOOLEAN;
        this._dim1 = 0L;
        this._dim2 = 0L;
        this._blocksize = 0;
        this._nnz = -1L;
        this._format = null;
    }

    public void setIntProperties() {
        this._dataType = Types.DataType.SCALAR;
        this._valueType = Types.ValueType.INT64;
        this._dim1 = 0L;
        this._dim2 = 0L;
        this._blocksize = 0;
        this._nnz = -1L;
        this._format = null;
    }

    public boolean isScalarBoolean() {
        return this._valueType == Types.ValueType.BOOLEAN && this._dataType == Types.DataType.SCALAR;
    }

    public boolean dimsKnown() {
        return this._dim1 >= 0L && this._dim2 >= 0L;
    }
}

