/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.io.FileFormatPropertiesHDF5;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.io.MatrixWriter;
import org.apache.sysds.runtime.io.hdf5.H5;
import org.apache.sysds.runtime.io.hdf5.H5RootObject;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.HDFSTool;

public class WriterHDF5
extends MatrixWriter {
    protected static FileFormatPropertiesHDF5 _props = null;

    public WriterHDF5(FileFormatPropertiesHDF5 _props) {
        WriterHDF5._props = _props;
    }

    @Override
    public void writeMatrixToHDFS(MatrixBlock src, String fname, long rlen, long clen, int blen, long nnz, boolean diag) throws IOException, DMLRuntimeException {
        if ((long)src.getNumRows() != rlen || (long)src.getNumColumns() != clen) {
            throw new IOException("Matrix dimensions mismatch with metadata: " + src.getNumRows() + "x" + src.getNumColumns() + " vs " + rlen + "x" + clen + ".");
        }
        if (rlen == 0L || clen == 0L) {
            throw new IOException("Write of matrices with zero rows or columns not supported (" + rlen + "x" + clen + ").");
        }
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        HDFSTool.deleteFileIfExistOnHDFS(fname);
        this.writeHDF5MatrixToHDFS(path, job, fs, src);
        IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(fs, path);
    }

    @Override
    public final void writeEmptyMatrixToHDFS(String fname, long rlen, long clen, int blen) throws IOException, DMLRuntimeException {
        throw new DMLRuntimeException("writing empty HDF5 matrices not supported yet");
    }

    protected void writeHDF5MatrixToHDFS(Path path, JobConf job, FileSystem fs, MatrixBlock src) throws IOException {
        WriterHDF5.writeHDF5MatrixToFile(path, job, fs, src, 0, src.getNumRows());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeHDF5MatrixToFile(Path path, JobConf job, FileSystem fs, MatrixBlock src, int rl, int rlen) throws IOException {
        int clen = src.getNumColumns();
        BufferedOutputStream bos = new BufferedOutputStream((OutputStream)fs.create(path, true));
        String datasetName = _props.getDatasetName();
        H5RootObject rootObject = H5.H5Screate(bos, src.getNumRows(), src.getNumColumns());
        H5.H5Dcreate(rootObject, src.getNumRows(), src.getNumColumns(), datasetName);
        if (rl == 0) {
            H5.H5WriteHeaders(rootObject);
        }
        try {
            double[] row = new double[clen];
            if (src.isInSparseFormat()) {
                SparseBlock sb = src.getSparseBlock();
                for (int i = rl; i < rlen; ++i) {
                    Arrays.fill(row, 0.0);
                    if (!sb.isEmpty(i)) {
                        int apos = sb.pos(i);
                        int alen = sb.size(i);
                        double[] avals = sb.values(i);
                        int[] aix = sb.indexes(i);
                        for (int j = apos; j < apos + alen; ++j) {
                            row[aix[j]] = avals[j];
                        }
                    }
                    H5.H5Dwrite(rootObject, row);
                }
            } else {
                DenseBlock db = src.getDenseBlock();
                for (int i = rl; i < rlen; ++i) {
                    for (int j = 0; j < clen; ++j) {
                        double lvalue;
                        row[j] = lvalue = db != null ? db.get(i, j) : 0.0;
                    }
                    H5.H5Dwrite(rootObject, row);
                }
            }
        }
        finally {
            IOUtilFunctions.closeSilently(bos);
        }
    }
}

