/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import org.apache.sysds.api.DMLScript;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.federated.FederatedStatistics;
import org.apache.sysds.runtime.lineage.LineageCache;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.utils.stats.SparkStatistics;

public class TriggerPrefetchTask
implements Runnable {
    MatrixObject _prefetchMO;
    LineageItem _inputLi;

    public TriggerPrefetchTask(MatrixObject mo) {
        this._prefetchMO = mo;
        this._inputLi = null;
    }

    public TriggerPrefetchTask(MatrixObject mo, LineageItem li) {
        this._prefetchMO = mo;
        this._inputLi = li;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean prefetched = false;
        MatrixBlock mb = null;
        long t1 = System.nanoTime();
        MatrixObject matrixObject = this._prefetchMO;
        synchronized (matrixObject) {
            if (this._prefetchMO.isPendingRDDOps() || this._prefetchMO.isDeviceToHostCopy() || this._prefetchMO.isFederated()) {
                mb = (MatrixBlock)this._prefetchMO.acquireReadAndRelease();
                prefetched = true;
            }
        }
        if (this._inputLi != null && mb != null) {
            LineageCache.putValueAsyncOp(this._inputLi, this._prefetchMO, mb, t1);
        }
        if (DMLScript.STATISTICS && prefetched) {
            if (this._prefetchMO.isFederated()) {
                FederatedStatistics.incAsyncPrefetchCount(1L);
            } else {
                SparkStatistics.incAsyncPrefetchCount(1L);
            }
        }
    }
}

