/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.offset;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.AOffsetsGroup;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToByte;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToChar;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToUByte;
import org.apache.sysds.runtime.compress.colgroup.offset.AIterator;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffsetIterator;
import org.apache.sysds.runtime.compress.colgroup.offset.ISliceOffset;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetEmpty;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetFactory;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetSingle;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetTwo;
import org.apache.sysds.runtime.compress.utils.IntArrayList;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;

public abstract class AOffset
implements Serializable {
    private static final long serialVersionUID = 6910025321078561338L;
    protected static final Log LOG = LogFactory.getLog((String)AOffset.class.getName());
    protected static final OffsetSliceInfo EMPTY_SLICE = new OffsetSliceInfo(-1, -1, new OffsetEmpty());
    protected static final int SKIP_STRIDE = 1000;
    private volatile SoftReference<OffsetCacheV2[]> skipList = null;
    private volatile ThreadLocal<OffsetCache> cacheRow = null;

    public abstract AIterator getIterator();

    public abstract AOffsetIterator getOffsetIterator();

    private AIterator getIteratorFromSkipList(OffsetCacheV2 c) {
        return this.getIteratorFromIndexOff(c.row, c.dataIndex, c.offIndex);
    }

    protected abstract AIterator getIteratorFromIndexOff(int var1, int var2, int var3);

    public AIterator getIterator(int row) {
        if (row <= this.getOffsetToFirst()) {
            return this.getIterator();
        }
        if (row > this.getOffsetToLast()) {
            return null;
        }
        OffsetCache c = this.getLength() < 1000 ? null : (this.cacheRow == null ? null : this.cacheRow.get());
        if (c != null && c.row == row) {
            return c.it.clone();
        }
        if (this.getLength() < 1000) {
            return this.getIteratorSmallOffset(row);
        }
        return this.getIteratorLargeOffset(row);
    }

    private AIterator getIteratorSkipCache(int row) {
        if (row <= this.getOffsetToFirst()) {
            return this.getIterator();
        }
        if (row > this.getOffsetToLast()) {
            return null;
        }
        if (this.getLength() < 1000) {
            return this.getIteratorSmallOffset(row);
        }
        return this.getIteratorLargeOffset(row);
    }

    private AIterator getIteratorSmallOffset(int row) {
        AIterator it = this.getIterator();
        it.skipTo(row);
        this.cacheIterator(it.clone(), row);
        return it;
    }

    private final AIterator getIteratorLargeOffset(int row) {
        int idx;
        if (this.skipList == null || this.skipList.get() == null) {
            this.constructSkipList();
        }
        OffsetCacheV2[] skip = this.skipList.get();
        for (idx = 0; idx < skip.length && skip[idx] != null && skip[idx].row <= row; ++idx) {
        }
        AIterator it = idx == 0 ? this.getIterator() : this.getIteratorFromSkipList(skip[idx - 1]);
        it.skipTo(row);
        this.cacheIterator(it.clone(), row);
        return it;
    }

    public synchronized void constructSkipList() {
        if (this.skipList != null && this.skipList.get() != null) {
            return;
        }
        int last = this.getOffsetToLast();
        int skipSize = last / 1000 + 1;
        if (skipSize == 1) {
            return;
        }
        OffsetCacheV2[] skipListTmp = new OffsetCacheV2[skipSize];
        AIterator it = this.getIterator();
        int skipListIdx = 0;
        while (it.value() < last) {
            int next = skipListIdx * 1000 + 1000;
            while (it.value() < next && it.value() < last) {
                it.next();
            }
            skipListTmp[skipListIdx++] = new OffsetCacheV2(it.value(), it.getDataIndex(), it.getOffsetsIndex());
        }
        this.skipList = new SoftReference<OffsetCacheV2[]>(skipListTmp);
    }

    public synchronized void clearSkipList() {
        if (this.skipList != null) {
            this.skipList.clear();
        }
    }

    public void cacheIterator(final AIterator it, final int row) {
        if (it == null || this.getLength() < 1000) {
            return;
        }
        if (this.cacheRow == null) {
            this.cacheRow = new ThreadLocal<OffsetCache>(){

                @Override
                protected OffsetCache initialValue() {
                    return new OffsetCache(it, row);
                }
            };
        } else {
            this.cacheRow.set(new OffsetCache(it, row));
        }
    }

    public abstract void write(DataOutput var1) throws IOException;

    public abstract int getOffsetToFirst();

    public abstract int getOffsetToLast();

    public abstract long getInMemorySize();

    public abstract long getExactSizeOnDisk();

    public abstract int getSize();

    public final void preAggregateDenseMap(DenseBlock db, double[] preAV, int rl, int ru, int cl, int cu, int nVal, AMapToData data) {
        AIterator it = this.getIterator(cl);
        if (it == null) {
            return;
        }
        if (it.offset > cu) {
            this.cacheIterator(it, cu);
        } else if (rl == ru - 1) {
            double[] mV = db.values(rl);
            int off = db.pos(rl);
            this.preAggDenseMapSingleRow(mV, off, preAV, cu, nVal, data, it);
        } else {
            this.preAggDenseMapMultiRows(db, preAV, rl, ru, cl, cu, nVal, data, it);
        }
    }

    private final void preAggDenseMapSingleRow(double[] mV, int off, double[] preAV, int cu, int nVal, AMapToData data, AIterator it) {
        int last = this.getOffsetToLast();
        if (cu <= last) {
            this.preAggDenseMapRowBellowEnd(mV, off, preAV, cu, data, it);
        } else {
            this.preAggDenseMapSingleRowEnd(mV, off, preAV, last, data, it);
        }
    }

    private final void preAggDenseMapRowBellowEnd(double[] mV, int off, double[] preAV, int cu, AMapToData data, AIterator it) {
        it.offset += off;
        this.preAggDenseMapRowBE(mV, preAV, cu += off, data, it);
        it.offset -= off;
        this.cacheIterator(it, cu -= off);
    }

    private final void preAggDenseMapRowBE(double[] mV, double[] preAV, int cu, AMapToData data, AIterator it) {
        if (data instanceof MapToUByte) {
            this.preAggDenseMapRowBE_UByte(mV, preAV, cu, (MapToUByte)data, it);
        } else if (data instanceof MapToByte) {
            this.preAggDenseMapRowBE_Byte(mV, preAV, cu, (MapToByte)data, it);
        } else if (data instanceof MapToChar) {
            this.preAggDenseMapRowBE_Char(mV, preAV, cu, (MapToChar)data, it);
        } else {
            this.preAggDenseMapRowBE_Generic(mV, preAV, cu, data, it);
        }
    }

    private final void preAggDenseMapRowBE_UByte(double[] mV, double[] preAV, int cu, MapToUByte data, AIterator it) {
        while (it.offset < cu) {
            int n = data.getIndex(it.getDataIndex());
            preAV[n] = preAV[n] + mV[it.offset];
            it.next();
        }
    }

    private final void preAggDenseMapRowBE_Byte(double[] mV, double[] preAV, int cu, MapToByte data, AIterator it) {
        while (it.offset < cu) {
            int n = data.getIndex(it.getDataIndex());
            preAV[n] = preAV[n] + mV[it.offset];
            it.next();
        }
    }

    private final void preAggDenseMapRowBE_Char(double[] mV, double[] preAV, int cu, MapToChar data, AIterator it) {
        while (it.offset < cu) {
            int n = data.getIndex(it.getDataIndex());
            preAV[n] = preAV[n] + mV[it.offset];
            it.next();
        }
    }

    private final void preAggDenseMapRowBE_Generic(double[] mV, double[] preAV, int cu, AMapToData data, AIterator it) {
        while (it.offset < cu) {
            int n = data.getIndex(it.getDataIndex());
            preAV[n] = preAV[n] + mV[it.offset];
            it.next();
        }
    }

    private final void preAggDenseMapSingleRowEnd(double[] mV, int off, double[] preAV, int last, AMapToData data, AIterator it) {
        while (it.offset < last) {
            int dx = it.getDataIndex();
            int n = data.getIndex(dx);
            preAV[n] = preAV[n] + mV[off + it.offset];
            it.next();
        }
        int n = data.getIndex(it.getDataIndex());
        preAV[n] = preAV[n] + mV[off + last];
    }

    private final void preAggDenseMapMultiRows(DenseBlock db, double[] preAV, int rl, int ru, int cl, int cu, int nVal, AMapToData data, AIterator it) {
        if (!db.isContiguous()) {
            throw new NotImplementedException("Not implemented support for preAggregate non contiguous dense matrix");
        }
        if (cu <= this.getOffsetToLast()) {
            this.preAggDenseMapMultiRowsBelowEnd(db, preAV, rl, ru, cl, cu, nVal, data, it);
        } else {
            this.preAggDenseMapMultiRowsEnd(db, preAV, rl, ru, cl, cu, nVal, data, it);
        }
    }

    private final void preAggDenseMapMultiRowsBelowEnd(DenseBlock db, double[] preAV, int rl, int ru, int cl, int cu, int nVal, AMapToData data, AIterator it) {
        double[] vals = db.values(rl);
        int nCol = db.getCumODims(0);
        while (it.offset < cu) {
            int dataOffset = data.getIndex(it.getDataIndex());
            int start = it.offset + nCol * rl;
            int end = it.offset + nCol * ru;
            int offOut = dataOffset;
            for (int off = start; off < end; off += nCol) {
                int n = offOut;
                preAV[n] = preAV[n] + vals[off];
                offOut += nVal;
            }
            it.next();
        }
        this.cacheIterator(it, cu);
    }

    private final void preAggDenseMapMultiRowsEnd(DenseBlock db, double[] preAV, int rl, int ru, int cl, int cu, int nVal, AMapToData data, AIterator it) {
        int off;
        double[] vals = db.values(rl);
        int nCol = db.getCumODims(0);
        int last = this.getOffsetToLast();
        int dataOffset = data.getIndex(it.getDataIndex());
        int start = it.offset + nCol * rl;
        int end = it.offset + nCol * ru;
        int offOut = dataOffset;
        for (off = start; off < end; off += nCol) {
            int n = offOut;
            preAV[n] = preAV[n] + vals[off];
            offOut += nVal;
        }
        while (it.offset < last) {
            it.next();
            dataOffset = data.getIndex(it.getDataIndex());
            start = it.offset + nCol * rl;
            end = it.offset + nCol * ru;
            offOut = dataOffset;
            for (off = start; off < end; off += nCol) {
                int n = offOut;
                preAV[n] = preAV[n] + vals[off];
                offOut += nVal;
            }
        }
    }

    public final void preAggSparseMap(SparseBlock sb, double[] preAV, int rl, int ru, int nVal, AMapToData data) {
        AIterator it = this.getIterator();
        if (rl == ru - 1) {
            this.preAggSparseMapSingleRow(sb, preAV, rl, nVal, data, it);
        } else {
            this.preAggSparseMapMultipleRows(sb, preAV, rl, ru, nVal, data, it);
        }
    }

    private final void preAggSparseMapSingleRow(SparseBlock sb, double[] preAV, int r, int nVal, AMapToData data, AIterator it) {
        int last;
        if (sb.isEmpty(r)) {
            return;
        }
        int alen = sb.size(r) + sb.pos(r);
        int[] aix = sb.indexes(r);
        if (aix[alen - 1] < (last = this.getOffsetToLast())) {
            this.preAggSparseMapRowBellowEnd(sb, preAV, r, nVal, data, it);
        } else {
            this.preAggSparseMapRowEnd(sb, preAV, r, nVal, data, it);
        }
    }

    private final void preAggSparseMapRowBellowEnd(SparseBlock sb, double[] preAV, int r, int nVal, AMapToData data, AIterator it) {
        int apos = sb.pos(r);
        int alen = sb.size(r) + apos;
        int[] aix = sb.indexes(r);
        double[] avals = sb.values(r);
        int v = it.value();
        while (apos < alen) {
            if (aix[apos] == v) {
                int n = data.getIndex(it.getDataIndex());
                preAV[n] = preAV[n] + avals[apos++];
                v = it.next();
                continue;
            }
            if (aix[apos] < v) {
                ++apos;
                continue;
            }
            v = it.next();
        }
    }

    private final void preAggSparseMapRowEnd(SparseBlock sb, double[] preAV, int r, int nVal, AMapToData data, AIterator it) {
        int apos = sb.pos(r);
        int alen = sb.size(r) + apos;
        int[] aix = sb.indexes(r);
        double[] avals = sb.values(r);
        int last = this.getOffsetToLast();
        int v = it.value();
        while (v < last) {
            if (aix[apos] == v) {
                int n = data.getIndex(it.getDataIndex());
                preAV[n] = preAV[n] + avals[apos++];
                v = it.next();
                continue;
            }
            if (aix[apos] < v) {
                ++apos;
                continue;
            }
            v = it.next();
        }
        while (aix[apos] < last && apos < alen) {
            ++apos;
        }
        if (v == aix[apos]) {
            int n = data.getIndex(it.getDataIndex());
            preAV[n] = preAV[n] + avals[apos];
        }
    }

    private final void preAggSparseMapMultipleRows(SparseBlock sb, double[] preAV, int rl, int ru, int nVal, AMapToData data, AIterator it) {
        int i = it.value();
        int last = this.getOffsetToLast();
        int[] aOffs = new int[ru - rl];
        for (int r = rl; r < ru; ++r) {
            aOffs[r - rl] = sb.pos(r);
        }
        while (i < last) {
            this.preAggSparseMapRow(sb, preAV, rl, ru, nVal, data.getIndex(it.getDataIndex()), i, aOffs);
            i = it.next();
        }
        this.preAggSparseMapRow(sb, preAV, rl, ru, nVal, data.getIndex(it.getDataIndex()), last, aOffs);
    }

    private final void preAggSparseMapRow(SparseBlock sb, double[] preAV, int rl, int ru, int nVal, int dataIndex, int i, int[] aOffs) {
        for (int r = rl; r < ru; ++r) {
            int apos;
            if (sb.isEmpty(r)) continue;
            int off = r - rl;
            int alen = sb.size(r) + sb.pos(r);
            int[] aix = sb.indexes(r);
            double[] avals = sb.values(r);
            for (apos = aOffs[off]; apos < alen && aix[apos] < i; ++apos) {
            }
            if (apos < alen && aix[apos] == i) {
                int n = off * nVal + dataIndex;
                preAV[n] = preAV[n] + avals[apos];
            }
            aOffs[off] = apos;
        }
    }

    public boolean equals(Object o) {
        return o instanceof AOffset && this.equals((AOffset)o);
    }

    public boolean equals(AOffset b) {
        if (this.getOffsetToLast() == b.getOffsetToLast()) {
            int last = this.getOffsetToLast();
            AOffsetIterator ia = this.getOffsetIterator();
            AOffsetIterator ib = b.getOffsetIterator();
            while (ia.value() < last) {
                if (ia.value() != ib.value()) {
                    return false;
                }
                ia.next();
                ib.next();
                if (ib.value() != last || ia.value() == last) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public abstract AOffset moveIndex(int var1);

    public abstract int getLength();

    public OffsetSliceInfo slice(int l, int u) {
        int first = this.getOffsetToFirst();
        int last = this.getOffsetToLast();
        int s = this.getSize();
        if (l <= first && u > last) {
            if (l == 0) {
                return new OffsetSliceInfo(0, s, this);
            }
            return new OffsetSliceInfo(0, s, this.moveIndex(l));
        }
        if (u < first) {
            return EMPTY_SLICE;
        }
        AIterator it = this.getIteratorSkipCache(l);
        if (it == null || it.value() >= u) {
            return EMPTY_SLICE;
        }
        if (u >= last) {
            return this.constructSliceReturn(l, u, it.getDataIndex(), s - 1, it.getOffsetsIndex(), this.getLength(), it.value(), last);
        }
        return this.genericSlice(l, u, it);
    }

    private OffsetSliceInfo genericSlice(int l, int u, AIterator it) {
        int low = it.getDataIndex();
        int lowOff = it.getOffsetsIndex();
        int lowValue = it.value();
        int high = low;
        int highOff = lowOff;
        int highValue = lowValue;
        while (it.value() < u) {
            highValue = it.value();
            high = it.getDataIndex();
            highOff = it.getOffsetsIndex();
            it.next();
        }
        return this.constructSliceReturn(l, u, low, high, lowOff, highOff, lowValue, highValue);
    }

    private final OffsetSliceInfo constructSliceReturn(int l, int u, int low, int high, int lowOff, int highOff, int lowValue, int highValue) {
        if (low == high) {
            return new OffsetSliceInfo(low, high + 1, new OffsetSingle(lowValue - l));
        }
        if (low + 1 == high) {
            return new OffsetSliceInfo(low, high + 1, new OffsetTwo(lowValue - l, highValue - l));
        }
        return ((ISliceOffset)((Object)this)).slice(lowOff, highOff, lowValue - l, highValue - l, low, high);
    }

    public AOffset append(AOffset t, int s) {
        IntArrayList r = new IntArrayList(this.getLength() + t.getLength());
        AOffsetIterator of = this.getOffsetIterator();
        while (of.value() < this.getOffsetToLast()) {
            r.appendValue(of.value());
            of.next();
        }
        r.appendValue(of.value());
        AOffsetIterator tof = t.getOffsetIterator();
        int last = t.getOffsetToLast();
        while (tof.value() < last) {
            r.appendValue(tof.value() + s);
            tof.next();
        }
        r.appendValue(tof.value() + s);
        return OffsetFactory.createOffset(r);
    }

    public AOffset appendN(AOffsetsGroup[] g, int s) {
        int l = 0;
        for (AOffsetsGroup gs : g) {
            l += gs.getOffsets().getLength();
        }
        IntArrayList r = new IntArrayList(l);
        int ss = 0;
        for (AOffsetsGroup gs : g) {
            AOffset tof = gs.getOffsets();
            if (!(tof instanceof OffsetEmpty)) {
                AOffsetIterator tofit = tof.getOffsetIterator();
                int last = tof.getOffsetToLast() + ss;
                int v = tofit.value() + ss;
                while (v < last) {
                    r.appendValue(v);
                    v = tofit.next() + ss;
                }
                r.appendValue(v);
            }
            ss += s;
        }
        return OffsetFactory.createOffset(r);
    }

    public void verify(int size) {
        AIterator it = this.getIterator();
        if (it != null) {
            int last = this.getOffsetToLast();
            if (it.getDataIndex() > size) {
                throw new DMLCompressionException("Invalid index");
            }
            while (it.value() < last) {
                it.next();
                if (it.getDataIndex() <= size) continue;
                throw new DMLCompressionException("Invalid index");
            }
        } else if (size != 0) {
            throw new DMLCompressionException("Invalid index");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        AIterator it = this.getIterator();
        if (it != null) {
            int last = this.getOffsetToLast();
            sb.append("[");
            sb.append(it.offset);
            while (it.offset < last) {
                it.next();
                sb.append(", ");
                sb.append(it.offset);
            }
            sb.append("]");
        }
        if (CompressedMatrixBlock.debug) {
            if (this.cacheRow != null && this.cacheRow.get() != null) {
                sb.append("\nOffset CacheRow: ");
                sb.append(this.cacheRow.get().toString());
            }
            if (this.skipList != null && this.skipList.get() != null) {
                sb.append("\nSkipList:");
                sb.append(Arrays.toString(this.skipList.get()));
            }
        }
        return sb.toString();
    }

    public AOffset reverse(int numRows) {
        int last = this.getOffsetToLast();
        if (numRows < last) {
            throw new DMLRuntimeException("Invalid number of rows for reverse: last: " + last + " numRows: " + numRows);
        }
        int[] newOff = new int[numRows - this.getSize()];
        AOffsetIterator it = this.getOffsetIterator();
        int i = 0;
        int j = 0;
        while (i < last) {
            if (i == it.value()) {
                ++i;
                it.next();
                continue;
            }
            newOff[j++] = i++;
        }
        ++i;
        while (i < numRows) {
            newOff[j++] = i++;
        }
        return OffsetFactory.createOffset(newOff);
    }

    private static class OffsetCacheV2 {
        private final int row;
        private final int offIndex;
        private final int dataIndex;

        private OffsetCacheV2(int row, int dataIndex, int offIndex) {
            this.row = row;
            this.dataIndex = dataIndex;
            this.offIndex = offIndex;
        }

        public String toString() {
            return "r" + this.row + " d " + this.dataIndex + " o " + this.offIndex + "\n";
        }
    }

    private static class OffsetCache {
        private final AIterator it;
        private final int row;

        private OffsetCache(AIterator it, int row) {
            this.it = it;
            this.row = row;
        }

        public String toString() {
            return "r " + this.row + " i" + this.it + "\n";
        }
    }

    public static final class OffsetSliceInfo {
        public final int lIndex;
        public final int uIndex;
        public final AOffset offsetSlice;

        protected OffsetSliceInfo(int l, int u, AOffset off) {
            this.lIndex = l;
            this.uIndex = u;
            this.offsetSlice = off;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("sliceInfo: ");
            sb.append(this.lIndex);
            sb.append("->");
            sb.append(this.uIndex);
            sb.append("  --  ");
            sb.append(this.offsetSlice);
            return sb.toString();
        }
    }
}

