/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util.timeline;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.timeline.TimelineAbout;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.util.YarnVersionInfo;
import org.apache.hadoop.yarn.webapp.YarnJacksonJaxbJsonProvider;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class TimelineUtils {
    public static final String FLOW_NAME_TAG_PREFIX = "TIMELINE_FLOW_NAME_TAG";
    public static final String FLOW_VERSION_TAG_PREFIX = "TIMELINE_FLOW_VERSION_TAG";
    public static final String FLOW_RUN_ID_TAG_PREFIX = "TIMELINE_FLOW_RUN_ID_TAG";
    public static final String DEFAULT_FLOW_VERSION = "1";
    private static ObjectMapper mapper = new ObjectMapper();

    public static String dumpTimelineRecordtoJSON(Object o) throws JsonGenerationException, JsonMappingException, IOException {
        return TimelineUtils.dumpTimelineRecordtoJSON(o, false);
    }

    public static String dumpTimelineRecordtoJSON(Object o, boolean pretty) throws JsonGenerationException, JsonMappingException, IOException {
        if (pretty) {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(o);
        }
        return mapper.writeValueAsString(o);
    }

    public static boolean timelineServiceEnabled(Configuration conf) {
        return conf.getBoolean("yarn.timeline-service.enabled", false);
    }

    public static float getTimelineServiceVersion(Configuration conf) {
        return conf.getFloat("yarn.timeline-service.version", 1.0f);
    }

    public static boolean timelineServiceV1_5Enabled(Configuration conf) {
        return YarnConfiguration.timelineServiceV15Enabled((Configuration)conf);
    }

    public static TimelineAbout createTimelineAbout(String about) {
        TimelineAbout tsInfo = new TimelineAbout(about);
        tsInfo.setHadoopBuildVersion(VersionInfo.getBuildVersion());
        tsInfo.setHadoopVersion(VersionInfo.getVersion());
        tsInfo.setHadoopVersionBuiltOn(VersionInfo.getDate());
        tsInfo.setTimelineServiceBuildVersion(YarnVersionInfo.getBuildVersion());
        tsInfo.setTimelineServiceVersion(YarnVersionInfo.getVersion());
        tsInfo.setTimelineServiceVersionBuiltOn(YarnVersionInfo.getDate());
        return tsInfo;
    }

    public static InetSocketAddress getTimelineTokenServiceAddress(Configuration conf) {
        InetSocketAddress timelineServiceAddr = null;
        timelineServiceAddr = YarnConfiguration.useHttps((Configuration)conf) ? conf.getSocketAddr("yarn.timeline-service.webapp.https.address", "0.0.0.0:8190", 8190) : conf.getSocketAddr("yarn.timeline-service.webapp.address", "0.0.0.0:8188", 8188);
        return timelineServiceAddr;
    }

    public static Text buildTimelineTokenService(Configuration conf) {
        InetSocketAddress timelineServiceAddr = TimelineUtils.getTimelineTokenServiceAddress(conf);
        return SecurityUtil.buildTokenService((InetSocketAddress)timelineServiceAddr);
    }

    public static String generateDefaultFlowName(String appName, ApplicationId appId) {
        return appName != null && !appName.equals("N/A") ? appName : "flow_" + appId.getClusterTimestamp() + "_" + appId.getId();
    }

    public static String generateFlowNameTag(String flowName) {
        return "TIMELINE_FLOW_NAME_TAG:" + flowName;
    }

    public static String shortenFlowName(String flowName, Configuration conf) {
        if (flowName == null) {
            return null;
        }
        flowName = TimelineUtils.removeUUID(flowName);
        int length = conf.getInt("yarn.timeline-service.flowname.max-size", 0);
        if (length <= 0) {
            return flowName;
        }
        return StringUtils.substring((String)flowName, (int)0, (int)length);
    }

    @VisibleForTesting
    static String removeUUID(String flowName) {
        flowName = StringUtils.replaceAll((String)flowName, (String)"-?([a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}){1}", (String)"");
        return flowName;
    }

    public static String generateFlowVersionTag(String flowVersion) {
        return "TIMELINE_FLOW_VERSION_TAG:" + flowVersion;
    }

    public static String generateFlowRunIdTag(long flowRunId) {
        return "TIMELINE_FLOW_RUN_ID_TAG:" + flowRunId;
    }

    static {
        YarnJacksonJaxbJsonProvider.configObjectMapper(mapper);
    }
}

