/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.estim;

import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.DMLCompressionException;

public class EstimationFactors {
    protected final int numVals;
    protected final int numOffs;
    protected final int largestOff;
    protected final int[] frequencies;
    protected final int numSingle;
    protected final int numRows;
    protected final int numRuns;
    protected final boolean lossy;
    protected final boolean zeroIsMostFrequent;
    protected final boolean containNoZeroValues;
    protected final double overAllSparsity;
    protected final double tupleSparsity;

    public EstimationFactors(int numVals, int numRows) {
        this(numVals, numRows, -1, null, -1, numRows, false, false, 1.0, 1.0);
    }

    public EstimationFactors(int numVals, int numRows, double tupleSparsity) {
        this(numVals, numRows, -1, null, -1, numRows, false, false, 1.0, tupleSparsity);
    }

    public EstimationFactors(int numVals, int numRows, int numOffs, double tupleSparsity) {
        this(numVals, numOffs, -1, null, -1, numRows, false, false, 1.0, tupleSparsity);
    }

    public EstimationFactors(int numVals, int numOffs, int largestOff, int[] frequencies, int numSingle, int numRows, boolean lossy, boolean zeroIsMostFrequent, double overAllSparsity, double tupleSparsity) {
        this(numVals, numOffs, largestOff, frequencies, numSingle, numRows, numOffs, lossy, zeroIsMostFrequent, overAllSparsity, tupleSparsity);
    }

    public EstimationFactors(int numVals, int numOffs, int largestOff, int[] frequencies, int numSingle, int numRows, int numRuns, boolean lossy, boolean zeroIsMostFrequent, double overAllSparsity, double tupleSparsity) {
        this.numVals = numVals;
        this.numOffs = numOffs;
        this.largestOff = largestOff;
        this.frequencies = frequencies;
        this.numRuns = numRuns;
        this.numSingle = numSingle;
        this.numRows = numRows;
        this.lossy = lossy;
        this.zeroIsMostFrequent = zeroIsMostFrequent;
        this.containNoZeroValues = numOffs == numRows && overAllSparsity < 1.0;
        this.overAllSparsity = overAllSparsity;
        this.tupleSparsity = tupleSparsity;
        if (overAllSparsity > 1.0 || overAllSparsity < 0.0) {
            throw new DMLCompressionException("Invalid OverAllSparsity of: " + overAllSparsity);
        }
        if (tupleSparsity > 1.0 || tupleSparsity < 0.0) {
            throw new DMLCompressionException("Invalid TupleSparsity of:" + tupleSparsity);
        }
        if (largestOff > numRows) {
            throw new DMLCompressionException("Invalid number of instance of most common element should be lower than number of rows. " + largestOff + " > numRows: " + numRows);
        }
        if (numVals > numOffs) {
            throw new DMLCompressionException("Num vals cannot be greater than num offs: vals: " + numVals + " offs: " + numOffs);
        }
        if (CompressedMatrixBlock.debug && frequencies != null) {
            for (int i = 0; i < frequencies.length; ++i) {
                if (frequencies[i] != 0) continue;
                throw new DMLCompressionException("Invalid counts in fact contains 0");
            }
        }
    }

    public int[] getFrequencies() {
        return this.frequencies;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("rows:" + this.numRows);
        sb.append(" num Offsets:" + this.numOffs);
        if (this.largestOff != -1) {
            sb.append(" LargestOffset:" + this.largestOff);
        }
        sb.append(" num Singles:" + this.numSingle);
        if (this.numRuns != this.numOffs) {
            sb.append(" num Runs: " + this.numRuns);
        }
        sb.append(" num Unique Vals:" + this.numVals);
        sb.append(" overallSparsity:" + this.overAllSparsity);
        sb.append(" tupleSparsity:" + this.tupleSparsity);
        return sb.toString();
    }
}

