/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.io.FileFormatPropertiesMM;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.io.ReaderTextCell;
import org.apache.sysds.runtime.matrix.data.IJV;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.CommonThreadPool;
import org.apache.sysds.runtime.util.FastStringTokenizer;
import org.apache.sysds.runtime.util.HDFSTool;
import org.apache.sysds.runtime.util.UtilFunctions;

public class ReaderTextCellParallel
extends ReaderTextCell {
    private static final long MIN_FILESIZE_MM = 8192L;
    private int _numThreads = OptimizerUtils.getParallelTextReadParallelism();

    public ReaderTextCellParallel(Types.FileFormat fmt) {
        super(fmt, false);
    }

    @Override
    protected void readTextCellMatrixFromHDFS(Path path, JobConf job, MatrixBlock dest, long rlen, long clen, int blen) throws IOException {
        int par = this._numThreads;
        FileInputFormat.addInputPath((JobConf)job, (Path)path);
        TextInputFormat informat = new TextInputFormat();
        informat.configure(job);
        if (this._isMMFile) {
            long len = HDFSTool.getFilesizeOnHDFS(path);
            par = len < 8192L ? 1 : par;
        }
        try {
            ExecutorService pool = CommonThreadPool.get(par);
            InputSplit[] splits = informat.getSplits(job, par);
            if (dest.isInSparseFormat()) {
                int[] rNnz = new int[(int)rlen];
                boolean isSymmetric = this._isMMFile && this._mmProps.isSymmetric();
                List tasks = Arrays.stream(splits).map(s -> new CountNnzTask((InputSplit)s, informat, job, rNnz, isSymmetric)).collect(Collectors.toList());
                List rt1 = pool.invokeAll(tasks);
                for (Future task : rt1) {
                    task.get();
                }
                SparseBlock sblock = dest.allocateBlock().getSparseBlock();
                int i = 0;
                while ((long)i < rlen) {
                    if (rNnz[i] > 0) {
                        sblock.allocate(i, UtilFunctions.roundToNext(rNnz[i], 4));
                    }
                    ++i;
                }
            }
            List tasks = Arrays.stream(splits).map(s -> new ReadTask((InputSplit)s, informat, job, dest, rlen, clen, this._isMMFile, this._mmProps)).collect(Collectors.toList());
            List rt2 = pool.invokeAll(tasks);
            long lnnz = 0L;
            for (Future task : rt2) {
                lnnz += ((Long)task.get()).longValue();
            }
            dest.setNonZeros(lnnz);
            if (dest.isInSparseFormat()) {
                ReaderTextCellParallel.sortSparseRowsParallel(dest, rlen, this._numThreads, pool);
            }
            pool.shutdown();
        }
        catch (Exception e) {
            throw new IOException("Threadpool issue, while parallel read.", e);
        }
    }

    public static class CellBuffer {
        public static final int CAPACITY = 102400;
        private int[] _rlen = new int[102400];
        private int[] _clen = new int[102400];
        private double[] _vals = new double[102400];
        private int _pos = -1;

        public void addCell(int rlen, int clen, double val) {
            if (val == 0.0) {
                return;
            }
            ++this._pos;
            this._rlen[this._pos] = rlen;
            this._clen[this._pos] = clen;
            this._vals[this._pos] = val;
        }

        public void flushCellBufferToMatrixBlock(MatrixBlock dest) {
            for (int i = 0; i <= this._pos; ++i) {
                dest.appendValue(this._rlen[i], this._clen[i], this._vals[i]);
            }
            this.reset();
        }

        public int size() {
            return this._pos + 1;
        }

        public void reset() {
            this._pos = -1;
        }
    }

    public static class CountNnzTask
    implements Callable<Void> {
        private final InputSplit _split;
        private final TextInputFormat _informat;
        private final JobConf _job;
        private final int[] _rNnz;
        private final boolean _isSymmetric;

        public CountNnzTask(InputSplit split, TextInputFormat informat, JobConf job, int[] rNnz, boolean isSymmetric) {
            this._split = split;
            this._informat = informat;
            this._job = job;
            this._rNnz = rNnz;
            this._isSymmetric = isSymmetric;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            LongWritable key = new LongWritable();
            Text value = new Text();
            FastStringTokenizer st = new FastStringTokenizer(' ');
            RecordReader reader = this._informat.getRecordReader(this._split, this._job, Reporter.NULL);
            try {
                boolean foundComment = false;
                while (reader.next((Object)key, (Object)value)) {
                    if (value.toString().charAt(0) == '%') {
                        foundComment = true;
                        continue;
                    }
                    if (foundComment) break;
                    this.countCell(st, value.toString());
                    break;
                }
                while (reader.next((Object)key, (Object)value)) {
                    this.countCell(st, value.toString());
                }
            }
            finally {
                IOUtilFunctions.closeSilently(reader);
            }
            return null;
        }

        private void countCell(FastStringTokenizer st, String value) {
            st.reset(value);
            int rix = (int)st.nextLong() - 1;
            if (rix >= 0) {
                int cix;
                int n = rix;
                this._rNnz[n] = this._rNnz[n] + 1;
                if (this._isSymmetric && rix != (cix = (int)st.nextLong() - 1)) {
                    int n2 = cix;
                    this._rNnz[n2] = this._rNnz[n2] + 1;
                }
            }
        }
    }

    public static class ReadTask
    implements Callable<Long> {
        private final InputSplit _split;
        private final boolean _sparse;
        private final TextInputFormat _informat;
        private final JobConf _job;
        private final MatrixBlock _dest;
        private final long _rlen;
        private final long _clen;
        private final boolean _matrixMarket;
        private final FileFormatPropertiesMM _mmProps;

        public ReadTask(InputSplit split, TextInputFormat informat, JobConf job, MatrixBlock dest, long rlen, long clen, boolean mm, FileFormatPropertiesMM mmProps) {
            this._split = split;
            this._sparse = dest.isInSparseFormat();
            this._informat = informat;
            this._job = job;
            this._dest = dest;
            this._rlen = rlen;
            this._clen = clen;
            this._matrixMarket = mm;
            this._mmProps = mmProps;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long call() throws Exception {
            long lnnz;
            block22: {
                lnnz = 0L;
                LongWritable key = new LongWritable();
                Text value = new Text();
                IJV cell = new IJV();
                FastStringTokenizer st = new FastStringTokenizer(' ');
                RecordReader reader = this._informat.getRecordReader(this._split, this._job, Reporter.NULL);
                try {
                    MatrixBlock matrixBlock;
                    if (this._matrixMarket) {
                        boolean foundComment = false;
                        while (reader.next((Object)key, (Object)value) && value.toString().charAt(0) == '%') {
                            foundComment = true;
                        }
                        if (!foundComment) {
                            cell = ReaderTextCell.parseCell(value.toString(), st, cell, this._mmProps);
                            matrixBlock = this._dest;
                            synchronized (matrixBlock) {
                                lnnz += (long)ReaderTextCell.appendCell(cell, this._dest, this._mmProps);
                            }
                        }
                    }
                    if (this._sparse) {
                        CellBuffer buff = new CellBuffer();
                        while (reader.next((Object)key, (Object)value)) {
                            cell = ReaderTextCell.parseCell(value.toString(), st, cell, this._mmProps);
                            buff.addCell(cell.getI(), cell.getJ(), cell.getV());
                            if (this._mmProps != null && this._mmProps.isSymmetric() && !cell.onDiag()) {
                                buff.addCell(cell.getJ(), cell.getI(), cell.getV());
                            }
                            if (buff.size() < 102400) continue;
                            matrixBlock = this._dest;
                            synchronized (matrixBlock) {
                                lnnz += (long)buff.size();
                                buff.flushCellBufferToMatrixBlock(this._dest);
                            }
                        }
                        matrixBlock = this._dest;
                        synchronized (matrixBlock) {
                            lnnz += (long)buff.size();
                            buff.flushCellBufferToMatrixBlock(this._dest);
                            break block22;
                        }
                    }
                    DenseBlock a = this._dest.getDenseBlock();
                    while (reader.next((Object)key, (Object)value)) {
                        cell = ReaderTextCell.parseCell(value.toString(), st, cell, this._mmProps);
                        lnnz += (long)ReaderTextCell.appendCell(cell, a, this._mmProps);
                    }
                }
                catch (Exception ex) {
                    if (cell.getI() < 0 || (long)(cell.getI() + 1) > this._rlen || cell.getJ() < 0 || (long)(cell.getJ() + 1) > this._clen) {
                        throw new RuntimeException("Matrix cell [" + (cell.getI() + 1) + "," + (cell.getJ() + 1) + "] out of overall matrix range [1:" + this._rlen + ",1:" + this._clen + "]. ", ex);
                    }
                    throw new RuntimeException("Unable to read matrix in text cell format. ", ex);
                }
                finally {
                    IOUtilFunctions.closeSilently(reader);
                }
            }
            return lnnz;
        }
    }
}

