/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.spark;

import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLScriptException;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.frame.data.lib.FrameUtil;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.spark.SPInstruction;
import org.apache.sysds.runtime.instructions.spark.UnarySPInstruction;
import org.apache.sysds.runtime.matrix.operators.Operator;
import scala.Tuple2;

public class UnaryFrameSPInstruction
extends UnarySPInstruction {
    protected UnaryFrameSPInstruction(Operator op, CPOperand in, CPOperand out, String opcode, String instr) {
        super(SPInstruction.SPType.Unary, op, in, out, opcode, instr);
    }

    public static UnaryFrameSPInstruction parseInstruction(String str) {
        CPOperand in = new CPOperand("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
        CPOperand out = new CPOperand("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
        String opcode = UnaryFrameSPInstruction.parseUnaryInstruction(str, in, out);
        return new UnaryFrameSPInstruction(InstructionUtils.parseUnaryOperator(opcode), in, out, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        if (this.getOpcode().equals(Types.OpOp1.DETECTSCHEMA.toString())) {
            this.detectSchema(sec);
        } else if (this.getOpcode().equals(Types.OpOp1.COLNAMES.toString())) {
            this.columnNames(sec);
        } else {
            throw new DMLScriptException("Opcode '" + this.getOpcode() + "' is not a valid UnaryFrameSPInstruction");
        }
    }

    private void columnNames(SparkExecutionContext sec) {
        JavaPairRDD<Long, FrameBlock> in = sec.getFrameBinaryBlockRDDHandleForVariable(this.input1.getName());
        FrameBlock outFrame = ((FrameBlock)in.lookup((Object)1L).get(0)).getColumnNamesAsFrame();
        sec.setFrameOutput(this.output.getName(), outFrame);
    }

    public void detectSchema(SparkExecutionContext sec) {
        JavaPairRDD<Long, FrameBlock> in = sec.getFrameBinaryBlockRDDHandleForVariable(this.input1.getName());
        JavaPairRDD out = in.mapToPair((PairFunction)new DetectSchemaUsingRows());
        FrameBlock outFrame = (FrameBlock)out.values().reduce((Function2)new MergeFrame());
        sec.setFrameOutput(this.output.getName(), outFrame);
    }

    private static class MergeFrame
    implements Function2<FrameBlock, FrameBlock, FrameBlock> {
        private static final long serialVersionUID = 942744896521069893L;

        private MergeFrame() {
        }

        public FrameBlock call(FrameBlock arg0, FrameBlock arg1) throws Exception {
            return new FrameBlock(FrameUtil.mergeSchema(arg0, arg1));
        }
    }

    private static class DetectSchemaUsingRows
    implements PairFunction<Tuple2<Long, FrameBlock>, Long, FrameBlock> {
        private static final long serialVersionUID = 5850400295183766400L;

        private DetectSchemaUsingRows() {
        }

        public Tuple2<Long, FrameBlock> call(Tuple2<Long, FrameBlock> arg0) throws Exception {
            FrameBlock resultBlock = new FrameBlock(((FrameBlock)arg0._2).detectSchema(1));
            return new Tuple2((Object)1L, (Object)resultBlock);
        }
    }
}

