/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.matrix.data;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.api.DMLException;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.data.SparseBlockCOO;
import org.apache.sysds.runtime.data.SparseBlockCSR;
import org.apache.sysds.runtime.data.SparseBlockFactory;
import org.apache.sysds.runtime.instructions.spark.data.CorrMatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.sketch.MatrixSketch;
import org.apache.sysds.runtime.matrix.data.sketch.MatrixSketchFactory;
import org.apache.sysds.runtime.matrix.operators.CountDistinctOperator;
import org.apache.sysds.runtime.matrix.operators.CountDistinctOperatorTypes;
import org.apache.sysds.utils.Hash;

public interface LibMatrixCountDistinct {
    public static final Log LOG = LogFactory.getLog((String)LibMatrixCountDistinct.class.getName());
    public static final int minimumSize = 1024;

    public static MatrixBlock estimateDistinctValues(MatrixBlock in, CountDistinctOperator op) {
        MatrixBlock res;
        long averageNnzPerRowOrCol;
        if (op.getOperatorType() == CountDistinctOperatorTypes.KMV && (op.getHashType() == Hash.HashType.ExpHash || op.getHashType() == Hash.HashType.StandardJava)) {
            throw new DMLException("Invalid hashing configuration using " + op.getHashType() + " and " + op.getOperatorType());
        }
        if (op.getOperatorType() == CountDistinctOperatorTypes.HLL) {
            throw new NotImplementedException("HyperLogLog has not been implemented yet");
        }
        if (in.getLength() == 1L || in.isEmpty()) {
            return new MatrixBlock(1.0);
        }
        if (op.getDirection().isRowCol()) {
            averageNnzPerRowOrCol = in.getNonZeros();
        } else if (op.getDirection().isRow()) {
            averageNnzPerRowOrCol = (long)Math.floor((double)in.getNonZeros() / (double)in.getNumRows());
        } else if (op.getDirection().isCol()) {
            averageNnzPerRowOrCol = (long)Math.floor((double)in.getNonZeros() / (double)in.getNumColumns());
        } else {
            throw new IllegalArgumentException("Unrecognized direction " + op.getDirection());
        }
        if (averageNnzPerRowOrCol < 1024L) {
            res = LibMatrixCountDistinct.countDistinctValuesNaive(in, op);
        } else {
            switch (op.getOperatorType()) {
                case COUNT: {
                    res = LibMatrixCountDistinct.countDistinctValuesNaive(in, op);
                    break;
                }
                case KMV: {
                    res = MatrixSketchFactory.get(op).getValue(in);
                    break;
                }
                default: {
                    throw new DMLException("Invalid estimator type for aggregation: " + LibMatrixCountDistinct.class.getSimpleName());
                }
            }
        }
        return res;
    }

    private static MatrixBlock countDistinctValuesNaive(MatrixBlock blkIn, CountDistinctOperator op) {
        MatrixBlock blkOut;
        block43: {
            double[] data;
            block44: {
                HashSet<Double> distinct;
                block45: {
                    block42: {
                        if (blkIn.isEmpty()) {
                            return new MatrixBlock(1.0);
                        }
                        if (blkIn instanceof CompressedMatrixBlock) {
                            throw new NotImplementedException("countDistinct() does not support CompressedMatrixBlock");
                        }
                        distinct = new HashSet<Double>();
                        if (!op.getDirection().isRowCol()) break block42;
                        blkOut = new MatrixBlock(1, 1, false);
                        long distinctCount = 0L;
                        long nonZeros = blkIn.getNonZeros();
                        if (nonZeros != -1L && nonZeros < (long)blkIn.getNumColumns() * (long)blkIn.getNumRows()) {
                            distinct.add(0.0);
                        }
                        if (blkIn.getSparseBlock() != null) {
                            SparseBlock sb = blkIn.getSparseBlock();
                            if (blkIn.getSparseBlock().isContiguous()) {
                                double[] data2 = sb.values(0);
                                distinctCount = LibMatrixCountDistinct.countDistinctValuesNaive(data2, distinct);
                            } else {
                                for (int i = 0; i < blkIn.getNumRows(); ++i) {
                                    if (sb.isEmpty(i)) continue;
                                    double[] data3 = blkIn.getSparseBlock().values(i);
                                    distinctCount = LibMatrixCountDistinct.countDistinctValuesNaive(data3, distinct);
                                }
                            }
                        } else if (blkIn.getDenseBlock() != null) {
                            DenseBlock db = blkIn.getDenseBlock();
                            for (int i = 0; i <= db.numBlocks(); ++i) {
                                double[] data4 = db.valuesAt(i);
                                distinctCount = LibMatrixCountDistinct.countDistinctValuesNaive(data4, distinct);
                            }
                        }
                        blkOut.setValue(0, 0, distinctCount);
                        break block43;
                    }
                    if (!op.getDirection().isRow()) break block44;
                    blkOut = new MatrixBlock(blkIn.getNumRows(), 1, false, blkIn.getNumRows());
                    blkOut.allocateBlock();
                    if (blkIn.getDenseBlock() == null) break block45;
                    DenseBlock db = blkIn.getDenseBlock();
                    for (int bix = 0; bix < db.numBlocks(); ++bix) {
                        double[] data5 = db.valuesAt(bix);
                        for (int rix = bix * db.blockSize(); rix < blkIn.getNumRows(); ++rix) {
                            distinct.clear();
                            for (int cix = 0; cix < blkIn.getNumColumns(); ++cix) {
                                distinct.add(data5[db.pos(rix, cix)]);
                            }
                            blkOut.setValue(rix, 0, distinct.size());
                        }
                    }
                    break block43;
                }
                if (blkIn.getSparseBlock() == null) break block43;
                SparseBlock sb = blkIn.getSparseBlock();
                if (SparseBlockFactory.isSparseBlockType(sb, SparseBlock.Type.MCSR)) {
                    for (int rix = 0; rix < blkIn.getNumRows(); ++rix) {
                        if (sb.isEmpty(rix)) continue;
                        distinct.clear();
                        double[] data6 = sb.values(rix);
                        LibMatrixCountDistinct.countDistinctValuesNaive(data6, distinct);
                        blkOut.setValue(rix, 0, distinct.size());
                    }
                } else if (SparseBlockFactory.isSparseBlockType(sb, SparseBlock.Type.CSR)) {
                    SparseBlockCSR csrBlock = (SparseBlockCSR)sb;
                    double[] data7 = csrBlock.values();
                    for (int rix = 0; rix < blkIn.getNumRows(); ++rix) {
                        if (csrBlock.isEmpty(rix)) continue;
                        distinct.clear();
                        int rpos = csrBlock.pos(rix);
                        int clen = csrBlock.size(rix);
                        for (int colOffset = 0; colOffset < clen; ++colOffset) {
                            distinct.add(data7[rpos + colOffset]);
                        }
                        blkOut.setValue(rix, 0, distinct.size());
                    }
                } else {
                    if (!(sb instanceof SparseBlockCOO)) {
                        throw new IllegalArgumentException("Input matrix is of unrecognized type: " + sb.getClass().getSimpleName());
                    }
                    SparseBlockCOO cooBlock = (SparseBlockCOO)sb;
                    int[] rixs = cooBlock.rowIndexes();
                    double[] data8 = cooBlock.values();
                    int rix = 0;
                    for (int i = 0; rix < cooBlock.numRows() && i < rixs.length; ++i) {
                        distinct.clear();
                        while (i + 1 < rixs.length && rixs[i] == rixs[i + 1]) {
                            distinct.add(data8[i]);
                            ++i;
                        }
                        if (i + 1 < rixs.length) {
                            distinct.add(data8[i]);
                        }
                        blkOut.setValue(rix, 0, distinct.size());
                        rix = i + 1 < rixs.length ? rixs[i + 1] : rix;
                    }
                }
                break block43;
            }
            blkOut = new MatrixBlock(1, blkIn.getNumColumns(), false, blkIn.getNumColumns());
            blkOut.allocateBlock();
            HashMap<Integer, Set> distinctValuesByCol = new HashMap<Integer, Set>();
            if (blkIn.getDenseBlock() != null) {
                DenseBlock db = blkIn.getDenseBlock();
                for (int bix = 0; bix < db.numBlocks(); ++bix) {
                    data = db.valuesAt(bix);
                    for (int cix = 0; cix < blkIn.getNumColumns(); ++cix) {
                        Set distinctValues = distinctValuesByCol.getOrDefault(cix, new HashSet());
                        for (int rix = bix * db.blockSize(); rix < blkIn.getNumRows(); ++rix) {
                            double val = data[db.pos(rix, cix)];
                            distinctValues.add(val);
                        }
                        distinctValuesByCol.put(cix, distinctValues);
                    }
                }
            } else if (blkIn.getSparseBlock() != null) {
                SparseBlock sb = blkIn.getSparseBlock();
                if (SparseBlockFactory.isSparseBlockType(sb, SparseBlock.Type.MCSR)) {
                    for (int rix = 0; rix < blkIn.getNumRows(); ++rix) {
                        if (sb.isEmpty(rix)) continue;
                        int[] cixs = sb.indexes(rix);
                        data = sb.values(rix);
                        for (int j = 0; j < sb.size(rix); ++j) {
                            int cix = cixs[j];
                            Set distinctValues = distinctValuesByCol.getOrDefault(cix, new HashSet());
                            distinctValues.add(data[j]);
                            distinctValuesByCol.put(cix, distinctValues);
                        }
                    }
                } else if (SparseBlockFactory.isSparseBlockType(sb, SparseBlock.Type.CSR)) {
                    SparseBlockCSR csrBlock = (SparseBlockCSR)sb;
                    data = csrBlock.values();
                    for (int rix = 0; rix < blkIn.getNumRows(); ++rix) {
                        if (csrBlock.isEmpty(rix)) continue;
                        int rpos = csrBlock.pos(rix);
                        int clen = csrBlock.size(rix);
                        int[] cixs = csrBlock.indexes();
                        for (int colOffset = 0; colOffset < clen; ++colOffset) {
                            int cix = cixs[rpos + colOffset];
                            Set distinctValues = distinctValuesByCol.getOrDefault(cix, new HashSet());
                            distinctValues.add(data[rpos + colOffset]);
                            distinctValuesByCol.put(cix, distinctValues);
                        }
                    }
                } else {
                    if (!(sb instanceof SparseBlockCOO)) {
                        throw new IllegalArgumentException("Input matrix is of unrecognized type: " + sb.getClass().getSimpleName());
                    }
                    SparseBlockCOO cooBlock = (SparseBlockCOO)sb;
                    int[] rixs = cooBlock.rowIndexes();
                    int[] cixs = cooBlock.indexes();
                    data = cooBlock.values();
                    for (int i = 0; i < rixs.length; ++i) {
                        Set distinctValues;
                        int cix;
                        while (i + 1 < rixs.length && rixs[i] == rixs[i + 1]) {
                            cix = cixs[i];
                            distinctValues = distinctValuesByCol.getOrDefault(cix, new HashSet());
                            distinctValues.add(data[i]);
                            distinctValuesByCol.put(cix, distinctValues);
                            ++i;
                        }
                        if (i + 1 >= rixs.length) continue;
                        cix = cixs[i];
                        distinctValues = distinctValuesByCol.getOrDefault(cix, new HashSet());
                        distinctValues.add(data[i]);
                        distinctValuesByCol.put(cix, distinctValues);
                    }
                }
            }
            Iterator iterator = distinctValuesByCol.keySet().iterator();
            while (iterator.hasNext()) {
                int cix = (Integer)iterator.next();
                blkOut.setValue(0, cix, ((Set)distinctValuesByCol.get(cix)).size());
            }
        }
        return blkOut;
    }

    private static long countDistinctValuesNaive(double[] valuesPart, Set<Double> distinct) {
        for (double v : valuesPart) {
            distinct.add(v);
        }
        return distinct.size();
    }

    public static MatrixBlock countDistinctValuesFromSketch(CountDistinctOperator op, CorrMatrixBlock corrBlkIn) {
        MatrixSketch sketch = MatrixSketchFactory.get(op);
        return sketch.getValueFromSketch(corrBlkIn);
    }

    public static CorrMatrixBlock createSketch(CountDistinctOperator op, MatrixBlock blkIn) {
        MatrixSketch sketch = MatrixSketchFactory.get(op);
        return sketch.create(blkIn);
    }

    public static CorrMatrixBlock unionSketch(CountDistinctOperator op, CorrMatrixBlock corrBlkIn0, CorrMatrixBlock corrBlkIn1) {
        MatrixSketch sketch = MatrixSketchFactory.get(op);
        return sketch.union(corrBlkIn0, corrBlkIn1);
    }
}

