/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import org.apache.sysds.runtime.compress.colgroup.AOffsetsGroup;
import org.apache.sysds.runtime.compress.colgroup.APreAgg;
import org.apache.sysds.runtime.compress.colgroup.IContainDefaultTuple;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IDictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.MatrixBlockDictionary;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.offset.AIterator;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffset;
import org.apache.sysds.runtime.compress.colgroup.scheme.ICLAScheme;
import org.apache.sysds.runtime.compress.colgroup.scheme.SDCScheme;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;
import org.apache.sysds.runtime.compress.estim.EstimationFactors;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public abstract class ASDCZero
extends APreAgg
implements AOffsetsGroup,
IContainDefaultTuple {
    private static final long serialVersionUID = -69266306137398807L;
    protected final AOffset _indexes;
    protected final int _numRows;

    protected ASDCZero(IColIndex colIndices, int numRows, IDictionary dict, AOffset offsets, int[] cachedCounts) {
        super(colIndices, dict, cachedCounts);
        this._indexes = offsets;
        this._numRows = numRows;
    }

    public int getNumRows() {
        return this._numRows;
    }

    @Override
    public final void leftMultByMatrixNoPreAgg(MatrixBlock matrix, MatrixBlock result, int rl, int ru, int cl, int cu) {
        AIterator it = this._indexes.getIterator(cl);
        if (it == null) {
            return;
        }
        if (it.value() > cu) {
            this._indexes.cacheIterator(it, cu);
        } else if (rl == ru - 1) {
            this.leftMultByMatrixNoPreAggSingleRow(matrix, result, rl, cl, cu, it);
        } else {
            this.leftMultByMatrixNoPreAggRows(matrix, result, rl, ru, cl, cu, it);
        }
    }

    private final void leftMultByMatrixNoPreAggSingleRow(MatrixBlock mb, MatrixBlock result, int r, int cl, int cu, AIterator it) {
        double[] resV = result.getDenseBlockValues();
        int nCols = result.getNumColumns();
        int offRet = nCols * r;
        if (mb.isInSparseFormat()) {
            SparseBlock sb = mb.getSparseBlock();
            this.leftMultByMatrixNoPreAggSingleRowSparse(sb, resV, offRet, r, cu, it);
        } else {
            DenseBlock db = mb.getDenseBlock();
            double[] mV = db.values(r);
            int off = db.pos(r);
            this.leftMultByMatrixNoPreAggSingleRowDense(mV, off, resV, offRet, r, cl, cu, it);
        }
    }

    private final void leftMultByMatrixNoPreAggSingleRowDense(double[] mV, int off, double[] resV, int offRet, int r, int cl, int cu, AIterator it) {
        int last = this._indexes.getOffsetToLast();
        while (it.isNotOver(cu)) {
            this.multiplyScalar(mV[off + it.value()], resV, offRet, it);
            if (it.value() >= last) break;
            it.next();
        }
        this._indexes.cacheIterator(it, cu);
    }

    private final void leftMultByMatrixNoPreAggSingleRowSparse(SparseBlock sb, double[] resV, int offRet, int r, int cu, AIterator it) {
        int apos;
        if (sb.isEmpty(r)) {
            return;
        }
        int last = this._indexes.getOffsetToLast();
        int alen = sb.size(r) + apos;
        int[] aix = sb.indexes(r);
        double[] aval = sb.values(r);
        int v = it.value();
        for (apos = sb.pos(r); apos < alen && aix[apos] < v; ++apos) {
        }
        if (cu < last) {
            while (v < cu && apos < alen) {
                if (aix[apos] == v) {
                    this.multiplyScalar(aval[apos++], resV, offRet, it);
                    v = it.next();
                    continue;
                }
                if (aix[apos] < v) {
                    ++apos;
                    continue;
                }
                v = it.next();
            }
        } else if (aix[alen - 1] < last) {
            while (apos < alen) {
                if (aix[apos] == v) {
                    this.multiplyScalar(aval[apos++], resV, offRet, it);
                    v = it.next();
                    continue;
                }
                if (aix[apos] < v) {
                    ++apos;
                    continue;
                }
                v = it.next();
            }
        } else {
            while (v < last) {
                if (aix[apos] == v) {
                    this.multiplyScalar(aval[apos++], resV, offRet, it);
                    v = it.next();
                    continue;
                }
                if (aix[apos] < v) {
                    ++apos;
                    continue;
                }
                v = it.next();
            }
            while (aix[apos] < last && apos < alen) {
                ++apos;
            }
            if (last == aix[apos]) {
                this.multiplyScalar(aval[apos], resV, offRet, it);
            }
        }
    }

    private final void leftMultByMatrixNoPreAggRows(MatrixBlock mb, MatrixBlock result, int rl, int ru, int cl, int cu, AIterator it) {
        double[] resV = result.getDenseBlockValues();
        int nCols = result.getNumColumns();
        if (mb.isInSparseFormat()) {
            this.leftMultByMatrixNoPreAggRowsSparse(mb.getSparseBlock(), resV, nCols, rl, ru, cl, cu, it);
        } else {
            this.leftMultByMatrixNoPreAggRowsDense(mb, resV, nCols, rl, ru, cl, cu, it);
        }
    }

    private final void leftMultByMatrixNoPreAggRowsSparse(SparseBlock sb, double[] resV, int nCols, int rl, int ru, int cl, int cu, AIterator it) {
        for (int r = rl; r < ru; ++r) {
            int offRet = nCols * r;
            this.leftMultByMatrixNoPreAggSingleRowSparse(sb, resV, offRet, r, cu, it.clone());
        }
    }

    private final void leftMultByMatrixNoPreAggRowsDense(MatrixBlock mb, double[] resV, int nCols, int rl, int ru, int cl, int cu, AIterator it) {
        DenseBlock db = mb.getDenseBlock();
        for (int r = rl; r < ru; ++r) {
            double[] mV = db.values(r);
            int off = db.pos(r);
            int offRet = nCols * r;
            this.leftMultByMatrixNoPreAggSingleRowDense(mV, off, resV, offRet, r, cl, cu, it.clone());
        }
    }

    protected abstract void multiplyScalar(double var1, double[] var3, int var4, AIterator var5);

    public void decompressToDenseBlock(DenseBlock db, int rl, int ru, int offR, int offC, AIterator it) {
        if (this._dict instanceof MatrixBlockDictionary) {
            MatrixBlockDictionary md = (MatrixBlockDictionary)this._dict;
            MatrixBlock mb = md.getMatrixBlock();
            if (mb.isInSparseFormat()) {
                this.decompressToDenseBlockSparseDictionary(db, rl, ru, offR, offC, mb.getSparseBlock());
            } else {
                this.decompressToDenseBlockDenseDictionaryWithProvidedIterator(db, rl, ru, offR, offC, mb.getDenseBlockValues(), it);
            }
        } else {
            this.decompressToDenseBlockDenseDictionaryWithProvidedIterator(db, rl, ru, offR, offC, this._dict.getValues(), it);
        }
    }

    public void decompressToDenseBlockDenseDictionary(DenseBlock db, int rl, int ru, int offR, int offC, AIterator it) {
        this.decompressToDenseBlockDenseDictionaryWithProvidedIterator(db, rl, ru, offR, offC, this._dict.getValues(), it);
    }

    public abstract void decompressToDenseBlockDenseDictionaryWithProvidedIterator(DenseBlock var1, int var2, int var3, int var4, int var5, double[] var6, AIterator var7);

    public AIterator getIterator(int row) {
        return this._indexes.getIterator(row);
    }

    @Override
    public AOffset getOffsets() {
        return this._indexes;
    }

    public abstract int getNumberOffsets();

    @Override
    public double[] getDefaultTuple() {
        return new double[this._colIndexes.size()];
    }

    @Override
    public final CompressedSizeInfoColGroup getCompressionInfo(int nRow) {
        EstimationFactors ef = new EstimationFactors(this.getNumValues(), this._numRows, this.getNumberOffsets(), this._dict.getSparsity());
        return new CompressedSizeInfoColGroup(this._colIndexes, ef, nRow, this.getCompType(), this.getEncoding());
    }

    @Override
    public ICLAScheme getCompressionScheme() {
        return SDCScheme.create(this);
    }
}

