/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.security.token;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class JobTokenIdentifier
extends TokenIdentifier {
    private Text jobid;
    public static final Text KIND_NAME = new Text("mapreduce.job");

    public JobTokenIdentifier() {
        this.jobid = new Text();
    }

    public JobTokenIdentifier(Text jobid) {
        this.jobid = jobid;
    }

    public Text getKind() {
        return KIND_NAME;
    }

    public UserGroupInformation getUser() {
        if (this.jobid == null || "".equals(this.jobid.toString())) {
            return null;
        }
        return UserGroupInformation.createRemoteUser((String)this.jobid.toString());
    }

    public Text getJobId() {
        return this.jobid;
    }

    public void readFields(DataInput in) throws IOException {
        this.jobid.readFields(in);
    }

    public void write(DataOutput out) throws IOException {
        this.jobid.write(out);
    }

    @InterfaceAudience.Private
    public static class Renewer
    extends Token.TrivialRenewer {
        protected Text getKind() {
            return KIND_NAME;
        }
    }
}

