/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.io.FileFormatPropertiesCSV;
import org.apache.sysds.runtime.io.FrameReaderTextCSV;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.matrix.data.FrameBlock;
import org.apache.sysds.runtime.matrix.data.Pair;
import org.apache.sysds.runtime.util.CommonThreadPool;

public class FrameReaderTextCSVParallel
extends FrameReaderTextCSV {
    public FrameReaderTextCSVParallel(FileFormatPropertiesCSV props) {
        super(props);
    }

    @Override
    protected void readCSVFrameFromHDFS(Path path, JobConf job, FileSystem fs, FrameBlock dest, Types.ValueType[] schema, String[] names, long rlen, long clen) throws IOException {
        int numThreads = OptimizerUtils.getParallelTextReadParallelism();
        TextInputFormat informat = new TextInputFormat();
        informat.configure(job);
        InputSplit[] splits = informat.getSplits(job, numThreads);
        splits = IOUtilFunctions.sortInputSplits(splits);
        try {
            ExecutorService pool = CommonThreadPool.get(Math.min(numThreads, splits.length));
            ArrayList<CountRowsTask> tasks = new ArrayList<CountRowsTask>();
            for (int i = 0; i < splits.length; ++i) {
                tasks.add(new CountRowsTask(splits[i], informat, job, this._props.hasHeader(), i == 0));
            }
            List cret = pool.invokeAll(tasks);
            long offset = 0L;
            ArrayList<Long> offsets = new ArrayList<Long>();
            for (Future count : cret) {
                offsets.add(offset);
                offset += ((Long)count.get()).longValue();
            }
            ArrayList<ReadRowsTask> tasks2 = new ArrayList<ReadRowsTask>();
            for (int i = 0; i < splits.length; ++i) {
                tasks2.add(new ReadRowsTask(splits[i], informat, job, dest, ((Long)offsets.get(i)).intValue(), i == 0));
            }
            CommonThreadPool.invokeAndShutdown(pool, tasks2);
        }
        catch (Exception e) {
            throw new IOException("Failed parallel read of text csv input.", e);
        }
    }

    @Override
    protected Pair<Integer, Integer> computeCSVSize(Path path, JobConf job, FileSystem fs) throws IOException {
        int numThreads = OptimizerUtils.getParallelTextReadParallelism();
        TextInputFormat informat = new TextInputFormat();
        informat.configure(job);
        InputSplit[] splits = informat.getSplits(job, numThreads);
        int ncol = IOUtilFunctions.countNumColumnsCSV(splits, (InputFormat)informat, job, this._props.getDelim());
        int nrow = 0;
        ExecutorService pool = CommonThreadPool.get(numThreads);
        try {
            ArrayList<CountRowsTask> tasks = new ArrayList<CountRowsTask>();
            for (int i = 0; i < splits.length; ++i) {
                tasks.add(new CountRowsTask(splits[i], informat, job, this._props.hasHeader(), i == 0));
            }
            List cret = pool.invokeAll(tasks);
            for (Future count : cret) {
                nrow += ((Long)count.get()).intValue();
            }
        }
        catch (Exception e) {
            throw new IOException("Failed parallel read of text csv input.", e);
        }
        finally {
            pool.shutdown();
        }
        return new Pair<Integer, Integer>(nrow, ncol);
    }

    private class ReadRowsTask
    implements Callable<Object> {
        private InputSplit _split = null;
        private TextInputFormat _informat = null;
        private JobConf _job = null;
        private FrameBlock _dest = null;
        private int _offset = -1;
        private boolean _isFirstSplit = false;

        public ReadRowsTask(InputSplit split, TextInputFormat informat, JobConf job, FrameBlock dest, int offset, boolean first) {
            this._split = split;
            this._informat = informat;
            this._job = job;
            this._dest = dest;
            this._offset = offset;
            this._isFirstSplit = first;
        }

        @Override
        public Object call() throws Exception {
            FrameReaderTextCSVParallel.this.readCSVFrameFromInputSplit(this._split, (InputFormat<LongWritable, Text>)this._informat, this._job, this._dest, this._dest.getSchema(), this._dest.getColumnNames(), this._dest.getNumRows(), this._dest.getNumColumns(), this._offset, this._isFirstSplit);
            return null;
        }
    }

    private static class CountRowsTask
    implements Callable<Long> {
        private InputSplit _split = null;
        private TextInputFormat _informat = null;
        private JobConf _job = null;
        private boolean _hasHeader = false;
        private boolean _firstSplit = false;

        public CountRowsTask(InputSplit split, TextInputFormat informat, JobConf job, boolean hasHeader, boolean first) {
            this._split = split;
            this._informat = informat;
            this._job = job;
            this._hasHeader = hasHeader;
            this._firstSplit = first;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long call() throws Exception {
            RecordReader reader = this._informat.getRecordReader(this._split, this._job, Reporter.NULL);
            LongWritable key = new LongWritable();
            Text value = new Text();
            long nrows = 0L;
            try {
                if (this._firstSplit && this._hasHeader) {
                    reader.next((Object)key, (Object)value);
                }
                while (reader.next((Object)key, (Object)value)) {
                    String val = value.toString();
                    nrows += val.startsWith("#Meta\u00b7MV") || val.startsWith("#Meta\u00b7ND") ? 0L : 1L;
                }
            }
            finally {
                IOUtilFunctions.closeSilently(reader);
            }
            return nrows;
        }
    }
}

