/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.mapping;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToBit;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToByte;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToUByte;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToZero;
import org.apache.sysds.utils.MemoryEstimates;

public class MapToChar
extends AMapToData {
    private static final long serialVersionUID = 6315708056775476541L;
    private final char[] _data;

    protected MapToChar(int size) {
        this(65535, size);
    }

    public MapToChar(int unique, int size) {
        super(Math.min(unique, 65536));
        this._data = new char[size];
    }

    public MapToChar(int unique, char[] data) {
        super(unique);
        this._data = data;
    }

    @Override
    public MapToFactory.MAP_TYPE getType() {
        return MapToFactory.MAP_TYPE.CHAR;
    }

    @Override
    public int getIndex(int n) {
        return this._data[n];
    }

    @Override
    public void fill(int v) {
        Arrays.fill(this._data, (char)v);
    }

    @Override
    public long getInMemorySize() {
        return MapToChar.getInMemorySize(this._data.length);
    }

    public static long getInMemorySize(int dataLength) {
        long size = 24L;
        return size += MemoryEstimates.charArrayCost(dataLength);
    }

    @Override
    public long getExactSizeOnDisk() {
        return 9 + this._data.length * 2;
    }

    @Override
    public void set(int n, int v) {
        this._data[n] = (char)v;
    }

    @Override
    public int setAndGet(int n, int v) {
        this._data[n] = (char)v;
        return this._data[n];
    }

    @Override
    public int size() {
        return this._data.length;
    }

    @Override
    public void replace(int v, int r) {
        char cv = (char)v;
        char rv = (char)r;
        for (int i = 0; i < this.size(); ++i) {
            if (this._data[i] != cv) continue;
            this._data[i] = rv;
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(MapToFactory.MAP_TYPE.CHAR.ordinal());
        out.writeInt(this.getUnique());
        out.writeInt(this._data.length);
        for (int i = 0; i < this._data.length; ++i) {
            out.writeChar(this._data[i]);
        }
    }

    protected static MapToChar readFields(DataInput in) throws IOException {
        int unique = in.readInt();
        int length = in.readInt();
        char[] data = new char[length];
        for (int i = 0; i < length; ++i) {
            data[i] = in.readChar();
        }
        return new MapToChar(unique, data);
    }

    protected char[] getChars() {
        return this._data;
    }

    @Override
    protected void preAggregateDenseToRowBy8(double[] mV, double[] preAV, int cl, int cu, int off) {
        int h = (cu - cl) % 8;
        off += cl;
        int rc = cl;
        while (rc < cl + h) {
            char c = this._data[rc];
            preAV[c] = preAV[c] + mV[off];
            ++rc;
            ++off;
        }
        rc = cl + h;
        while (rc < cu) {
            char c = this._data[rc];
            preAV[c] = preAV[c] + mV[off];
            char c2 = this._data[rc + 1];
            preAV[c2] = preAV[c2] + mV[off + 1];
            char c3 = this._data[rc + 2];
            preAV[c3] = preAV[c3] + mV[off + 2];
            char c4 = this._data[rc + 3];
            preAV[c4] = preAV[c4] + mV[off + 3];
            char c5 = this._data[rc + 4];
            preAV[c5] = preAV[c5] + mV[off + 4];
            char c6 = this._data[rc + 5];
            preAV[c6] = preAV[c6] + mV[off + 5];
            char c7 = this._data[rc + 6];
            preAV[c7] = preAV[c7] + mV[off + 6];
            char c8 = this._data[rc + 7];
            preAV[c8] = preAV[c8] + mV[off + 7];
            rc += 8;
            off += 8;
        }
    }

    @Override
    protected void preAggregateDenseMultiRowContiguousBy8(double[] mV, int nCol, int nVal, double[] preAV, int rl, int ru, int cl, int cu) {
        int h = (cu - cl) % 8;
        this.preAggregateDenseMultiRowContiguousBy1(mV, nCol, nVal, preAV, rl, ru, cl, cl + h);
        int offR = nCol * rl;
        int offE = nCol * ru;
        for (int c = cl + h; c < cu; c += 8) {
            char id1 = this._data[c];
            char id2 = this._data[c + 1];
            char id3 = this._data[c + 2];
            char id4 = this._data[c + 3];
            char id5 = this._data[c + 4];
            char id6 = this._data[c + 5];
            char id7 = this._data[c + 6];
            char id8 = this._data[c + 7];
            int start = c + offR;
            int end = c + offE;
            int nValOff = 0;
            for (int off = start; off < end; off += nCol) {
                int n = id1 + nValOff;
                preAV[n] = preAV[n] + mV[off];
                int n2 = id2 + nValOff;
                preAV[n2] = preAV[n2] + mV[off + 1];
                int n3 = id3 + nValOff;
                preAV[n3] = preAV[n3] + mV[off + 2];
                int n4 = id4 + nValOff;
                preAV[n4] = preAV[n4] + mV[off + 3];
                int n5 = id5 + nValOff;
                preAV[n5] = preAV[n5] + mV[off + 4];
                int n6 = id6 + nValOff;
                preAV[n6] = preAV[n6] + mV[off + 5];
                int n7 = id7 + nValOff;
                preAV[n7] = preAV[n7] + mV[off + 6];
                int n8 = id8 + nValOff;
                preAV[n8] = preAV[n8] + mV[off + 7];
                nValOff += nVal;
            }
        }
    }

    @Override
    public int getUpperBoundValue() {
        return 65535;
    }

    @Override
    public void copyInt(int[] d) {
        for (int i = 0; i < this._data.length; ++i) {
            this._data[i] = (char)d[i];
        }
    }

    @Override
    public void copyBit(BitSet d) {
        int i = d.nextSetBit(0);
        while (i >= 0) {
            this._data[i] = '\u0001';
            i = d.nextSetBit(i + 1);
        }
    }

    @Override
    public void count(int[] ret) {
        for (int i = 0; i < this._data.length; ++i) {
            char c = this._data[i];
            ret[c] = ret[c] + 1;
        }
    }

    @Override
    public AMapToData resize(int unique) {
        AMapToData ret;
        int size = this._data.length;
        if (unique <= 1) {
            return new MapToZero(size);
        }
        if (unique == 2 && size > 32) {
            ret = new MapToBit(unique, size);
        } else if (unique <= 127) {
            ret = new MapToUByte(unique, size);
        } else if (unique < 256) {
            ret = new MapToByte(unique, size);
        } else {
            this.setUnique(unique);
            return this;
        }
        ((AMapToData)ret).copy(this);
        return ret;
    }
}

