/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.common;

import java.util.Arrays;
import java.util.HashMap;
import org.apache.sysds.runtime.DMLRuntimeException;

public class Types {

    public static interface FunctionBlock {
        public FunctionBlock cloneFunctionBlock();
    }

    public static enum FileFormat {
        TEXT,
        MM,
        CSV,
        LIBSVM,
        JSONL,
        BINARY,
        FEDERATED,
        PROTO,
        HDF5;


        public boolean isIJV() {
            return this == TEXT || this == MM;
        }

        public boolean isTextFormat() {
            return this != BINARY;
        }

        public static boolean isTextFormat(String fmt) {
            try {
                return FileFormat.valueOf(fmt.toUpperCase()).isTextFormat();
            }
            catch (Exception ex) {
                return false;
            }
        }

        public boolean isDelimitedFormat() {
            return this == CSV || this == LIBSVM;
        }

        public static boolean isDelimitedFormat(String fmt) {
            try {
                return FileFormat.valueOf(fmt.toUpperCase()).isDelimitedFormat();
            }
            catch (Exception ex) {
                return false;
            }
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        public static FileFormat defaultFormat() {
            return TEXT;
        }

        public static String defaultFormatString() {
            return FileFormat.defaultFormat().toString();
        }

        public static FileFormat safeValueOf(String fmt) {
            try {
                return FileFormat.valueOf(fmt.toUpperCase());
            }
            catch (Exception ex) {
                throw new DMLRuntimeException("Unknown file format: " + fmt + " (valid values: " + Arrays.toString((Object[])FileFormat.values()) + ")");
            }
        }
    }

    public static enum OpOpData {
        PERSISTENTREAD,
        PERSISTENTWRITE,
        TRANSIENTREAD,
        TRANSIENTWRITE,
        FUNCTIONOUTPUT,
        SQLREAD,
        FEDERATED;


        public boolean isTransient() {
            return this == TRANSIENTREAD || this == TRANSIENTWRITE;
        }

        public boolean isPersistent() {
            return this == PERSISTENTREAD || this == PERSISTENTWRITE;
        }

        public boolean isWrite() {
            return this == TRANSIENTWRITE || this == PERSISTENTWRITE;
        }

        public boolean isRead() {
            return this == TRANSIENTREAD || this == PERSISTENTREAD;
        }

        public String toString() {
            switch (this) {
                case PERSISTENTREAD: {
                    return "PRead";
                }
                case PERSISTENTWRITE: {
                    return "PWrite";
                }
                case TRANSIENTREAD: {
                    return "TRead";
                }
                case TRANSIENTWRITE: {
                    return "TWrite";
                }
                case FUNCTIONOUTPUT: {
                    return "FunOut";
                }
                case SQLREAD: {
                    return "Sql";
                }
                case FEDERATED: {
                    return "Fed";
                }
            }
            return "Invalid";
        }
    }

    public static enum OpOpDG {
        RAND,
        SEQ,
        FRAMEINIT,
        SINIT,
        SAMPLE,
        TIME;

    }

    public static enum OpOpDnn {
        MAX_POOL,
        MAX_POOL_BACKWARD,
        AVG_POOL,
        AVG_POOL_BACKWARD,
        CONV2D,
        CONV2D_BACKWARD_FILTER,
        CONV2D_BACKWARD_DATA,
        BIASADD,
        BIASMULT,
        BATCH_NORM2D_TEST,
        CHANNEL_SUMS,
        UPDATE_NESTEROV_X,
        CONV2D_BIAS_ADD,
        RELU_MAX_POOL,
        RELU_MAX_POOL_BACKWARD,
        RELU_BACKWARD;

    }

    public static enum ParamBuiltinOp {
        AUTODIFF,
        INVALID,
        CDF,
        INVCDF,
        GROUPEDAGG,
        RMEMPTY,
        REPLACE,
        REXPAND,
        LOWER_TRI,
        UPPER_TRI,
        TRANSFORMAPPLY,
        TRANSFORMDECODE,
        TRANSFORMCOLMAP,
        TRANSFORMMETA,
        TOKENIZE,
        TOSTRING,
        LIST,
        PARAMSERV;

    }

    public static enum ReOrgOp {
        DIAG,
        RESHAPE,
        REV,
        SORT,
        TRANS;


        public String toString() {
            switch (this) {
                case DIAG: {
                    return "rdiag";
                }
                case TRANS: {
                    return "r'";
                }
                case RESHAPE: {
                    return "rshape";
                }
            }
            return this.name().toLowerCase();
        }

        public static ReOrgOp valueOfByOpcode(String opcode) {
            switch (opcode) {
                case "rdiag": {
                    return DIAG;
                }
                case "r'": {
                    return TRANS;
                }
                case "rshape": {
                    return RESHAPE;
                }
            }
            return ReOrgOp.valueOf(opcode.toUpperCase());
        }
    }

    public static enum OpOpN {
        PRINTF,
        CBIND,
        RBIND,
        MIN,
        MAX,
        PLUS,
        EVAL,
        LIST;


        public boolean isCellOp() {
            return this == MIN || this == MAX || this == PLUS;
        }
    }

    public static enum OpOp4 {
        WSLOSS,
        WSIGMOID,
        WDIVMM,
        WCEMM,
        WUMM;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum OpOp3 {
        QUANTILE,
        INTERQUANTILE,
        CTABLE,
        MOMENT,
        COV,
        PLUS_MULT,
        MINUS_MULT,
        IFELSE,
        MAP;


        public String toString() {
            switch (this) {
                case MOMENT: {
                    return "cm";
                }
                case PLUS_MULT: {
                    return "+*";
                }
                case MINUS_MULT: {
                    return "-*";
                }
                case MAP: {
                    return "_map";
                }
            }
            return this.name().toLowerCase();
        }

        public static OpOp3 valueOfByOpcode(String opcode) {
            switch (opcode) {
                case "cm": {
                    return MOMENT;
                }
                case "+*": {
                    return PLUS_MULT;
                }
                case "-*": {
                    return MINUS_MULT;
                }
                case "map": {
                    return MAP;
                }
            }
            return OpOp3.valueOf(opcode.toUpperCase());
        }
    }

    public static enum OpOp2 {
        AND(true),
        BITWAND(true),
        BITWOR(true),
        BITWSHIFTL(true),
        BITWSHIFTR(true),
        BITWXOR(true),
        CBIND(false),
        CONCAT(false),
        COV(false),
        DIV(true),
        DROP_INVALID_TYPE(false),
        DROP_INVALID_LENGTH(false),
        EQUAL(true),
        FRAME_ROW_REPLICATE(true),
        GREATER(true),
        GREATEREQUAL(true),
        INTDIV(true),
        INTERQUANTILE(false),
        IQM(false),
        LESS(true),
        LESSEQUAL(true),
        LOG(true),
        MAX(true),
        MEDIAN(false),
        MIN(true),
        MINUS(true),
        MODULUS(true),
        MOMENT(false),
        MULT(true),
        NOTEQUAL(true),
        OR(true),
        PLUS(true),
        POW(true),
        PRINT(false),
        QUANTILE(false),
        SOLVE(false),
        RBIND(false),
        VALUE_SWAP(false),
        XOR(true),
        MINUS_NZ(false),
        LOG_NZ(false),
        MINUS1_MULT(false);

        private final boolean _validOuter;

        private OpOp2(boolean outer) {
            this._validOuter = outer;
        }

        public boolean isValidOuter() {
            return this._validOuter;
        }

        public String toString() {
            switch (this) {
                case PLUS: {
                    return "+";
                }
                case MINUS: {
                    return "-";
                }
                case MINUS_NZ: {
                    return "-nz";
                }
                case MINUS1_MULT: {
                    return "1-*";
                }
                case MULT: {
                    return "*";
                }
                case DIV: {
                    return "/";
                }
                case MODULUS: {
                    return "%%";
                }
                case INTDIV: {
                    return "%/%";
                }
                case LESSEQUAL: {
                    return "<=";
                }
                case LESS: {
                    return "<";
                }
                case GREATEREQUAL: {
                    return ">=";
                }
                case GREATER: {
                    return ">";
                }
                case EQUAL: {
                    return "==";
                }
                case NOTEQUAL: {
                    return "!=";
                }
                case OR: {
                    return "||";
                }
                case AND: {
                    return "&&";
                }
                case POW: {
                    return "^";
                }
                case IQM: {
                    return "IQM";
                }
                case MOMENT: {
                    return "cm";
                }
                case BITWAND: {
                    return "bitwAnd";
                }
                case BITWOR: {
                    return "bitwOr";
                }
                case BITWXOR: {
                    return "bitwXor";
                }
                case BITWSHIFTL: {
                    return "bitwShiftL";
                }
                case BITWSHIFTR: {
                    return "bitwShiftR";
                }
                case DROP_INVALID_TYPE: {
                    return "dropInvalidType";
                }
                case DROP_INVALID_LENGTH: {
                    return "dropInvalidLength";
                }
                case FRAME_ROW_REPLICATE: {
                    return "freplicate";
                }
                case VALUE_SWAP: {
                    return "valueSwap";
                }
            }
            return this.name().toLowerCase();
        }

        public static OpOp2 valueOfByOpcode(String opcode) {
            switch (opcode) {
                case "+": {
                    return PLUS;
                }
                case "-": {
                    return MINUS;
                }
                case "-nz": {
                    return MINUS_NZ;
                }
                case "1-*": {
                    return MINUS1_MULT;
                }
                case "*": {
                    return MULT;
                }
                case "/": {
                    return DIV;
                }
                case "%%": {
                    return MODULUS;
                }
                case "%/%": {
                    return INTDIV;
                }
                case "<=": {
                    return LESSEQUAL;
                }
                case "<": {
                    return LESS;
                }
                case ">=": {
                    return GREATEREQUAL;
                }
                case ">": {
                    return GREATER;
                }
                case "==": {
                    return EQUAL;
                }
                case "!=": {
                    return NOTEQUAL;
                }
                case "||": {
                    return OR;
                }
                case "&&": {
                    return AND;
                }
                case "^": {
                    return POW;
                }
                case "IQM": {
                    return IQM;
                }
                case "cm": {
                    return MOMENT;
                }
                case "bitwAnd": {
                    return BITWAND;
                }
                case "bitwOr": {
                    return BITWOR;
                }
                case "bitwXor": {
                    return BITWXOR;
                }
                case "bitwShiftL": {
                    return BITWSHIFTL;
                }
                case "bitwShiftR": {
                    return BITWSHIFTR;
                }
                case "dropInvalidType": {
                    return DROP_INVALID_TYPE;
                }
                case "dropInvalidLength": {
                    return DROP_INVALID_LENGTH;
                }
                case "freplicate": {
                    return FRAME_ROW_REPLICATE;
                }
                case "valueSwap": {
                    return VALUE_SWAP;
                }
            }
            return OpOp2.valueOf(opcode.toUpperCase());
        }
    }

    public static enum OpOp1 {
        ABS,
        ACOS,
        ASIN,
        ASSERT,
        ATAN,
        BROADCAST,
        CAST_AS_FRAME,
        CAST_AS_LIST,
        CAST_AS_MATRIX,
        CAST_AS_SCALAR,
        CAST_AS_BOOLEAN,
        CAST_AS_DOUBLE,
        CAST_AS_INT,
        CEIL,
        CHOLESKY,
        COS,
        COSH,
        CUMMAX,
        CUMMIN,
        CUMPROD,
        CUMSUM,
        CUMSUMPROD,
        DETECTSCHEMA,
        COLNAMES,
        EIGEN,
        EXISTS,
        EXP,
        FLOOR,
        INVERSE,
        IQM,
        ISNA,
        ISNAN,
        ISINF,
        LENGTH,
        LINEAGE,
        LOG,
        NCOL,
        NOT,
        NROW,
        MEDIAN,
        PREFETCH,
        PRINT,
        ROUND,
        SIN,
        SINH,
        SIGN,
        SOFTMAX,
        SQRT,
        STOP,
        SVD,
        TAN,
        TANH,
        TYPEOF,
        SPROP,
        SIGMOID,
        LOG_NZ,
        COMPRESS,
        DECOMPRESS,
        LOCAL,
        MULT2,
        MINUS1_MULT,
        MINUS_RIGHT,
        POW2,
        SUBTRACT_NZ;


        public boolean isScalarOutput() {
            return this == CAST_AS_SCALAR || this == NROW || this == NCOL || this == LENGTH || this == EXISTS || this == IQM || this == LINEAGE || this == MEDIAN;
        }

        public String toString() {
            switch (this) {
                case CAST_AS_SCALAR: {
                    return "castdts";
                }
                case CAST_AS_MATRIX: {
                    return "castdtm";
                }
                case CAST_AS_FRAME: {
                    return "castdtf";
                }
                case CAST_AS_LIST: {
                    return "castdtl";
                }
                case CAST_AS_DOUBLE: {
                    return "castvtd";
                }
                case CAST_AS_INT: {
                    return "castvti";
                }
                case CAST_AS_BOOLEAN: {
                    return "castvtb";
                }
                case CUMMAX: {
                    return "ucummax";
                }
                case CUMMIN: {
                    return "ucummin";
                }
                case CUMPROD: {
                    return "ucum*";
                }
                case CUMSUM: {
                    return "ucumk+";
                }
                case CUMSUMPROD: {
                    return "ucumk+*";
                }
                case DETECTSCHEMA: {
                    return "detectSchema";
                }
                case MULT2: {
                    return "*2";
                }
                case NOT: {
                    return "!";
                }
                case POW2: {
                    return "^2";
                }
                case TYPEOF: {
                    return "typeOf";
                }
            }
            return this.name().toLowerCase();
        }

        public static OpOp1 valueOfByOpcode(String opcode) {
            switch (opcode) {
                case "castdts": {
                    return CAST_AS_SCALAR;
                }
                case "castdtm": {
                    return CAST_AS_MATRIX;
                }
                case "castdtf": {
                    return CAST_AS_FRAME;
                }
                case "castvtd": {
                    return CAST_AS_DOUBLE;
                }
                case "castvti": {
                    return CAST_AS_INT;
                }
                case "castvtb": {
                    return CAST_AS_BOOLEAN;
                }
                case "ucummax": {
                    return CUMMAX;
                }
                case "ucummin": {
                    return CUMMIN;
                }
                case "ucum*": {
                    return CUMPROD;
                }
                case "ucumk+": {
                    return CUMSUM;
                }
                case "ucumk+*": {
                    return CUMSUMPROD;
                }
                case "detectSchema": {
                    return DETECTSCHEMA;
                }
                case "*2": {
                    return MULT2;
                }
                case "!": {
                    return NOT;
                }
                case "^2": {
                    return POW2;
                }
                case "typeOf": {
                    return TYPEOF;
                }
            }
            return OpOp1.valueOf(opcode.toUpperCase());
        }
    }

    public static enum AggOp {
        SUM(0),
        SUM_SQ(1),
        MIN(2),
        MAX(3),
        PROD(4),
        SUM_PROD(5),
        TRACE(6),
        MEAN(7),
        VAR(8),
        MAXINDEX(9),
        MININDEX(10),
        COUNT_DISTINCT(11),
        COUNT_DISTINCT_APPROX(12);

        private final int value;
        private static final HashMap<Integer, AggOp> map;

        public String toString() {
            switch (this) {
                case SUM: {
                    return "+";
                }
                case SUM_SQ: {
                    return "sq+";
                }
                case PROD: {
                    return "*";
                }
            }
            return this.name().toLowerCase();
        }

        private AggOp(int value) {
            this.value = value;
        }

        public static AggOp valueOf(int aggOp) {
            return map.get(aggOp);
        }

        public int getValue() {
            return this.value;
        }

        static {
            map = new HashMap();
            for (AggOp aggOp : AggOp.values()) {
                map.put(aggOp.value, aggOp);
            }
        }
    }

    public static enum CorrectionLocationType {
        NONE,
        LASTROW,
        LASTCOLUMN,
        LASTTWOROWS,
        LASTTWOCOLUMNS,
        LASTFOURROWS,
        LASTFOURCOLUMNS,
        INVALID;


        public int getNumRemovedRowsColumns() {
            return this == LASTROW || this == LASTCOLUMN ? 1 : (this == LASTTWOROWS || this == LASTTWOCOLUMNS ? 2 : (this == LASTFOURROWS || this == LASTFOURCOLUMNS ? 4 : 0));
        }

        public boolean isRows() {
            return this == LASTROW || this == LASTTWOROWS || this == LASTFOURROWS;
        }
    }

    public static enum Direction {
        RowCol,
        Row,
        Col;


        public boolean isRow() {
            return this == Row;
        }

        public boolean isCol() {
            return this == Col;
        }

        public boolean isRowCol() {
            return this == RowCol;
        }

        public String toString() {
            switch (this) {
                case RowCol: {
                    return "RC";
                }
                case Row: {
                    return "R";
                }
                case Col: {
                    return "C";
                }
            }
            throw new RuntimeException("Invalid direction type: " + this);
        }
    }

    public static enum ReturnType {
        NO_RETURN,
        SINGLE_RETURN,
        MULTI_RETURN;

    }

    public static enum BlockType {
        EMPTY_BLOCK,
        ULTRA_SPARSE_BLOCK,
        SPARSE_BLOCK,
        DENSE_BLOCK;

    }

    public static enum ValueType {
        UINT8,
        FP32,
        FP64,
        INT32,
        INT64,
        BOOLEAN,
        STRING,
        UNKNOWN;


        public boolean isNumeric() {
            return this == UINT8 || this == INT32 || this == INT64 || this == FP32 || this == FP64;
        }

        public boolean isUnknown() {
            return this == UNKNOWN;
        }

        public boolean isPseudoNumeric() {
            return this.isNumeric() || this == BOOLEAN;
        }

        public String toExternalString() {
            switch (this) {
                case FP32: 
                case FP64: {
                    return "DOUBLE";
                }
                case UINT8: 
                case INT32: 
                case INT64: {
                    return "INT";
                }
                case BOOLEAN: {
                    return "BOOLEAN";
                }
            }
            return this.toString();
        }

        public static ValueType fromExternalString(String value) {
            String lvalue;
            switch (lvalue = value != null ? value.toUpperCase() : null) {
                case "FP32": {
                    return FP32;
                }
                case "FP64": 
                case "DOUBLE": {
                    return FP64;
                }
                case "UINT8": {
                    return UINT8;
                }
                case "INT32": {
                    return INT32;
                }
                case "INT64": 
                case "INT": {
                    return INT64;
                }
                case "BOOLEAN": {
                    return BOOLEAN;
                }
                case "STRING": {
                    return STRING;
                }
                case "UNKNOWN": {
                    return UNKNOWN;
                }
            }
            throw new DMLRuntimeException("Unknown value type: " + value);
        }

        public static boolean isSameTypeString(ValueType vt1, ValueType vt2) {
            return vt1.toExternalString().equals(vt2.toExternalString());
        }
    }

    public static enum DataType {
        TENSOR,
        MATRIX,
        SCALAR,
        FRAME,
        LIST,
        UNKNOWN,
        ENCRYPTED_CIPHER,
        ENCRYPTED_PLAIN;


        public boolean isMatrix() {
            return this == MATRIX;
        }

        public boolean isTensor() {
            return this == TENSOR;
        }

        public boolean isFrame() {
            return this == FRAME;
        }

        public boolean isMatrixOrFrame() {
            return this.isMatrix() | this.isFrame();
        }

        public boolean isScalar() {
            return this == SCALAR;
        }

        public boolean isList() {
            return this == LIST;
        }

        public boolean isUnknown() {
            return this == UNKNOWN;
        }
    }

    public static enum ExecType {
        CP,
        CP_FILE,
        SPARK,
        GPU,
        FED,
        INVALID;

    }

    public static enum ExecMode {
        SINGLE_NODE,
        HYBRID,
        SPARK;

    }
}

