/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.mapping;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToChar;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.utils.MemoryEstimates;

public class MapToByte
extends AMapToData {
    private static final long serialVersionUID = -2498505439667351828L;
    private final byte[] _data;

    public MapToByte(int unique, int size) {
        super(unique);
        this._data = new byte[size];
    }

    private MapToByte(int unique, byte[] data) {
        super(unique);
        this._data = data;
    }

    @Override
    public int getIndex(int n) {
        return this._data[n] & 0xFF;
    }

    @Override
    public void fill(int v) {
        Arrays.fill(this._data, (byte)v);
    }

    @Override
    public long getInMemorySize() {
        return MapToByte.getInMemorySize(this._data.length);
    }

    public static long getInMemorySize(int dataLength) {
        long size = 24L;
        return size += MemoryEstimates.byteArrayCost(dataLength);
    }

    @Override
    public long getExactSizeOnDisk() {
        return 9 + this._data.length;
    }

    @Override
    public void set(int n, int v) {
        this._data[n] = (byte)v;
    }

    @Override
    public int size() {
        return this._data.length;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(MapToFactory.MAP_TYPE.BYTE.ordinal());
        out.writeInt(this.getUnique());
        out.writeInt(this._data.length);
        for (int i = 0; i < this._data.length; ++i) {
            out.writeByte(this._data[i]);
        }
    }

    public static MapToByte readFields(DataInput in) throws IOException {
        int unique = in.readInt();
        int length = in.readInt();
        byte[] data = new byte[length];
        for (int i = 0; i < length; ++i) {
            data[i] = in.readByte();
        }
        return new MapToByte(unique, data);
    }

    public byte[] getBytes() {
        return this._data;
    }

    @Override
    public void replace(int v, int r) {
        byte cv = (byte)v;
        byte rv = (byte)r;
        for (int i = 0; i < this.size(); ++i) {
            if (this._data[i] != cv) continue;
            this._data[i] = rv;
        }
    }

    @Override
    public void copy(AMapToData d) {
        if (d instanceof MapToChar) {
            char[] dd = ((MapToChar)d).getChars();
            for (int i = 0; i < this.size(); ++i) {
                this._data[i] = (byte)dd[i];
            }
        } else {
            for (int i = 0; i < this.size(); ++i) {
                this.set(i, d.getIndex(i));
            }
        }
    }
}

