/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;

class RamDiskAsyncLazyPersistService {
    public static final Log LOG = LogFactory.getLog(RamDiskAsyncLazyPersistService.class);
    private static final int CORE_THREADS_PER_VOLUME = 1;
    private static final int MAXIMUM_THREADS_PER_VOLUME = 1;
    private static final long THREADS_KEEP_ALIVE_SECONDS = 60L;
    private final DataNode datanode;
    private final ThreadGroup threadGroup;
    private Map<File, ThreadPoolExecutor> executors = new HashMap<File, ThreadPoolExecutor>();

    RamDiskAsyncLazyPersistService(DataNode datanode) {
        this.datanode = datanode;
        this.threadGroup = new ThreadGroup(this.getClass().getSimpleName());
    }

    private void addExecutorForVolume(final File volume) {
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(RamDiskAsyncLazyPersistService.this.threadGroup, r);
                t.setName("Async RamDisk lazy persist worker for volume " + volume);
                return t;
            }
        };
        ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
        executor.allowCoreThreadTimeOut(true);
        this.executors.put(volume, executor);
    }

    synchronized void addVolume(File volume) {
        if (this.executors == null) {
            throw new RuntimeException("AsyncLazyPersistService is already shutdown");
        }
        ThreadPoolExecutor executor = this.executors.get(volume);
        if (executor != null) {
            throw new RuntimeException("Volume " + volume + " is already existed.");
        }
        this.addExecutorForVolume(volume);
    }

    synchronized void removeVolume(File volume) {
        if (this.executors == null) {
            throw new RuntimeException("AsyncDiskService is already shutdown");
        }
        ThreadPoolExecutor executor = this.executors.get(volume);
        if (executor == null) {
            throw new RuntimeException("Can not find volume " + volume + " to remove.");
        }
        executor.shutdown();
        this.executors.remove(volume);
    }

    synchronized boolean queryVolume(File volume) {
        if (this.executors == null) {
            throw new RuntimeException("AsyncLazyPersistService is already shutdown");
        }
        ThreadPoolExecutor executor = this.executors.get(volume);
        return executor != null;
    }

    synchronized void execute(File root, Runnable task) {
        if (this.executors == null) {
            throw new RuntimeException("AsyncLazyPersistService is already shutdown");
        }
        ThreadPoolExecutor executor = this.executors.get(root);
        if (executor == null) {
            throw new RuntimeException("Cannot find root " + root + " for execution of task " + task);
        }
        executor.execute(task);
    }

    synchronized void shutdown() {
        if (this.executors == null) {
            LOG.warn((Object)"AsyncLazyPersistService has already shut down.");
        } else {
            LOG.info((Object)"Shutting down all async lazy persist service threads");
            for (Map.Entry<File, ThreadPoolExecutor> e : this.executors.entrySet()) {
                e.getValue().shutdown();
            }
            this.executors = null;
            LOG.info((Object)"All async lazy persist service threads have been shut down");
        }
    }

    void submitLazyPersistTask(String bpId, long blockId, long genStamp, long creationTime, File metaFile, File blockFile, FsVolumeImpl targetVolume) throws IOException {
        File lazyPersistDir;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("LazyWriter schedule async task to persist RamDisk block pool id: " + bpId + " block id: " + blockId));
        }
        if (!(lazyPersistDir = targetVolume.getLazyPersistDir(bpId)).exists() && !lazyPersistDir.mkdirs()) {
            FsDatasetImpl.LOG.warn((Object)("LazyWriter failed to create " + lazyPersistDir));
            throw new IOException("LazyWriter fail to find or create lazy persist dir: " + lazyPersistDir.toString());
        }
        ReplicaLazyPersistTask lazyPersistTask = new ReplicaLazyPersistTask(bpId, blockId, genStamp, creationTime, blockFile, metaFile, targetVolume, lazyPersistDir);
        this.execute(targetVolume.getCurrentDir(), lazyPersistTask);
    }

    class ReplicaLazyPersistTask
    implements Runnable {
        final String bpId;
        final long blockId;
        final long genStamp;
        final long creationTime;
        final File blockFile;
        final File metaFile;
        final FsVolumeImpl targetVolume;
        final File lazyPersistDir;

        ReplicaLazyPersistTask(String bpId, long blockId, long genStamp, long creationTime, File blockFile, File metaFile, FsVolumeImpl targetVolume, File lazyPersistDir) {
            this.bpId = bpId;
            this.blockId = blockId;
            this.genStamp = genStamp;
            this.creationTime = creationTime;
            this.blockFile = blockFile;
            this.metaFile = metaFile;
            this.targetVolume = targetVolume;
            this.lazyPersistDir = lazyPersistDir;
        }

        public String toString() {
            return "LazyWriter async task of persist RamDisk block pool id:" + this.bpId + " block pool id: " + this.blockId + " with block file " + this.blockFile + " and meta file " + this.metaFile + " to target volume " + this.targetVolume;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean succeeded = false;
            try {
                File[] targetFiles = FsDatasetImpl.copyBlockFiles(this.blockId, this.genStamp, this.metaFile, this.blockFile, this.lazyPersistDir);
                RamDiskAsyncLazyPersistService.this.datanode.getFSDataset().onCompleteLazyPersist(this.bpId, this.blockId, this.creationTime, targetFiles, this.targetVolume);
                succeeded = true;
            }
            catch (Exception e) {
                FsDatasetImpl.LOG.warn((Object)("LazyWriter failed to async persist RamDisk block pool id: " + this.bpId + "block Id: " + this.blockId), (Throwable)e);
            }
            finally {
                if (!succeeded) {
                    RamDiskAsyncLazyPersistService.this.datanode.getFSDataset().onFailLazyPersist(this.bpId, this.blockId);
                }
            }
        }
    }
}

