/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.namenode.Content;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ContentSummaryComputationContext {
    private FSDirectory dir = null;
    private FSNamesystem fsn = null;
    private Content.Counts counts = null;
    private long nextCountLimit = 0L;
    private long limitPerRun = 0L;
    private long yieldCount = 0L;

    public ContentSummaryComputationContext(FSDirectory dir, FSNamesystem fsn, long limitPerRun) {
        this.dir = dir;
        this.fsn = fsn;
        this.limitPerRun = limitPerRun;
        this.nextCountLimit = limitPerRun;
        this.counts = Content.Counts.newInstance();
    }

    public ContentSummaryComputationContext() {
        this(null, null, 0L);
    }

    public long getYieldCount() {
        return this.yieldCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean yield() {
        if (this.limitPerRun <= 0L || this.dir == null || this.fsn == null) {
            return false;
        }
        long currentCount = this.counts.get(Content.FILE) + this.counts.get(Content.SYMLINK) + this.counts.get(Content.DIRECTORY) + this.counts.get(Content.SNAPSHOTTABLE_DIRECTORY);
        if (currentCount <= this.nextCountLimit) {
            return false;
        }
        this.nextCountLimit = currentCount + this.limitPerRun;
        boolean hadDirReadLock = this.dir.hasReadLock();
        boolean hadDirWriteLock = this.dir.hasWriteLock();
        boolean hadFsnReadLock = this.fsn.hasReadLock();
        boolean hadFsnWriteLock = this.fsn.hasWriteLock();
        if (!hadDirReadLock || !hadFsnReadLock || hadDirWriteLock || hadFsnWriteLock || this.dir.getReadHoldCount() != 1 || this.fsn.getReadHoldCount() != 1) {
            return false;
        }
        this.dir.readUnlock();
        this.fsn.readUnlock();
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException ie) {
        }
        finally {
            this.fsn.readLock();
            this.dir.readLock();
        }
        ++this.yieldCount;
        return true;
    }

    public Content.Counts getCounts() {
        return this.counts;
    }
}

