/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.json4j;

import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.wink.json4j.JSONArtifact;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;
import org.apache.wink.json4j.internal.BeanSerializer;
import org.apache.wink.json4j.internal.Parser;
import org.apache.wink.json4j.internal.Serializer;
import org.apache.wink.json4j.internal.SerializerVerbose;

public class JSONArray
extends ArrayList
implements JSONArtifact {
    private static final long serialVersionUID = 9076798781015779954L;

    public JSONArray() {
    }

    public JSONArray(int initialCapacity) {
        super(initialCapacity);
    }

    public JSONArray(Collection col) throws JSONException {
        super(col.size());
        Iterator itr = col.iterator();
        if (itr != null) {
            while (itr.hasNext()) {
                this.add(itr.next());
            }
        }
    }

    public JSONArray(Object[] elems) throws JSONException {
        if (elems != null) {
            for (int i = 0; i < elems.length; ++i) {
                this.add(elems[i]);
            }
        }
    }

    public JSONArray(Object[] elems, boolean includeSuperclass) throws JSONException {
        if (elems != null) {
            for (int i = 0; i < elems.length; ++i) {
                this.add(elems[i]);
            }
        }
    }

    public JSONArray(Collection col, boolean includeSuperclass) throws JSONException {
        super(col.size());
        Iterator itr = col.iterator();
        if (itr != null) {
            while (itr.hasNext()) {
                this.add(itr.next(), true);
            }
        }
    }

    public JSONArray(String str) throws JSONException {
        StringReader reader = new StringReader(str);
        new Parser(reader).parse(this);
    }

    public JSONArray(String str, boolean strict) throws JSONException {
        StringReader reader = new StringReader(str);
        new Parser(reader, strict).parse(this);
    }

    public JSONArray(Reader rdr) throws JSONException {
        new Parser(rdr).parse(this);
    }

    public JSONArray(Reader rdr, boolean strict) throws JSONException {
        new Parser(rdr, strict).parse(this);
    }

    public JSONArray(InputStream is) throws JSONException {
        InputStreamReader isr = null;
        if (is != null) {
            try {
                isr = new InputStreamReader(is, "UTF-8");
            }
            catch (Exception ex) {
                isr = new InputStreamReader(is);
            }
        } else {
            throw new JSONException("Inputstream cannot be null");
        }
        new Parser(isr).parse(true, this);
    }

    public JSONArray(InputStream is, boolean strict) throws JSONException {
        InputStreamReader isr = null;
        if (is != null) {
            try {
                isr = new InputStreamReader(is, "UTF-8");
            }
            catch (Exception ex) {
                isr = new InputStreamReader(is);
            }
        } else {
            throw new JSONException("InputStream cannot be null");
        }
        new Parser(isr, strict).parse(true, this);
    }

    public Object getIndex(int index) throws JSONException {
        try {
            return super.get(index);
        }
        catch (Exception ex) {
            JSONException jex = new JSONException("Error occurred trying to access element at: " + index);
            jex.initCause(ex);
            throw jex;
        }
    }

    public void add(int index, Object element) {
        if (index > this.size() - 1) {
            this.expandArray(index);
        }
        if (!JSONObject.isValidObject(element)) {
            try {
                element = BeanSerializer.toJson(element, true);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Object of type: [" + element.getClass().getName() + "] could not be converted to a JSON representation.");
            }
        }
        super.add(index, element);
    }

    public boolean add(Object element, boolean includeSuperclass) {
        if (!JSONObject.isValidObject(element)) {
            try {
                element = BeanSerializer.toJson(element, includeSuperclass);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Object of type: [" + element.getClass().getName() + "] could not be converted to a JSON representation.");
            }
        }
        return super.add(element);
    }

    public boolean add(Object element) {
        return this.add(element, true);
    }

    public boolean addAll(Collection collection) {
        for (Object obj : collection) {
            if (!JSONObject.isValidObject(obj)) {
                try {
                    obj = BeanSerializer.toJson(obj, true);
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Object of type: [" + obj.getClass().getName() + "] could not be converted to a JSON representation.");
                }
            }
            super.add(obj);
        }
        return true;
    }

    public boolean addAll(int index, Collection collection) {
        if (index > this.size() - 1) {
            this.expandArray(index);
        }
        for (Object obj : collection) {
            if (!JSONObject.isValidObject(obj)) {
                try {
                    obj = BeanSerializer.toJson(obj, true);
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Object of type: [" + obj.getClass().getName() + "] could not be converted to a JSON representation.");
                }
            }
            super.add(index, obj);
            ++index;
        }
        return true;
    }

    public Object set(int index, Object element) {
        if (index > this.size() - 1) {
            this.expandArray(index);
        }
        if (!JSONObject.isValidObject(element)) {
            try {
                element = BeanSerializer.toJson(element, true);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Object of type: [" + element.getClass().getName() + "] could not be converted to a JSON representation.");
            }
        }
        return super.set(index, element);
    }

    private void expandArray(int toIndex) {
        int maxIndex = this.size();
        if ((toIndex -= maxIndex) > 0) {
            for (int i = 0; i < toIndex; ++i) {
                super.add(null);
            }
        }
    }

    public JSONArray put(int index, Object element) throws JSONException {
        if (!JSONObject.isValidObject(element)) {
            try {
                element = BeanSerializer.toJson(element, true);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Object of type: [" + element.getClass().getName() + "] could not be converted to a JSON representation.");
            }
        }
        try {
            super.add(index, element);
        }
        catch (Exception ex) {
            JSONException jex = new JSONException("Exception occurred while placing element.");
            jex.initCause(ex);
            throw jex;
        }
        return this;
    }

    public JSONArray put(Object element) throws JSONException {
        return this.put(element, true);
    }

    public JSONArray put(Object element, boolean includeSuperclass) throws JSONException {
        if (!JSONObject.isValidObject(element)) {
            try {
                element = BeanSerializer.toJson(element, includeSuperclass);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Object of type: [" + element.getClass().getName() + "] could not be converted to a JSON representation.");
            }
        }
        try {
            super.add(element);
        }
        catch (Exception ex) {
            JSONException jex = new JSONException("Exception occurred while placing element.");
            jex.initCause(ex);
            throw jex;
        }
        return this;
    }

    public JSONArray put(int index, Map value) throws JSONException {
        return this.put(index, value, true);
    }

    public JSONArray put(int index, Map value, boolean includeSuperclass) throws JSONException {
        if (value == null) {
            this.add((Object)null);
        } else if (JSONObject.class.isAssignableFrom(value.getClass())) {
            this.add(index, value);
        } else {
            this.add(index, new JSONObject(value, includeSuperclass));
        }
        return this;
    }

    public JSONArray put(Map value) throws JSONException {
        return this.put(value, true);
    }

    public JSONArray put(Map value, boolean includeSuperclass) throws JSONException {
        if (value == null) {
            this.add((Object)null);
        } else if (JSONObject.class.isAssignableFrom(value.getClass())) {
            this.add(value);
        } else {
            this.add(new JSONObject(value, includeSuperclass));
        }
        return this;
    }

    public JSONArray put(int index, Collection value) throws JSONException {
        return this.put(index, value, true);
    }

    public JSONArray put(int index, Collection value, boolean includeSuperclass) throws JSONException {
        if (value == null) {
            this.add((Object)null);
        } else if (JSONArray.class.isAssignableFrom(value.getClass())) {
            this.add(index, value);
        } else {
            this.add(index, new JSONArray(value, includeSuperclass));
        }
        return this;
    }

    public JSONArray put(Collection value) throws JSONException {
        return this.put(value, true);
    }

    public JSONArray put(Collection value, boolean includeSuperclass) throws JSONException {
        if (value == null) {
            this.add((Object)null);
        } else if (JSONArray.class.isAssignableFrom(value.getClass())) {
            this.add(value);
        } else {
            this.add(new JSONArray(value, includeSuperclass));
        }
        return this;
    }

    public JSONArray put(long value) {
        this.add(new Long(value));
        return this;
    }

    public JSONArray put(int index, long value) {
        this.add(index, new Long(value));
        return this;
    }

    public JSONArray put(int value) {
        this.add(new Integer(value));
        return this;
    }

    public JSONArray put(int index, int value) {
        this.add(index, new Integer(value));
        return this;
    }

    public JSONArray put(short value) {
        this.add(new Short(value));
        return this;
    }

    public JSONArray put(int index, short value) {
        this.add(index, new Short(value));
        return this;
    }

    public JSONArray put(double value) {
        this.add(new Double(value));
        return this;
    }

    public JSONArray put(int index, double value) {
        this.add(index, new Double(value));
        return this;
    }

    public JSONArray put(boolean value) {
        this.add(new Boolean(value));
        return this;
    }

    public JSONArray put(int index, boolean value) {
        this.add(index, new Boolean(value));
        return this;
    }

    public boolean getBoolean(int index) throws JSONException {
        block8: {
            try {
                Object val = this.get(index);
                if (val != null) {
                    if (Boolean.class.isAssignableFrom(val.getClass())) {
                        return (Boolean)val;
                    }
                    if (Number.class.isAssignableFrom(val.getClass())) {
                        throw new JSONException("Value at index: [" + index + "] was not a boolean or string value of 'true' or 'false'.");
                    }
                    if (String.class.isAssignableFrom(val.getClass())) {
                        String str = (String)val;
                        if (str.equals("true")) {
                            return true;
                        }
                        if (str.equals("false")) {
                            return false;
                        }
                        throw new JSONException("Value at index: [" + index + "] was not a boolean or string value of 'true' or 'false'.");
                    }
                    break block8;
                }
                throw new JSONException("Value at index: [" + index + "] was null");
            }
            catch (IndexOutOfBoundsException iobe) {
                JSONException jex = new JSONException("The specified index was outside of the array boundries");
                jex.initCause(iobe);
                throw jex;
            }
        }
        return false;
    }

    public double getDouble(int index) throws JSONException {
        try {
            Object val = this.get(index);
            if (val != null) {
                if (Number.class.isAssignableFrom(val.getClass())) {
                    return ((Number)val).doubleValue();
                }
                throw new JSONException("Value at index: [" + index + "] was not a number.");
            }
            throw new JSONException("Value at index: [" + index + "] was null");
        }
        catch (IndexOutOfBoundsException iobe) {
            JSONException jex = new JSONException("The specified index was outside of the array boundries");
            jex.initCause(iobe);
            throw jex;
        }
    }

    public long getLong(int index) throws JSONException {
        try {
            Object val = this.get(index);
            if (val != null) {
                if (Number.class.isAssignableFrom(val.getClass())) {
                    return ((Number)val).longValue();
                }
                throw new JSONException("Value at index: [" + index + "] was not a number.");
            }
            throw new JSONException("Value at index: [" + index + "] was null");
        }
        catch (IndexOutOfBoundsException iobe) {
            JSONException jex = new JSONException("The specified index was outside of the array boundries");
            jex.initCause(iobe);
            throw jex;
        }
    }

    public int getInt(int index) throws JSONException {
        try {
            Object val = this.get(index);
            if (val != null) {
                if (Number.class.isAssignableFrom(val.getClass())) {
                    return ((Number)val).intValue();
                }
                throw new JSONException("Value at index: [" + index + "] was not a number.");
            }
            throw new JSONException("Value at index: [" + index + "] was null");
        }
        catch (IndexOutOfBoundsException iobe) {
            JSONException jex = new JSONException("The specified index was outside of the array boundries");
            jex.initCause(iobe);
            throw jex;
        }
    }

    public short getShort(int index) throws JSONException {
        try {
            Object val = this.get(index);
            if (val != null) {
                if (Number.class.isAssignableFrom(val.getClass())) {
                    return ((Number)val).shortValue();
                }
                throw new JSONException("Value at index: [" + index + "] was not a number.");
            }
            throw new JSONException("Value at index: [" + index + "] was null");
        }
        catch (IndexOutOfBoundsException iobe) {
            JSONException jex = new JSONException("The specified index was outside of the array boundries");
            jex.initCause(iobe);
            throw jex;
        }
    }

    public String getString(int index) throws JSONException {
        try {
            Object val = this.get(index);
            if (val != null) {
                return val.toString();
            }
            throw new JSONException("The value at index: [" + index + "] was null.");
        }
        catch (IndexOutOfBoundsException iobe) {
            JSONException jex = new JSONException("The specified index was outside of the array boundries");
            jex.initCause(iobe);
            throw jex;
        }
    }

    public JSONObject getJSONObject(int index) throws JSONException {
        try {
            Object val = this.get(index);
            if (val != null) {
                if (JSONObject.class.isAssignableFrom(val.getClass())) {
                    return (JSONObject)val;
                }
                throw new JSONException("The value for index: [" + index + "] was not a JSONObject");
            }
            throw new JSONException("The value for index: [" + index + "] was null.  Object required.");
        }
        catch (IndexOutOfBoundsException iobe) {
            JSONException jex = new JSONException("The specified index was outside of the array boundries");
            jex.initCause(iobe);
            throw jex;
        }
    }

    public JSONArray getJSONArray(int index) throws JSONException {
        try {
            Object val = this.get(index);
            if (val != null) {
                if (JSONArray.class.isAssignableFrom(val.getClass())) {
                    return (JSONArray)val;
                }
                throw new JSONException("The value index key: [" + index + "] was not a JSONObject");
            }
            throw new JSONException("The value for index: [" + index + "] was null.  Object required.");
        }
        catch (IndexOutOfBoundsException iobe) {
            JSONException jex = new JSONException("The specified index was outside of the array boundries");
            jex.initCause(iobe);
            throw jex;
        }
    }

    public boolean isNull(int index) {
        try {
            Object obj = this.get(index);
            return obj == null;
        }
        catch (IndexOutOfBoundsException iobe) {
            return true;
        }
    }

    public int length() {
        return this.size();
    }

    public OutputStream write(OutputStream os) throws JSONException {
        this.write(os, false);
        return os;
    }

    public OutputStream write(OutputStream os, boolean verbose) throws JSONException {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
        }
        catch (UnsupportedEncodingException uex) {
            JSONException jex = new JSONException(uex.toString());
            jex.initCause(uex);
            throw jex;
        }
        this.write((Writer)writer, verbose);
        return os;
    }

    public OutputStream write(OutputStream os, int indentDepth) throws JSONException {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
        }
        catch (UnsupportedEncodingException uex) {
            JSONException jex = new JSONException(uex.toString());
            jex.initCause(uex);
            throw jex;
        }
        this.write((Writer)writer, indentDepth);
        return os;
    }

    public Writer write(Writer writer) throws JSONException {
        this.write(writer, false);
        return writer;
    }

    public Writer write(Writer writer, boolean verbose) throws JSONException {
        Class<?> writerClass = writer.getClass();
        boolean flushIt = false;
        if (!(StringWriter.class.isAssignableFrom(writerClass) || CharArrayWriter.class.isAssignableFrom(writerClass) || BufferedWriter.class.isAssignableFrom(writerClass))) {
            writer = new BufferedWriter(writer);
            flushIt = true;
        }
        Serializer serializer = verbose ? new SerializerVerbose(writer) : new Serializer(writer);
        try {
            serializer.writeArray(this);
        }
        catch (IOException iox) {
            JSONException jex = new JSONException("Error occurred during input read.");
            jex.initCause(iox);
            throw jex;
        }
        if (flushIt) {
            try {
                writer.flush();
            }
            catch (Exception ex) {
                JSONException jex = new JSONException("Error during buffer flush");
                jex.initCause(ex);
                throw jex;
            }
        }
        return writer;
    }

    public Writer write(Writer writer, int indentDepth) throws JSONException {
        if (indentDepth < 1) {
            indentDepth = 0;
        } else if (indentDepth > 8) {
            indentDepth = 9;
        }
        Class<?> writerClass = writer.getClass();
        if (!(StringWriter.class.isAssignableFrom(writerClass) || CharArrayWriter.class.isAssignableFrom(writerClass) || BufferedWriter.class.isAssignableFrom(writerClass))) {
            writer = new BufferedWriter(writer);
        }
        Serializer serializer = indentDepth > 0 ? new SerializerVerbose(writer, indentDepth) : new Serializer(writer);
        try {
            serializer.writeArray(this);
        }
        catch (IOException iox) {
            JSONException jex = new JSONException("Error occurred during input read.");
            jex.initCause(iox);
            throw jex;
        }
        return writer;
    }

    public String write(boolean verbose) throws JSONException {
        StringWriter writer = new StringWriter();
        Serializer serializer = verbose ? new SerializerVerbose(writer) : new Serializer(writer);
        try {
            serializer.writeArray(this).flush();
        }
        catch (IOException iox) {
            JSONException jex = new JSONException("Error occurred during input read.");
            jex.initCause(iox);
            throw jex;
        }
        return writer.toString();
    }

    public String write(int indentDepth) throws JSONException {
        StringWriter writer = new StringWriter();
        if (indentDepth < 1) {
            indentDepth = 0;
        } else if (indentDepth > 8) {
            indentDepth = 9;
        }
        Serializer serializer = indentDepth > 0 ? new SerializerVerbose(writer, indentDepth) : new Serializer(writer);
        try {
            serializer.writeArray(this).flush();
        }
        catch (IOException iox) {
            JSONException jex = new JSONException("Error occurred during input read.");
            jex.initCause(iox);
            throw jex;
        }
        return writer.toString();
    }

    public String write() throws JSONException {
        return this.write(false);
    }

    public String toString() {
        String str = null;
        try {
            str = this.write(false);
        }
        catch (JSONException jex) {
            str = "JSON Generation Error: [" + jex.toString() + "]";
        }
        return str;
    }

    public String toString(int indentDepth) throws JSONException {
        return this.write(indentDepth);
    }

    public String join(String str) {
        if (str == null) {
            str = "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            Object obj;
            if (i > 0) {
                buf.append(str);
            }
            if ((obj = this.get(i)) == null) {
                buf.append("null");
                continue;
            }
            buf.append(obj.toString());
        }
        return buf.toString();
    }

    public Object opt(int index) {
        try {
            return this.get(index);
        }
        catch (Throwable th) {
            return null;
        }
    }

    public Object opt(int index, Object defaultValue) {
        try {
            return this.get(index);
        }
        catch (Throwable th) {
            return defaultValue;
        }
    }

    public boolean optBoolean(int index) {
        try {
            return this.getBoolean(index);
        }
        catch (Throwable th) {
            return false;
        }
    }

    public boolean optBoolean(int index, boolean defaultValue) {
        try {
            return this.getBoolean(index);
        }
        catch (Throwable th) {
            return defaultValue;
        }
    }

    public int optInt(int index) {
        try {
            return this.getInt(index);
        }
        catch (Throwable th) {
            return 0;
        }
    }

    public int optInt(int index, int defaultValue) {
        try {
            return this.getInt(index);
        }
        catch (Throwable th) {
            return defaultValue;
        }
    }

    public long optLong(int index) {
        try {
            return this.getLong(index);
        }
        catch (Throwable th) {
            return 0L;
        }
    }

    public long optLong(int index, long defaultValue) {
        try {
            return this.getLong(index);
        }
        catch (Throwable th) {
            return defaultValue;
        }
    }

    public short optShort(int index) {
        try {
            return this.getShort(index);
        }
        catch (Throwable th) {
            return 0;
        }
    }

    public short optShort(int index, short defaultValue) {
        try {
            return this.getShort(index);
        }
        catch (Throwable th) {
            return defaultValue;
        }
    }

    public double optDouble(int index) {
        try {
            return this.getDouble(index);
        }
        catch (Throwable th) {
            return Double.NaN;
        }
    }

    public double optDouble(int index, double defaultValue) {
        try {
            return this.getDouble(index);
        }
        catch (Throwable th) {
            return Double.NaN;
        }
    }

    public String optString(int index) {
        try {
            return this.getString(index);
        }
        catch (Throwable th) {
            return null;
        }
    }

    public String optString(int index, String defaultValue) {
        try {
            return this.getString(index);
        }
        catch (Throwable th) {
            return defaultValue;
        }
    }
}

