/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.federated;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.serialization.ClassResolvers;
import io.netty.handler.codec.serialization.ObjectDecoder;
import io.netty.handler.codec.serialization.ObjectEncoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.concurrent.Promise;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import javax.net.ssl.SSLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.apache.sysds.runtime.controlprogram.federated.FederationUtils;
import org.apache.sysds.runtime.meta.MetaData;

public class FederatedData {
    private static final Log LOG = LogFactory.getLog((String)FederatedData.class.getName());
    private static final Set<InetSocketAddress> _allFedSites = new HashSet<InetSocketAddress>();
    private static SslContextMan instance = null;
    private final Types.DataType _dataType;
    private final InetSocketAddress _address;
    private final String _filepath;
    private long _varID = -1L;

    public FederatedData(Types.DataType dataType, InetSocketAddress address, String filepath) {
        this._dataType = dataType;
        this._address = address;
        this._filepath = filepath;
        if (this._address != null) {
            _allFedSites.add(this._address);
        }
    }

    public FederatedData(Types.DataType dataType, InetSocketAddress address, String filepath, long varID) {
        this._dataType = dataType;
        this._address = address;
        this._filepath = filepath;
        this._varID = varID;
    }

    public InetSocketAddress getAddress() {
        return this._address;
    }

    public void setVarID(long varID) {
        this._varID = varID;
    }

    public long getVarID() {
        return this._varID;
    }

    public String getFilepath() {
        return this._filepath;
    }

    public Types.DataType getDataType() {
        return this._dataType;
    }

    public boolean isInitialized() {
        return this._varID != -1L;
    }

    boolean equalAddress(FederatedData that) {
        return this._address != null && that != null && that._address != null && this._address.equals(that._address);
    }

    public FederatedData copyWithNewID(long varID) {
        FederatedData copy = new FederatedData(this._dataType, this._address, this._filepath);
        copy.setVarID(varID);
        return copy;
    }

    public synchronized Future<FederatedResponse> initFederatedData(long id) {
        return this.initFederatedData(id, null);
    }

    public synchronized Future<FederatedResponse> initFederatedData(long id, MetaData mtd) {
        if (this.isInitialized()) {
            throw new DMLRuntimeException("Tried to init already initialized data");
        }
        if (!this._dataType.isMatrix() && !this._dataType.isFrame()) {
            throw new DMLRuntimeException("Federated datatype \"" + this._dataType.toString() + "\" is not supported.");
        }
        this._varID = id;
        FederatedRequest request = mtd != null ? new FederatedRequest(FederatedRequest.RequestType.READ_VAR, id, mtd) : new FederatedRequest(FederatedRequest.RequestType.READ_VAR, id);
        request.appendParam(this._filepath);
        request.appendParam(this._dataType.name());
        return this.executeFederatedOperation(request);
    }

    public synchronized Future<FederatedResponse> executeFederatedOperation(FederatedRequest ... request) {
        try {
            return FederatedData.executeFederatedOperation(this._address, request);
        }
        catch (SSLException e) {
            throw new DMLRuntimeException("Error in SSL Connection", e);
        }
    }

    public static Future<FederatedResponse> executeFederatedOperation(final InetSocketAddress address, FederatedRequest ... request) throws SSLException {
        NioEventLoopGroup workerGroup = new NioEventLoopGroup(2);
        try {
            Bootstrap b = new Bootstrap();
            final DataRequestHandler handler = new DataRequestHandler((EventLoopGroup)workerGroup);
            ((Bootstrap)((Bootstrap)b.group((EventLoopGroup)workerGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline cp = ch.pipeline();
                    if (ConfigurationManager.getDMLConfig().getBooleanValue("sysds.federated.ssl")) {
                        cp.addLast(new ChannelHandler[]{FederatedData.SslConstructor().context.newHandler(ch.alloc(), address.getAddress().getHostAddress(), address.getPort())});
                    }
                    cp.addLast("ObjectDecoder", (ChannelHandler)new ObjectDecoder(Integer.MAX_VALUE, ClassResolvers.weakCachingResolver((ClassLoader)ClassLoader.getSystemClassLoader())));
                    cp.addLast("FederatedOperationHandler", (ChannelHandler)handler);
                    cp.addLast("ObjectEncoder", (ChannelHandler)new ObjectEncoder());
                }
            });
            ChannelFuture f = b.connect((SocketAddress)address).sync();
            Promise promise = f.channel().eventLoop().newPromise();
            handler.setPromise((Promise<FederatedResponse>)promise);
            f.channel().writeAndFlush((Object)request);
            return promise;
        }
        catch (InterruptedException e) {
            throw new DMLRuntimeException("Could not send federated operation.");
        }
        catch (Exception e) {
            throw new DMLRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearFederatedWorkers() {
        if (_allFedSites.isEmpty()) {
            return;
        }
        try {
            FederatedRequest fr = new FederatedRequest(FederatedRequest.RequestType.CLEAR);
            ArrayList<Future<FederatedResponse>> ret = new ArrayList<Future<FederatedResponse>>();
            for (InetSocketAddress address : _allFedSites) {
                ret.add(FederatedData.executeFederatedOperation(address, fr));
            }
            FederationUtils.waitFor(ret);
        }
        catch (Exception ex) {
            LOG.warn((Object)"Failed to execute CLEAR request on existing federated sites.", (Throwable)ex);
        }
        finally {
            FederatedData.resetFederatedSites();
        }
    }

    public static void resetFederatedSites() {
        _allFedSites.clear();
    }

    private static SslContextMan SslConstructor() {
        if (instance == null) {
            return new SslContextMan();
        }
        return instance;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName().toString());
        sb.append(" " + (Object)((Object)this._dataType));
        sb.append(" " + this._address.toString());
        sb.append(":" + this._filepath);
        return sb.toString();
    }

    private static class SslContextMan {
        protected final SslContext context;

        private SslContextMan() {
            try {
                this.context = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
            }
            catch (SSLException e) {
                throw new DMLRuntimeException("Static SSL setup failed for client side", e);
            }
        }
    }

    private static class DataRequestHandler
    extends ChannelInboundHandlerAdapter {
        private Promise<FederatedResponse> _prom;
        private EventLoopGroup _workerGroup;

        public DataRequestHandler(EventLoopGroup workerGroup) {
            this._workerGroup = workerGroup;
        }

        public void setPromise(Promise<FederatedResponse> prom) {
            this._prom = prom;
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            if (this._prom == null) {
                throw new DMLRuntimeException("Read while no message was sent");
            }
            this._prom.setSuccess((Object)((FederatedResponse)msg));
            ctx.close();
            this._workerGroup.shutdownGracefully();
        }
    }
}

