/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.json4j;

import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Stack;
import org.apache.wink.json4j.JSONArtifact;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONString;
import org.apache.wink.json4j.internal.BeanSerializer;

public class JSONWriter {
    protected Writer writer = null;
    private boolean inObject = false;
    private boolean inArray = false;
    private boolean keyPlaced = false;
    private boolean firstEntry = false;
    private Stack closures = null;
    private boolean closed = false;

    public JSONWriter(Writer writer) throws NullPointerException {
        Class<?> writerClass = writer.getClass();
        if (!(StringWriter.class.isAssignableFrom(writerClass) || CharArrayWriter.class.isAssignableFrom(writerClass) || BufferedWriter.class.isAssignableFrom(writerClass))) {
            writer = new BufferedWriter(writer);
        }
        this.writer = writer;
        this.closures = new Stack();
    }

    public JSONWriter array() throws IOException, IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("The writer has been closed.  No further operations allowed.");
        }
        if (this.inObject) {
            if (!this.keyPlaced) {
                throw new IllegalStateException("Current containment is a JSONObject, but a key has not been specified to contain a new array");
            }
        } else if (this.inArray && !this.firstEntry) {
            this.writer.write(",");
        }
        this.writer.write("[");
        this.inArray = true;
        this.inObject = false;
        this.keyPlaced = false;
        this.firstEntry = true;
        this.closures.push("]");
        return this;
    }

    public JSONWriter endArray() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("The writer has been closed.  No further operations allowed.");
        }
        if (!this.inArray) {
            throw new IllegalStateException("Current writer position is not within a JSON array");
        }
        this.writer.write((String)this.closures.pop());
        if (!this.closures.isEmpty()) {
            String nextClosure = (String)this.closures.peek();
            if (nextClosure.equals("}")) {
                this.inObject = true;
                this.inArray = false;
            } else {
                this.inObject = false;
                this.inArray = true;
            }
            this.firstEntry = false;
        } else {
            this.inArray = false;
            this.inObject = false;
            this.firstEntry = true;
        }
        return this;
    }

    public JSONWriter endObject() throws IOException, IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("The writer has been closed.  No further operations allowed.");
        }
        if (!this.inObject) {
            throw new IllegalStateException("Current writer position is not within a JSON object");
        }
        if (this.keyPlaced) {
            throw new IllegalStateException("Current writer position in an object and has a key placed, but no value has been assigned to the key.  Cannot end.");
        }
        this.writer.write((String)this.closures.pop());
        if (!this.closures.isEmpty()) {
            String nextClosure = (String)this.closures.peek();
            if (nextClosure.equals("}")) {
                this.inObject = true;
                this.inArray = false;
            } else {
                this.inObject = false;
                this.inArray = true;
            }
            this.firstEntry = false;
        } else {
            this.inArray = false;
            this.inObject = false;
            this.firstEntry = true;
        }
        return this;
    }

    public JSONWriter key(String s) throws IOException, IllegalStateException, NullPointerException {
        if (this.closed) {
            throw new IllegalStateException("The writer has been closed.  No further operations allowed.");
        }
        if (s == null) {
            throw new NullPointerException("Key cannot be null");
        }
        if (!this.inObject) {
            throw new IllegalStateException("Current writer position is not inside a JSON Object, a key cannot be placed.");
        }
        if (!this.keyPlaced) {
            if (this.firstEntry) {
                this.firstEntry = false;
            } else {
                this.writer.write(",");
            }
        } else {
            throw new IllegalStateException("Current writer position is inside a JSON Object an with an open key waiting for a value.  Another key cannot be placed.");
        }
        this.keyPlaced = true;
        this.writeString(s);
        this.writer.write(":");
        return this;
    }

    public JSONWriter object() throws IOException, IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("The writer has been closed.  No further operations allowed.");
        }
        if (this.inObject) {
            if (!this.keyPlaced) {
                throw new IllegalStateException("Current containment is a JSONObject, but a key has not been specified to contain a new object");
            }
        } else if (this.inArray && !this.firstEntry) {
            this.writer.write(",");
        }
        this.writer.write("{");
        this.inObject = true;
        this.inArray = false;
        this.keyPlaced = false;
        this.firstEntry = true;
        this.closures.push("}");
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JSONWriter value(boolean b) throws IOException, IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("The writer has been closed.  No further operations allowed.");
        }
        if (this.inArray) {
            if (this.firstEntry) {
                this.firstEntry = false;
            } else {
                this.writer.write(",");
            }
            this.writer.write(Boolean.toString(b));
            return this;
        } else {
            if (!this.inObject) throw new IllegalStateException("Writer is currently not in an array or object, cannot write value");
            if (!this.keyPlaced) throw new IllegalStateException("Current containment is a JSONObject, but a key has not been specified for the boolean value.");
            this.writer.write(Boolean.toString(b));
            this.keyPlaced = false;
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JSONWriter value(double d) throws IOException, IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("The writer has been closed.  No further operations allowed.");
        }
        if (this.inArray) {
            if (this.firstEntry) {
                this.firstEntry = false;
            } else {
                this.writer.write(",");
            }
            this.writer.write(Double.toString(d));
            return this;
        } else {
            if (!this.inObject) throw new IllegalStateException("Writer is currently not in an array or object, cannot write value");
            if (!this.keyPlaced) throw new IllegalStateException("Current containment is a JSONObject, but a key has not been specified for the double value.");
            this.writer.write(Double.toString(d));
            this.keyPlaced = false;
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JSONWriter value(long l) throws IOException, IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("The writer has been closed.  No further operations allowed.");
        }
        if (this.inArray) {
            if (this.firstEntry) {
                this.firstEntry = false;
            } else {
                this.writer.write(",");
            }
            this.writer.write(Long.toString(l));
            return this;
        } else {
            if (!this.inObject) throw new IllegalStateException("Writer is currently not in an array or object, cannot write value");
            if (!this.keyPlaced) throw new IllegalStateException("Current containment is a JSONObject, but a key has not been specified for the long value.");
            this.writer.write(Long.toString(l));
            this.keyPlaced = false;
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JSONWriter value(int i) throws IOException, IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("The writer has been closed.  No further operations allowed.");
        }
        if (this.inArray) {
            if (this.firstEntry) {
                this.firstEntry = false;
            } else {
                this.writer.write(",");
            }
            this.writer.write(Integer.toString(i));
            return this;
        } else {
            if (!this.inObject) throw new IllegalStateException("Writer is currently not in an array or object, cannot write value");
            if (!this.keyPlaced) throw new IllegalStateException("Current containment is a JSONObject, but a key has not been specified for the int value.");
            this.writer.write(Integer.toString(i));
            this.keyPlaced = false;
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JSONWriter value(short s) throws IOException, IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("The writer has been closed.  No further operations allowed.");
        }
        if (this.inArray) {
            if (this.firstEntry) {
                this.firstEntry = false;
            } else {
                this.writer.write(",");
            }
            this.writer.write(Short.toString(s));
            return this;
        } else {
            if (!this.inObject) throw new IllegalStateException("Writer is currently not in an array or object, cannot write value");
            if (!this.keyPlaced) throw new IllegalStateException("Current containment is a JSONObject, but a key has not been specified for the short value.");
            this.writer.write(Short.toString(s));
            this.keyPlaced = false;
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JSONWriter value(Object o) throws IOException, IllegalStateException, JSONException {
        if (this.closed) {
            throw new IllegalStateException("The writer has been closed.  No further operations allowed.");
        }
        if (this.inArray) {
            if (this.firstEntry) {
                this.firstEntry = false;
            } else {
                this.writer.write(",");
            }
            this.writeObject(o);
            return this;
        } else {
            if (!this.inObject) throw new IllegalStateException("Writer is currently not in an array or object, cannot write value");
            if (!this.keyPlaced) throw new IllegalStateException("Current containment is a JSONObject, but a key has not been specified for the boolean value.");
            this.writeObject(o);
            this.keyPlaced = false;
        }
        return this;
    }

    public void close() throws IOException, IllegalStateException {
        if (!this.closed) {
            if (this.inObject && this.keyPlaced) {
                throw new IllegalStateException("Object has key without value.  Cannot close.");
            }
            while (!this.closures.isEmpty()) {
                this.writer.write((String)this.closures.pop());
            }
            this.writer.flush();
            this.writer.close();
            this.closed = true;
        }
    }

    public JSONWriter flush() throws IOException {
        this.writer.flush();
        return this;
    }

    private void writeString(String value) throws IOException {
        this.writer.write(34);
        char[] chars = value.toCharArray();
        block11: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '\"': {
                    this.writer.write("\\\"");
                    continue block11;
                }
                case '\\': {
                    this.writer.write("\\\\");
                    continue block11;
                }
                case '\u0000': {
                    this.writer.write("\\0");
                    continue block11;
                }
                case '\b': {
                    this.writer.write("\\b");
                    continue block11;
                }
                case '\t': {
                    this.writer.write("\\t");
                    continue block11;
                }
                case '\n': {
                    this.writer.write("\\n");
                    continue block11;
                }
                case '\f': {
                    this.writer.write("\\f");
                    continue block11;
                }
                case '\r': {
                    this.writer.write("\\r");
                    continue block11;
                }
                case '/': {
                    this.writer.write("\\/");
                    continue block11;
                }
                default: {
                    if (c >= ' ' && c <= '~') {
                        this.writer.write(c);
                        continue block11;
                    }
                    this.writer.write("\\u");
                    this.writer.write(this.rightAlignedZero(Integer.toHexString(c), 4));
                }
            }
        }
        this.writer.write(34);
    }

    private String rightAlignedZero(String s, int len) {
        if (len == s.length()) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s);
        while (sb.length() < len) {
            sb.insert(0, '0');
        }
        return sb.toString();
    }

    private void writeNumber(Number value) throws IOException {
        if (null == value) {
            this.writeNull();
        }
        if (value instanceof Float) {
            if (((Float)value).isNaN()) {
                this.writeNull();
            }
            if (Float.NEGATIVE_INFINITY == value.floatValue()) {
                this.writeNull();
            }
            if (Float.POSITIVE_INFINITY == value.floatValue()) {
                this.writeNull();
            }
        }
        if (value instanceof Double) {
            if (((Double)value).isNaN()) {
                this.writeNull();
            }
            if (Double.NEGATIVE_INFINITY == value.doubleValue()) {
                this.writeNull();
            }
            if (Double.POSITIVE_INFINITY == value.doubleValue()) {
                this.writeNull();
            }
        }
        this.writer.write(value.toString());
    }

    private void writeObject(Object o) throws IOException, JSONException {
        if (o == null) {
            this.writeNull();
        } else {
            Class<?> clazz = o.getClass();
            if (JSONArtifact.class.isAssignableFrom(clazz)) {
                this.writer.write(((JSONArtifact)o).toString());
            } else if (Number.class.isAssignableFrom(clazz)) {
                this.writeNumber((Number)o);
            } else if (Boolean.class.isAssignableFrom(clazz)) {
                this.writer.write(((Boolean)o).toString());
            } else if (String.class.isAssignableFrom(clazz)) {
                this.writeString((String)o);
            } else if (JSONString.class.isAssignableFrom(clazz)) {
                this.writer.write(((JSONString)o).toJSONString());
            } else {
                this.writer.write(BeanSerializer.toJson(o, true).write());
            }
        }
    }

    private void writeNull() throws IOException {
        this.writer.write("null");
    }
}

