/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.bitmap;

import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.apache.sysds.runtime.compress.bitmap.ABitmap;
import org.apache.sysds.runtime.compress.utils.IntArrayList;
import org.apache.sysds.runtime.util.SortUtils;

public final class Bitmap
extends ABitmap {
    private double[] _values;

    protected Bitmap(IntArrayList[] offsetsLists, double[] values, int rows) {
        super(offsetsLists, rows);
        this._values = values;
    }

    public final double[] getValues() {
        return this._values;
    }

    @Override
    public final int getNumNonZerosInOffset(int idx) {
        return this._values[idx] != 0.0 ? 1 : 0;
    }

    @Override
    public final int getNumValues() {
        return this._values == null ? 0 : this._values.length;
    }

    @Override
    public final void sortValuesByFrequency() {
        int numVals = this.getNumValues();
        double[] freq = new double[numVals];
        int[] pos = new int[numVals];
        for (int i = 0; i < numVals; ++i) {
            freq[i] = this.getNumOffsets(i);
            pos[i] = i;
        }
        SortUtils.sortByValue(0, numVals, freq, pos);
        ArrayUtils.reverse((int[])pos);
        double[] lvalues = new double[numVals];
        IntArrayList[] loffsets = new IntArrayList[numVals];
        for (int i = 0; i < numVals; ++i) {
            lvalues[i] = this._values[pos[i]];
            loffsets[i] = this._offsetsLists[pos[i]];
        }
        this._values = lvalues;
        this._offsetsLists = loffsets;
    }

    @Override
    public int getNumColumns() {
        return 1;
    }

    @Override
    protected void addToString(StringBuilder sb) {
        sb.append("\nValues: " + Arrays.toString(this._values));
    }
}

