# -------------------------------------------------------------
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#
# -------------------------------------------------------------

# Autogenerated By   : src/main/python/generator/generator.py
# Autogenerated From : scripts/builtin/img_sample_pairing.dml

from typing import Dict, Iterable

from systemds.operator import OperationNode, Matrix, Frame, List, MultiReturn, Scalar
from systemds.script_building.dag import OutputType
from systemds.utils.consts import VALID_INPUT_TYPES


def img_sample_pairing(img_in1: Matrix,
                       img_in2: Matrix,
                       weight: float):
    """
    :param img_in1: First input image
    :param img_in2: Second input image
    :param weight: The weight given to the second image.
    :param 0: img_in1, 1 means only img_in2 will be visible
    :return: 'OperationNode' containing  
    """
    params_dict = {'img_in1': img_in1, 'img_in2': img_in2, 'weight': weight}
    return Matrix(img_in1.sds_context,
        'img_sample_pairing',
        named_input_nodes=params_dict)
