/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.fed;

import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.fed.BinaryMatrixMatrixFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.BinaryMatrixScalarFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.ComputationFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;
import org.apache.sysds.runtime.matrix.operators.Operator;

public abstract class BinaryFEDInstruction
extends ComputationFEDInstruction {
    protected BinaryFEDInstruction(FEDInstruction.FEDType type, Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(type, op, in1, in2, out, opcode, istr);
    }

    public static BinaryFEDInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 3);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand in2 = new CPOperand(parts[2]);
        CPOperand out = new CPOperand(parts[3]);
        BinaryFEDInstruction.checkOutputDataType(in1, in2, out);
        Operator operator = InstructionUtils.parseBinaryOrBuiltinOperator(opcode, in1, in2);
        if (in1.getDataType() == Types.DataType.SCALAR && in2.getDataType() == Types.DataType.SCALAR) {
            throw new DMLRuntimeException("Federated binary scalar scalar operations not yet supported");
        }
        if (in1.getDataType() == Types.DataType.MATRIX && in2.getDataType() == Types.DataType.MATRIX) {
            return new BinaryMatrixMatrixFEDInstruction(operator, in1, in2, out, opcode, str);
        }
        if (in1.getDataType() == Types.DataType.TENSOR && in2.getDataType() == Types.DataType.TENSOR) {
            throw new DMLRuntimeException("Federated binary tensor tensor operations not yet supported");
        }
        if (in1.isMatrix() && in2.isScalar()) {
            return new BinaryMatrixScalarFEDInstruction(operator, in1, in2, out, opcode, str);
        }
        if (in2.isMatrix() && in1.isScalar()) {
            return new BinaryMatrixScalarFEDInstruction(operator, in1, in2, out, opcode, str);
        }
        throw new DMLRuntimeException("Federated binary operations not yet supported:" + opcode);
    }

    protected static void checkOutputDataType(CPOperand in1, CPOperand in2, CPOperand out) {
        if ((in1.getDataType() == Types.DataType.MATRIX || in2.getDataType() == Types.DataType.MATRIX) && out.getDataType() != Types.DataType.MATRIX) {
            throw new DMLRuntimeException("Element-wise matrix operations between variables " + in1.getName() + " and " + in2.getName() + " must produce a matrix, which " + out.getName() + " is not");
        }
    }
}

