/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.net.InetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.ipc.Server;

class AuditLogger {
    private static final Log LOG = LogFactory.getLog(AuditLogger.class);

    AuditLogger() {
    }

    static String createSuccessLog(String user, String operation, String target) {
        StringBuilder b = new StringBuilder();
        AuditLogger.start(Keys.USER, user, b);
        AuditLogger.addRemoteIP(b);
        AuditLogger.add(Keys.OPERATION, operation, b);
        AuditLogger.add(Keys.TARGET, target, b);
        AuditLogger.add(Keys.RESULT, "SUCCESS", b);
        return b.toString();
    }

    static void logSuccess(String user, String operation, String target) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)AuditLogger.createSuccessLog(user, operation, target));
        }
    }

    static String createFailureLog(String user, String operation, String perm, String target, String description) {
        StringBuilder b = new StringBuilder();
        AuditLogger.start(Keys.USER, user, b);
        AuditLogger.addRemoteIP(b);
        AuditLogger.add(Keys.OPERATION, operation, b);
        AuditLogger.add(Keys.TARGET, target, b);
        AuditLogger.add(Keys.RESULT, "FAILURE", b);
        AuditLogger.add(Keys.DESCRIPTION, description, b);
        AuditLogger.add(Keys.PERMISSIONS, perm, b);
        return b.toString();
    }

    static void logFailure(String user, String operation, String perm, String target, String description) {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)AuditLogger.createFailureLog(user, operation, perm, target, description));
        }
    }

    static void addRemoteIP(StringBuilder b) {
        InetAddress ip = Server.getRemoteIp();
        if (ip != null) {
            AuditLogger.add(Keys.IP, ip.getHostAddress(), b);
        }
    }

    static void start(Keys key, String value, StringBuilder b) {
        b.append(key.name()).append("=").append(value);
    }

    static void add(Keys key, String value, StringBuilder b) {
        b.append('\t').append(key.name()).append("=").append(value);
    }

    static class Constants {
        static final String SUCCESS = "SUCCESS";
        static final String FAILURE = "FAILURE";
        static final String KEY_VAL_SEPARATOR = "=";
        static final char PAIR_SEPARATOR = '\t';
        static final String JOBTRACKER = "JobTracker";
        static final String REFRESH_QUEUE = "REFRESH_QUEUE";
        static final String REFRESH_NODES = "REFRESH_NODES";
        static final String UNAUTHORIZED_USER = "Unauthorized user";

        Constants() {
        }
    }

    static enum Keys {
        USER,
        OPERATION,
        TARGET,
        RESULT,
        IP,
        PERMISSIONS,
        DESCRIPTION;

    }
}

