/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.colgroup.ColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupDDC1;
import org.apache.sysds.runtime.compress.colgroup.ColGroupDDC2;
import org.apache.sysds.runtime.compress.colgroup.ColGroupOLE;
import org.apache.sysds.runtime.compress.colgroup.ColGroupRLE;
import org.apache.sysds.runtime.compress.colgroup.ColGroupUncompressed;

public class ColGroupIO {
    protected static final Log LOG = LogFactory.getLog((String)ColGroupIO.class.getName());

    public static List<ColGroup> readGroups(DataInput in) throws IOException {
        int nColGroups = in.readInt();
        LOG.debug((Object)("reading " + nColGroups + " ColGroups"));
        ArrayList<ColGroup> _colGroups = new ArrayList<ColGroup>(nColGroups);
        for (int i = 0; i < nColGroups; ++i) {
            ColGroup.ColGroupType ctype = ColGroup.ColGroupType.values()[in.readByte()];
            LOG.debug((Object)ctype);
            ColGroup grp = null;
            switch (ctype) {
                case UNCOMPRESSED: {
                    grp = new ColGroupUncompressed();
                    break;
                }
                case OLE: {
                    grp = new ColGroupOLE();
                    break;
                }
                case RLE: {
                    grp = new ColGroupRLE();
                    break;
                }
                case DDC1: {
                    grp = new ColGroupDDC1();
                    break;
                }
                case DDC2: {
                    grp = new ColGroupDDC2();
                    break;
                }
                default: {
                    throw new DMLRuntimeException("Unsupported ColGroup Type used:  " + (Object)((Object)ctype));
                }
            }
            grp.readFields(in);
            _colGroups.add(grp);
        }
        return _colGroups;
    }

    public static void writeGroups(DataOutput out, List<ColGroup> colGroups) throws IOException {
        out.writeInt(colGroups.size());
        for (ColGroup grp : colGroups) {
            out.writeByte(grp.getColGroupType().ordinal());
            grp.write(out);
        }
    }
}

