/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.lineage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.lops.MMTSJ;
import org.apache.sysds.parser.DataIdentifier;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysds.runtime.instructions.CPInstructionParser;
import org.apache.sysds.runtime.instructions.Instruction;
import org.apache.sysds.runtime.instructions.cp.CPInstruction;
import org.apache.sysds.runtime.instructions.cp.ComputationCPInstruction;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.MMTSJCPInstruction;
import org.apache.sysds.runtime.instructions.cp.MultiReturnBuiltinCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ParameterizedBuiltinCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.lineage.LineageCacheConfig;
import org.apache.sysds.runtime.lineage.LineageCacheEntry;
import org.apache.sysds.runtime.lineage.LineageCacheEviction;
import org.apache.sysds.runtime.lineage.LineageCacheStatistics;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.lineage.LineageRewriteReuse;
import org.apache.sysds.runtime.lineage.LineageTraceable;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.meta.MetaDataFormat;

public class LineageCache {
    private static final Map<LineageItem, LineageCacheEntry> _cache = new HashMap<LineageItem, LineageCacheEntry>();
    private static final double CACHE_FRAC = 0.05;
    protected static final boolean DEBUG = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static boolean reuse(Instruction inst, ExecutionContext ec) {
        if (LineageCacheConfig.ReuseCacheType.isNone()) {
            return false;
        }
        boolean reuse = false;
        if (LineageCacheConfig.isReusable(inst, ec)) {
            ComputationCPInstruction cinst = (ComputationCPInstruction)inst;
            LineageItem instLI = (LineageItem)cinst.getLineageItem(ec).getValue();
            List<Object> liList = null;
            if (inst instanceof MultiReturnBuiltinCPInstruction) {
                liList = new ArrayList();
                MultiReturnBuiltinCPInstruction mrInst = (MultiReturnBuiltinCPInstruction)inst;
                for (int i = 0; i < mrInst.getNumOutputs(); ++i) {
                    String opcode = instLI.getOpcode() + String.valueOf(i);
                    liList.add(MutablePair.of((Object)new LineageItem(opcode, instLI.getInputs()), null));
                }
            } else {
                liList = Arrays.asList(MutablePair.of((Object)instLI, null));
            }
            LineageCacheEntry e = null;
            boolean reuseAll = true;
            Map<LineageItem, LineageCacheEntry> map = _cache;
            synchronized (map) {
                for (MutablePair mutablePair : liList) {
                    if (LineageCacheConfig.getCacheType().isFullReuse()) {
                        LineageCacheEntry lineageCacheEntry = e = LineageCache.probe((LineageItem)mutablePair.getKey()) ? LineageCache.getIntern((LineageItem)mutablePair.getKey()) : null;
                    }
                    if (e == null && LineageCacheConfig.getCacheType().isPartialReuse() && LineageRewriteReuse.executeRewrites(inst, ec)) {
                        e = LineageCache.getIntern((LineageItem)mutablePair.getKey());
                    }
                    reuseAll &= e != null;
                    mutablePair.setValue((Object)e);
                    if (e != null || !LineageCache.isMarkedForCaching(inst, ec)) continue;
                    LineageCache.putIntern((LineageItem)mutablePair.getKey(), cinst.output.getDataType(), null, null, 0L);
                }
            }
            reuse = reuseAll;
            if (reuse) {
                for (MutablePair mutablePair : liList) {
                    void var10_17;
                    e = (LineageCacheEntry)mutablePair.getValue();
                    Object var10_14 = null;
                    if (inst instanceof MultiReturnBuiltinCPInstruction) {
                        String string = ((MultiReturnBuiltinCPInstruction)inst).getOutput(((LineageItem)mutablePair.getKey()).getOpcode().charAt(((LineageItem)mutablePair.getKey()).getOpcode().length() - 1) - 48).getName();
                    } else {
                        String string = cinst.output.getName();
                    }
                    if (e.isMatrixValue()) {
                        ec.setMatrixOutput((String)var10_17, e.getMBValue());
                    } else {
                        ec.setScalarOutput((String)var10_17, e.getSOValue());
                    }
                    reuse = true;
                }
                if (DMLScript.STATISTICS) {
                    LineageCacheStatistics.incrementInstHits();
                }
            }
        }
        return reuse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean reuse(List<String> outNames, List<DataIdentifier> outParams, int numOutputs, LineageItem[] liInputs, String name, ExecutionContext ec) {
        if (!LineageCacheConfig.isMultiLevelReuse()) {
            return false;
        }
        boolean reuse = outParams.size() != 0;
        HashMap<String, Data> funcOutputs = new HashMap<String, Data>();
        HashMap<String, LineageItem> funcLIs = new HashMap<String, LineageItem>();
        for (int i = 0; i < numOutputs; ++i) {
            String opcode = name + String.valueOf(i + 1);
            LineageItem li2 = new LineageItem(opcode, liInputs);
            LineageCacheEntry e = null;
            Map<LineageItem, LineageCacheEntry> map = _cache;
            synchronized (map) {
                if (LineageCache.probe(li2)) {
                    e = LineageCache.getIntern(li2);
                } else {
                    LineageCache.putIntern(li2, outParams.get(i).getDataType(), null, null, 0L);
                }
            }
            if (e != null) {
                String boundVarName = outNames.get(i);
                Data boundValue = null;
                if (e.isMatrixValue()) {
                    MetaDataFormat md = new MetaDataFormat(e.getMBValue().getDataCharacteristics(), Types.FileFormat.BINARY);
                    boundValue = new MatrixObject(Types.ValueType.FP64, boundVarName, md);
                    ((MatrixObject)boundValue).acquireModify(e.getMBValue());
                    ((MatrixObject)boundValue).release();
                } else {
                    boundValue = e.getSOValue();
                }
                funcOutputs.put(boundVarName, boundValue);
                LineageItem orig = e._origItem;
                funcLIs.put(boundVarName, orig);
                continue;
            }
            reuse = false;
        }
        if (reuse) {
            funcOutputs.forEach((var, val) -> {
                Data exdata = ec.removeVariable((String)var);
                if (exdata != val) {
                    ec.cleanupDataObject(exdata);
                }
                ec.setVariable((String)var, (Data)val);
            });
            funcLIs.forEach((var, li) -> ec.getLineage().set((String)var, (LineageItem)li));
        }
        return reuse;
    }

    public static boolean probe(LineageItem key) {
        boolean p = _cache.containsKey(key);
        if (!p && DMLScript.STATISTICS && LineageCacheEviction._removelist.contains(key)) {
            LineageCacheStatistics.incrementDelHits();
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MatrixBlock getMatrix(LineageItem key) {
        LineageCacheEntry e = null;
        Map<LineageItem, LineageCacheEntry> map = _cache;
        synchronized (map) {
            e = LineageCache.getIntern(key);
        }
        return e.getMBValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putMatrix(Instruction inst, ExecutionContext ec, long computetime) {
        if (LineageCacheConfig.isReusable(inst, ec)) {
            LineageItem item = (LineageItem)((LineageTraceable)((Object)inst)).getLineageItem(ec).getValue();
            MatrixObject mo = ec.getMatrixObject(((ComputationCPInstruction)inst).output);
            Map<LineageItem, LineageCacheEntry> map = _cache;
            synchronized (map) {
                LineageCache.putIntern(item, Types.DataType.MATRIX, (MatrixBlock)mo.acquireReadAndRelease(), null, computetime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putValue(Instruction inst, ExecutionContext ec, long starttime) {
        if (LineageCacheConfig.ReuseCacheType.isNone()) {
            return;
        }
        long computetime = System.nanoTime() - starttime;
        if (LineageCacheConfig.isReusable(inst, ec)) {
            List<Object> liData = null;
            LineageItem instLI = (LineageItem)((LineageTraceable)((Object)inst)).getLineageItem(ec).getValue();
            if (inst instanceof MultiReturnBuiltinCPInstruction) {
                liData = new ArrayList();
                MultiReturnBuiltinCPInstruction mrInst = (MultiReturnBuiltinCPInstruction)inst;
                for (int i = 0; i < mrInst.getNumOutputs(); ++i) {
                    String string = instLI.getOpcode() + String.valueOf(i);
                    LineageItem li = new LineageItem(string, instLI.getInputs());
                    Data value = ec.getVariable(mrInst.getOutput(i));
                    liData.add(Pair.of((Object)li, (Object)value));
                }
            } else {
                liData = Arrays.asList(Pair.of((Object)instLI, (Object)ec.getVariable(((ComputationCPInstruction)inst).output)));
            }
            Map<LineageItem, LineageCacheEntry> map = _cache;
            synchronized (map) {
                for (Pair pair : liData) {
                    LineageItem item = (LineageItem)pair.getKey();
                    Data data = (Data)pair.getValue();
                    LineageCacheEntry centry = _cache.get(item);
                    if (data instanceof MatrixObject) {
                        centry.setValue((MatrixBlock)((MatrixObject)data).acquireReadAndRelease(), computetime);
                    } else if (data instanceof ScalarObject) {
                        centry.setValue((ScalarObject)data, computetime);
                    } else {
                        _cache.remove(item);
                        continue;
                    }
                    long size = centry.getSize();
                    if (size > LineageCacheEviction.getCacheLimit()) {
                        _cache.remove(item);
                        continue;
                    }
                    LineageCacheEviction.addEntry(centry);
                    if (!LineageCacheEviction.isBelowThreshold(size)) {
                        LineageCacheEviction.makeSpace(_cache, size);
                    }
                    LineageCacheEviction.updateSize(size, true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putValue(List<DataIdentifier> outputs, LineageItem[] liInputs, String name, ExecutionContext ec, long computetime) {
        if (!LineageCacheConfig.isMultiLevelReuse()) {
            return;
        }
        HashMap<LineageItem, LineageItem> FuncLIMap = new HashMap<LineageItem, LineageItem>();
        boolean AllOutputsCacheable = true;
        for (int i = 0; i < outputs.size(); ++i) {
            String opcode = name + String.valueOf(i + 1);
            LineageItem li = new LineageItem(opcode, liInputs);
            String boundVarName = outputs.get(i).getName();
            LineageItem boundLI2 = ec.getLineage().get(boundVarName);
            if (boundLI2 != null) {
                boundLI2.resetVisitStatusNR();
            }
            if (boundLI2 == null || !LineageCache.probe(li) || !LineageCache.probe(boundLI2)) {
                AllOutputsCacheable = false;
            }
            FuncLIMap.put(li, boundLI2);
        }
        Map<LineageItem, LineageCacheEntry> map = _cache;
        synchronized (map) {
            if (AllOutputsCacheable) {
                FuncLIMap.forEach((Li, boundLI) -> LineageCache.mvIntern(Li, boundLI, computetime));
            } else {
                FuncLIMap.forEach((Li, boundLI) -> _cache.remove(Li));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetCache() {
        Map<LineageItem, LineageCacheEntry> map = _cache;
        synchronized (map) {
            _cache.clear();
            LineageCacheEviction.resetEviction();
        }
    }

    private static void putIntern(LineageItem key, Types.DataType dt, MatrixBlock Mval, ScalarObject Sval, long computetime) {
        if (_cache.containsKey(key)) {
            return;
        }
        LineageCacheEntry newItem = new LineageCacheEntry(key, dt, Mval, Sval, computetime);
        if (Mval != null || Sval != null) {
            long size = newItem.getSize();
            if (size > LineageCacheEviction.getCacheLimit()) {
                return;
            }
            if (!LineageCacheEviction.isBelowThreshold(size)) {
                LineageCacheEviction.makeSpace(_cache, size);
            }
            LineageCacheEviction.updateSize(size, true);
        }
        LineageCacheEviction.addEntry(newItem);
        _cache.put(key, newItem);
        if (DMLScript.STATISTICS) {
            LineageCacheStatistics.incrementMemWrites();
        }
    }

    private static LineageCacheEntry getIntern(LineageItem key) {
        LineageCacheEntry e = _cache.get(key);
        if (e != null && e.getCacheStatus() != LineageCacheConfig.LineageCacheStatus.SPILLED) {
            LineageCacheEviction.getEntry(e);
            if (DMLScript.STATISTICS) {
                LineageCacheStatistics.incrementMemHits();
            }
            return e;
        }
        return LineageCacheEviction.readFromLocalFS(_cache, key);
    }

    private static void mvIntern(LineageItem item, LineageItem probeItem, long computetime) {
        if (LineageCacheConfig.ReuseCacheType.isNone()) {
            return;
        }
        if (LineageCache.probe(probeItem)) {
            boolean exists;
            LineageCacheEntry oe = LineageCache.getIntern(probeItem);
            LineageCacheEntry e = _cache.get(item);
            boolean bl = exists = !e.isNullVal();
            if (oe.isMatrixValue()) {
                e.setValue(oe.getMBValue(), computetime);
            } else {
                e.setValue(oe.getSOValue(), computetime);
            }
            e._origItem = probeItem;
            oe._origItem = probeItem;
            if (!exists) {
                e._nextEntry = oe._nextEntry;
                oe._nextEntry = e;
            }
            LineageCacheEviction.addEntry(e);
        } else {
            _cache.remove(item);
        }
    }

    private static boolean isMarkedForCaching(Instruction inst, ExecutionContext ec) {
        if (!LineageCacheConfig.getCompAssRW()) {
            return true;
        }
        if (((ComputationCPInstruction)inst).output.isMatrix()) {
            MatrixObject mo = ec.getMatrixObject(((ComputationCPInstruction)inst).output);
            return LineageCacheConfig.getCacheType() != LineageCacheConfig.ReuseCacheType.REUSE_FULL || mo.isMarked();
        }
        return true;
    }

    @Deprecated
    private static double getRecomputeEstimate(Instruction inst, ExecutionContext ec) {
        if (!((ComputationCPInstruction)inst).output.isMatrix() || ((ComputationCPInstruction)inst).input1 != null && !((ComputationCPInstruction)inst).input1.isMatrix()) {
            return 0.0;
        }
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        double nflops = 0.0;
        String instop = inst.getOpcode().contains("spoof") ? "spoof" : inst.getOpcode();
        CPInstruction.CPType cptype = CPInstructionParser.String2CPInstructionType.get(instop);
        switch (cptype) {
            case MMTSJ: {
                MatrixObject mo = ec.getMatrixObject(((ComputationCPInstruction)inst).input1);
                long r = mo.getNumRows();
                long c = mo.getNumColumns();
                long nnz = mo.getNnz();
                double s = OptimizerUtils.getSparsity(r, c, nnz);
                boolean sparse = MatrixBlock.evalSparseFormatInMemory(r, c, nnz);
                MMTSJ.MMTSJType type = ((MMTSJCPInstruction)inst).getMMTSJType();
                if (type.isLeft()) {
                    nflops = !sparse ? (double)(r * c) * s * (double)c / 2.0 : (double)(r * c) * s * (double)c * s / 2.0;
                    break;
                }
                nflops = !sparse ? (double)r * (double)c * (double)r / 2.0 : (double)(r * c) * s + (double)(r * c) * s * (double)c * s / 2.0;
                break;
            }
            case AggregateBinary: {
                MatrixObject mo1 = ec.getMatrixObject(((ComputationCPInstruction)inst).input1);
                MatrixObject mo2 = ec.getMatrixObject(((ComputationCPInstruction)inst).input2);
                long r1 = mo1.getNumRows();
                long c1 = mo1.getNumColumns();
                long nnz1 = mo1.getNnz();
                double s1 = OptimizerUtils.getSparsity(r1, c1, nnz1);
                boolean lsparse = MatrixBlock.evalSparseFormatInMemory(r1, c1, nnz1);
                long r2 = mo2.getNumRows();
                long c2 = mo2.getNumColumns();
                long nnz2 = mo2.getNnz();
                double s2 = OptimizerUtils.getSparsity(r2, c2, nnz2);
                boolean rsparse = MatrixBlock.evalSparseFormatInMemory(r2, c2, nnz2);
                if (!lsparse && !rsparse) {
                    nflops = 2.0 * ((double)(r1 * c1) * (c2 > 1L ? s1 : 1.0) * (double)c2) / 2.0;
                    break;
                }
                if (!lsparse && rsparse) {
                    nflops = 2.0 * ((double)(r1 * c1) * s1 * (double)c2 * s2) / 2.0;
                    break;
                }
                if (lsparse && !rsparse) {
                    nflops = 2.0 * ((double)(r1 * c1) * s1 * (double)c2) / 2.0;
                    break;
                }
                nflops = 2.0 * ((double)(r1 * c1) * s1 * (double)c2 * s2) / 2.0;
                break;
            }
            case Binary: {
                MatrixObject mo1 = ec.getMatrixObject(((ComputationCPInstruction)inst).input1);
                long r1 = mo1.getNumRows();
                long c1 = mo1.getNumColumns();
                if (inst.getOpcode().equalsIgnoreCase("*") || inst.getOpcode().equalsIgnoreCase("/")) {
                    nflops = r1 * c1;
                    break;
                }
                if (!inst.getOpcode().equalsIgnoreCase("solve")) break;
                nflops = r1 * c1 * c1;
                break;
            }
            case MatrixIndexing: {
                MatrixObject mo1 = ec.getMatrixObject(((ComputationCPInstruction)inst).input1);
                long r1 = mo1.getNumRows();
                long c1 = mo1.getNumColumns();
                long nnz1 = mo1.getNnz();
                double s1 = OptimizerUtils.getSparsity(r1, c1, nnz1);
                boolean lsparse = MatrixBlock.evalSparseFormatInMemory(r1, c1, nnz1);
                nflops = 1.0 * (lsparse ? (double)(r1 * c1) * s1 : (double)(r1 * c1));
                break;
            }
            case ParameterizedBuiltin: {
                String opcode = ((ParameterizedBuiltinCPInstruction)inst).getOpcode();
                HashMap<String, String> params = ((ParameterizedBuiltinCPInstruction)inst).getParameterMap();
                long r1 = ec.getMatrixObject(params.get("target")).getNumRows();
                String fn = params.get("fn");
                double xga = 0.0;
                if (opcode.equalsIgnoreCase("groupedagg")) {
                    if (fn.equalsIgnoreCase("sum")) {
                        xga = 4.0;
                    } else if (fn.equalsIgnoreCase("count")) {
                        xga = 1.0;
                    }
                }
                nflops = (double)(2L * r1) + xga * (double)r1;
                break;
            }
            case Reorg: {
                MatrixObject mo = ec.getMatrixObject(((ComputationCPInstruction)inst).input1);
                long r = mo.getNumRows();
                long c = mo.getNumColumns();
                long nnz = mo.getNnz();
                double s = OptimizerUtils.getSparsity(r, c, nnz);
                boolean sparse = MatrixBlock.evalSparseFormatInMemory(r, c, nnz);
                nflops = sparse ? (double)(r * c) * s : (double)(r * c);
                break;
            }
            case Append: {
                MatrixObject mo1 = ec.getMatrixObject(((ComputationCPInstruction)inst).input1);
                MatrixObject mo2 = ec.getMatrixObject(((ComputationCPInstruction)inst).input2);
                long r1 = mo1.getNumRows();
                long c1 = mo1.getNumColumns();
                long nnz1 = mo1.getNnz();
                double s1 = OptimizerUtils.getSparsity(r1, c1, nnz1);
                boolean lsparse = MatrixBlock.evalSparseFormatInMemory(r1, c1, nnz1);
                long r2 = mo2.getNumRows();
                long c2 = mo2.getNumColumns();
                long nnz2 = mo2.getNnz();
                double s2 = OptimizerUtils.getSparsity(r2, c2, nnz2);
                boolean rsparse = MatrixBlock.evalSparseFormatInMemory(r2, c2, nnz2);
                nflops = 1.0 * ((lsparse ? (double)(r1 * c1) * s1 : (double)(r1 * c1)) + (rsparse ? (double)(r2 * c2) * s2 : (double)(r2 * c2)));
                break;
            }
            case SpoofFused: {
                nflops = 0.0;
                break;
            }
            default: {
                throw new DMLRuntimeException("Lineage Cache: unsupported instruction: " + inst.getOpcode());
            }
        }
        return nflops / 2.147483648E9;
    }

    static {
        long maxMem = InfrastructureAnalyzer.getLocalMaxMemory();
        LineageCacheEviction.setCacheLimit((long)(0.05 * (double)maxMem));
        LineageCacheEviction.setStartTimestamp();
    }
}

