/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.estim;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.utils.ABitmap;

public class EstimationFactors {
    protected static final Log LOG = LogFactory.getLog((String)EstimationFactors.class.getName());
    protected final int numCols;
    protected final int numVals;
    protected final int numOffs;
    protected final int numRuns;
    protected final int numSingle;
    protected final int numRows;
    protected final boolean containsZero;
    protected final boolean lossy;

    protected EstimationFactors(int numCols, int numVals, int numOffs, int numRuns, int numSingle, int numRows, boolean containsZero, boolean lossy) {
        this.numCols = numCols;
        this.numVals = numVals;
        this.numOffs = numOffs;
        this.numRuns = numRuns;
        this.numSingle = numSingle;
        this.numRows = numRows;
        this.containsZero = containsZero;
        this.lossy = lossy;
        LOG.debug((Object)this);
    }

    protected static EstimationFactors computeSizeEstimationFactors(ABitmap ubm, boolean inclRLE, int numRows, int numCols) {
        int numVals = ubm.getNumValues();
        boolean containsZero = ubm.containsZero();
        int numRuns = 0;
        int numOffs = 0;
        int numSingle = 0;
        LOG.debug((Object)("NumCols :" + numCols));
        for (int i = 0; i < numVals; ++i) {
            int listSize = ubm.getNumOffsets(i);
            numOffs += listSize;
            numSingle += listSize == 1 ? 1 : 0;
            if (!inclRLE) continue;
            int[] list = ubm.getOffsetsList(i).extractValues();
            int lastOff = -2;
            numRuns += list[listSize - 1] / 65535;
            for (int j = 0; j < listSize; ++j) {
                if (list[j] != lastOff + 1) {
                    ++numRuns;
                }
                lastOff = list[j];
            }
        }
        return new EstimationFactors(numCols, numVals * numCols, numOffs + numVals, numRuns, numSingle, numRows, containsZero, ubm.getType() == ABitmap.BitmapType.Lossy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nrows:" + this.numRows);
        sb.append("\tcols:" + this.numCols);
        sb.append("\tnum Offsets:" + this.numOffs);
        sb.append("\tnum Singles:" + this.numSingle);
        sb.append("\tnum Runs:" + this.numRuns);
        sb.append("\tnum Unique Vals:" + this.numVals);
        sb.append("\tcontains a 0: " + this.containsZero);
        return sb.toString();
    }
}

