/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops;

import org.apache.sysds.common.Types;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.lops.LopProperties;
import org.apache.sysds.lops.LopsException;
import org.apache.sysds.runtime.instructions.InstructionUtils;

public class DnnTransform
extends Lop {
    private Types.OpOpDnn operation;
    private double intermediateMemBudget;
    private final int numThreads;

    public DnnTransform(Lop input, Types.OpOpDnn op, Types.DataType dt, Types.ValueType vt, LopProperties.ExecType et, int k, double intermediateMemBudget) {
        super(Lop.Type.Transform, dt, vt);
        this.init(input, op, dt, vt, et);
        this.numThreads = k;
        this.intermediateMemBudget = intermediateMemBudget;
    }

    public DnnTransform(Lop input1, Lop input2, Types.OpOpDnn op, Types.DataType dt, Types.ValueType vt, LopProperties.ExecType et, int k) {
        super(Lop.Type.Transform, dt, vt);
        this.init(input1, op, dt, vt, et);
        this.numThreads = k;
        this.addInput(input2);
        input2.addOutput(this);
        this.setLevel();
    }

    public DnnTransform(Lop input1, Lop input2, Lop input3, Types.OpOpDnn op, Types.DataType dt, Types.ValueType vt, LopProperties.ExecType et, int k) {
        super(Lop.Type.Transform, dt, vt);
        this.init(input1, op, dt, vt, et);
        this.numThreads = k;
        this.addInput(input2);
        input2.addOutput(this);
        this.addInput(input3);
        input3.addOutput(this);
        this.setLevel();
    }

    private void init(Lop input, Types.OpOpDnn op, Types.DataType dt, Types.ValueType vt, LopProperties.ExecType et) {
        this.operation = op;
        this.addInput(input);
        input.addOutput(this);
        this.lps.setProperties(this.inputs, et);
    }

    public void updateLopProperties() {
        this.lps.setLevel(this.inputs);
    }

    @Override
    public String toString() {
        return " Operation: " + (Object)((Object)this.operation);
    }

    public Types.OpOpDnn getOp() {
        return this.operation;
    }

    private String getOpcode() {
        switch (this.operation) {
            case MAX_POOL: {
                return "maxpooling";
            }
            case RELU_MAX_POOL: {
                return "relu_maxpooling";
            }
            case RELU_MAX_POOL_BACKWARD: {
                return "relu_maxpooling_backward";
            }
            case RELU_BACKWARD: {
                return "relu_backward";
            }
            case MAX_POOL_BACKWARD: {
                return "maxpooling_backward";
            }
            case AVG_POOL: {
                return "avgpooling";
            }
            case AVG_POOL_BACKWARD: {
                return "avgpooling_backward";
            }
            case CONV2D: {
                return "conv2d";
            }
            case CONV2D_BIAS_ADD: {
                return "conv2d_bias_add";
            }
            case BIASADD: {
                return "bias_add";
            }
            case BIASMULT: {
                return "bias_multiply";
            }
            case CONV2D_BACKWARD_FILTER: {
                return "conv2d_backward_filter";
            }
            case CONV2D_BACKWARD_DATA: {
                return "conv2d_backward_data";
            }
            case CHANNEL_SUMS: {
                return "channel_sums";
            }
            case UPDATE_NESTEROV_X: {
                return "update_nesterov_x";
            }
            case BATCH_NORM2D_TEST: {
                return "batch_norm2d_test";
            }
        }
        throw new UnsupportedOperationException(this.printErrorLocation() + "Instruction is not defined for Transform operation " + (Object)((Object)this.operation));
    }

    @Override
    public String getInstructions(String input, String bias, String output) {
        if (this.operation == Types.OpOpDnn.BIASADD || this.operation == Types.OpOpDnn.BIASMULT || this.operation == Types.OpOpDnn.RELU_BACKWARD) {
            StringBuilder sb = new StringBuilder();
            sb.append((Object)this.getExecType());
            sb.append("\u00b0");
            sb.append(this.getOpcode());
            sb.append("\u00b0");
            sb.append(this.getInputs().get(0).prepInputOperand(input));
            sb.append("\u00b0");
            sb.append(this.getInputs().get(0).prepInputOperand(bias));
            sb.append("\u00b0");
            sb.append(this.prepOutputOperand(output));
            if (this.getExecType() == LopProperties.ExecType.CP) {
                sb.append("\u00b0");
                sb.append(this.numThreads);
            }
            sb.append("\u00b0");
            sb.append(this.intermediateMemBudget);
            return sb.toString();
        }
        throw new LopsException("The operation is not supported with two operands:" + this.operation.name());
    }

    @Override
    public String getInstructions(String input, String C, String HW, String output) {
        if (this.operation != Types.OpOpDnn.CHANNEL_SUMS) {
            throw new LopsException("The operation is not supported with three operands:" + this.operation.name());
        }
        return InstructionUtils.concatOperands(this.getExecType().name(), this.getOpcode(), this.getInputs().get(0).prepInputOperand(input), this.getInputs().get(1).prepInputOperand(C), this.getInputs().get(2).prepInputOperand(HW), this.prepOutputOperand(output));
    }

    @Override
    public String getInstructions(String input1, String input2, String input3, String input4, String output) {
        if (this.operation != Types.OpOpDnn.UPDATE_NESTEROV_X) {
            throw new LopsException("The operation is not supported with three operands:" + this.operation.name());
        }
        return InstructionUtils.concatOperands(this.getExecType().name(), this.getOpcode(), this.getInputs().get(0).prepInputOperand(input1), this.getInputs().get(1).prepInputOperand(input2), this.getInputs().get(2).prepInputOperand(input3), this.getInputs().get(3).prepInputOperand(input4), this.prepOutputOperand(output));
    }

    @Override
    public String getInstructions(String[] inputs, String output) {
        StringBuilder sb = new StringBuilder();
        this.appendOpcode(sb);
        for (int i = 0; i < inputs.length - 12; ++i) {
            if (i > 0) {
                sb.append("\u00b0");
            }
            sb.append(this.getInputs().get(i).prepInputOperand(inputs[i]));
        }
        this.appendOperands(inputs.length - 12, inputs.length, output, sb);
        return sb.toString();
    }

    @Override
    public String getInstructions(String input1, String input2, String input3, String input4, String input5, String input6, String output) {
        if (this.operation != Types.OpOpDnn.BATCH_NORM2D_TEST) {
            throw new LopsException("The operation is not supported with six operands:" + this.operation.name());
        }
        return InstructionUtils.concatOperands(this.getExecType().name(), this.getOpcode(), this.getInputs().get(0).prepInputOperand(input1), this.getInputs().get(1).prepInputOperand(input2), this.getInputs().get(2).prepInputOperand(input3), this.getInputs().get(3).prepInputOperand(input4), this.getInputs().get(4).prepInputOperand(input5), this.getInputs().get(5).prepInputOperand(input6), this.prepOutputOperand(output));
    }

    public void appendOpcode(StringBuilder sb) {
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(this.getOpcode());
        sb.append("\u00b0");
    }

    public void appendOperands(int startInputIndex, int endInputIndex, String output, StringBuilder sb) {
        for (int i = startInputIndex; i < endInputIndex; ++i) {
            Lop ltmp = this.getInputs().get(i);
            sb.append("\u00b0");
            sb.append(ltmp.prepScalarInputOperand(this.getExecType()));
        }
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        if (this.getExecType() == LopProperties.ExecType.CP) {
            sb.append("\u00b0");
            sb.append(this.numThreads);
        }
        sb.append("\u00b0");
        sb.append(this.intermediateMemBudget);
    }
}

