/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import java.io.Closeable;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.apache.sysml.runtime.io.IOUtilFunctions;

public class UnPaddedOutputFormat<K extends Writable, V extends Writable>
extends FileOutputFormat<K, V> {
    public RecordWriter<K, V> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        Path file = FileOutputFormat.getTaskOutputPath((JobConf)job, (String)name);
        FileSystem fs = file.getFileSystem((Configuration)job);
        FSDataOutputStream fileOut = fs.create(file, true, job.getInt("io.file.buffer.size", 4096), progress);
        return new UnpaddedRecordWriter(fileOut);
    }

    public static class UnpaddedRecordWriter<K extends Writable, V extends Writable>
    implements RecordWriter<K, V> {
        private FSDataOutputStream out;

        public UnpaddedRecordWriter(FSDataOutputStream fstream) {
            this.out = fstream;
        }

        public void close(Reporter report) throws IOException {
            IOUtilFunctions.closeSilently((Closeable)this.out);
        }

        public void write(K key, V value) throws IOException {
            key.write((DataOutput)this.out);
            value.write((DataOutput)this.out);
        }
    }
}

