/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.parfor;

import java.util.Collection;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.conf.CompilerConfig;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.controlprogram.parfor.LocalTaskQueue;
import org.apache.sysml.runtime.controlprogram.parfor.ParForBody;
import org.apache.sysml.runtime.controlprogram.parfor.ParWorker;
import org.apache.sysml.runtime.controlprogram.parfor.Task;
import org.apache.sysml.runtime.controlprogram.parfor.stat.Stat;
import org.apache.sysml.runtime.controlprogram.parfor.stat.StatisticMonitor;
import org.apache.sysml.runtime.controlprogram.parfor.stat.Timing;

public class LocalParWorker
extends ParWorker
implements Runnable {
    protected final LocalTaskQueue<Task> _taskQueue;
    protected final CompilerConfig _cconf;
    protected final boolean _stopped;
    protected final int _max_retry;
    protected Collection<String> _fnNames = null;

    public LocalParWorker(long ID, LocalTaskQueue<Task> q, ParForBody body, CompilerConfig cconf, int max_retry, boolean monitor) {
        super(ID, body, monitor);
        this._taskQueue = q;
        this._cconf = cconf;
        this._stopped = false;
        this._max_retry = max_retry;
    }

    public void setFunctionNames(Collection<String> fnNames) {
        this._fnNames = fnNames;
    }

    public Collection<String> getFunctionNames() {
        return this._fnNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Timing time1 = this._monitor ? new Timing(true) : null;
        int pool = -1;
        if (OptimizerUtils.isSparkExecutionMode() && SparkExecutionContext.isSparkContextCreated()) {
            SparkExecutionContext sec = (SparkExecutionContext)this._ec;
            pool = sec.setThreadLocalSchedulerPool();
        }
        if (DMLScript.USE_ACCELERATOR) {
            try {
                this._ec.getGPUContext(0).initializeThread();
            }
            catch (DMLRuntimeException e) {
                LOG.error((Object)"Error executing task because of failure in GPU backend: ", (Throwable)e);
                LOG.error((Object)"Stopping LocalParWorker.");
                return;
            }
        }
        ConfigurationManager.setLocalConfig(this._cconf);
        Task lTask = null;
        try {
            block9: while (!this._stopped) {
                block17: {
                    try {
                        lTask = this._taskQueue.dequeueTask();
                        if (lTask == LocalTaskQueue.NO_MORE_TASKS) {
                        }
                        break block17;
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)("Error reading from task queue: " + ex.getMessage()));
                        LOG.warn((Object)"Stopping LocalParWorker.");
                    }
                    break;
                }
                boolean success = false;
                int retrys = this._max_retry;
                while (!success) {
                    try {
                        this.executeTask(lTask);
                        success = true;
                    }
                    catch (Exception ex) {
                        LOG.error((Object)("Failed to execute " + lTask.toString() + ", retry:" + retrys), (Throwable)ex);
                        if (retrys > 0) {
                            --retrys;
                            continue;
                        }
                        LOG.error((Object)"Error executing task: ", (Throwable)ex);
                        LOG.error((Object)"Stopping LocalParWorker.");
                        continue block9;
                    }
                }
            }
        }
        finally {
            if (OptimizerUtils.isSparkExecutionMode() && pool != -1) {
                SparkExecutionContext sec = (SparkExecutionContext)this._ec;
                sec.cleanupThreadLocalSchedulerPool(pool);
            }
        }
        if (this._monitor) {
            StatisticMonitor.putPWStat(this._workerID, Stat.PARWRK_NUMTASKS, this._numTasks);
            StatisticMonitor.putPWStat(this._workerID, Stat.PARWRK_NUMITERS, this._numIters);
            StatisticMonitor.putPWStat(this._workerID, Stat.PARWRK_EXEC_T, time1.stop());
        }
    }
}

