/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.mapred;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.runtime.instructions.mr.CSVWriteInstruction;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.Pair;
import org.apache.sysml.runtime.matrix.data.TaggedFirstSecondIndexes;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;
import org.apache.sysml.runtime.matrix.mapred.MapperBase;

public class CSVWriteMapper
extends MapperBase
implements Mapper<Writable, Writable, TaggedFirstSecondIndexes, MatrixBlock> {
    HashMap<Byte, ArrayList<Byte>> inputOutputMap = new HashMap();
    TaggedFirstSecondIndexes outIndexes = new TaggedFirstSecondIndexes();

    public void map(Writable rawKey, Writable rawValue, OutputCollector<TaggedFirstSecondIndexes, MatrixBlock> out, Reporter reporter) throws IOException {
        long start = System.currentTimeMillis();
        for (int i = 0; i < this.representativeMatrixes.size(); ++i) {
            this.inputConverter.setBlockSize(this.brlens[i], this.bclens[i]);
            this.inputConverter.convert(rawKey, rawValue);
            byte thisMatrix = (Byte)this.representativeMatrixes.get(i);
            while (this.inputConverter.hasNext()) {
                Pair pair = this.inputConverter.next();
                MatrixIndexes indexes = (MatrixIndexes)pair.getKey();
                MatrixBlock value = (MatrixBlock)pair.getValue();
                this.outIndexes.setIndexes(indexes.getRowIndex(), indexes.getColumnIndex());
                ArrayList<Byte> outputs = this.inputOutputMap.get(thisMatrix);
                for (byte output : outputs) {
                    this.outIndexes.setTag(output);
                    out.collect((Object)this.outIndexes, (Object)value);
                }
            }
        }
        reporter.incrCounter((Enum)MapperBase.Counters.MAP_TIME, System.currentTimeMillis() - start);
    }

    @Override
    public void configure(JobConf job) {
        super.configure(job);
        try {
            CSVWriteInstruction[] ins;
            for (CSVWriteInstruction in : ins = MRJobConfiguration.getCSVWriteInstructions(job)) {
                ArrayList<Byte> outputs = this.inputOutputMap.get(in.input);
                if (outputs == null) {
                    outputs = new ArrayList();
                    this.inputOutputMap.put(in.input, outputs);
                }
                outputs.add(in.output);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void specialOperationsForActualMap(int index, OutputCollector<Writable, Writable> out, Reporter reporter) throws IOException {
    }
}

