/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.Unary;
import org.apache.sysml.lops.WeightedUnaryMM;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class WeightedUnaryMMR
extends Lop {
    public static final String OPCODE = "redwumm";
    private WeightedUnaryMM.WUMMType _wummType = null;
    private Unary.OperationTypes _uop = null;
    private boolean _cacheU = false;
    private boolean _cacheV = false;

    public WeightedUnaryMMR(Lop input1, Lop input2, Lop input3, Expression.DataType dt, Expression.ValueType vt, WeightedUnaryMM.WUMMType wt, Unary.OperationTypes op, boolean cacheU, boolean cacheV, LopProperties.ExecType et) {
        super(Lop.Type.WeightedUMM, dt, vt);
        this.addInput(input1);
        this.addInput(input2);
        this.addInput(input3);
        input1.addOutput(this);
        input2.addOutput(this);
        input3.addOutput(this);
        this._wummType = wt;
        this._uop = op;
        this._cacheU = cacheU;
        this._cacheV = cacheV;
        this.setupLopProperties(et);
    }

    private void setupLopProperties(LopProperties.ExecType et) {
        if (et == LopProperties.ExecType.MR) {
            boolean breaksAlignment = true;
            boolean aligner = false;
            boolean definesMRJob = false;
            this.lps.addCompatibility(JobType.GMR);
            this.lps.addCompatibility(JobType.DATAGEN);
            this.lps.setProperties(this.inputs, LopProperties.ExecType.MR, LopProperties.ExecLocation.Reduce, breaksAlignment, aligner, definesMRJob);
        } else {
            boolean breaksAlignment = false;
            boolean aligner = false;
            boolean definesMRJob = false;
            this.lps.addCompatibility(JobType.INVALID);
            this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.ControlProgram, breaksAlignment, aligner, definesMRJob);
        }
    }

    @Override
    public String toString() {
        return "Operation = WeightedUMMR";
    }

    @Override
    public String getInstructions(int input1, int input2, int input3, int output) {
        return this.getInstructions(String.valueOf(input1), String.valueOf(input2), String.valueOf(input3), String.valueOf(output));
    }

    @Override
    public String getInstructions(String input1, String input2, String input3, String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(OPCODE);
        sb.append("\u00b0");
        sb.append(Unary.getOpcode(this._uop));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(1).prepInputOperand(input2));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(2).prepInputOperand(input3));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        sb.append("\u00b0");
        sb.append((Object)this._wummType);
        sb.append("\u00b0");
        sb.append(this._cacheU);
        sb.append("\u00b0");
        sb.append(this._cacheV);
        return sb.toString();
    }

    @Override
    public boolean usesDistributedCache() {
        return this._cacheU || this._cacheV;
    }

    @Override
    public int[] distributedCacheInputIndex() {
        if (!this._cacheU && !this._cacheV) {
            return new int[]{-1};
        }
        if (this._cacheU && !this._cacheV) {
            return new int[]{2};
        }
        if (!this._cacheU && this._cacheV) {
            return new int[]{3};
        }
        return new int[]{2, 3};
    }
}

