/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.runtime.controlprogram.caching.CacheableData;
import org.apache.sysml.runtime.controlprogram.parfor.util.IDSequence;
import org.apache.sysml.runtime.instructions.cp.Data;
import org.apache.sysml.runtime.instructions.cp.ListObject;
import org.apache.sysml.runtime.util.ProgramConverter;
import org.apache.sysml.utils.Statistics;

public class LocalVariableMap
implements Cloneable {
    private static final String eol = System.getProperty("line.separator");
    private static final String ELEMENT_DELIM = "\u236a";
    private static final IDSequence _seq = new IDSequence();
    private final HashMap<String, Data> localMap;
    private final long localID;
    private HashSet<String> outputs = null;

    public LocalVariableMap() {
        this.localMap = new HashMap();
        this.localID = _seq.getNextID();
    }

    public LocalVariableMap(LocalVariableMap vars) {
        this.localMap = new HashMap<String, Data>(vars.localMap);
        this.localID = _seq.getNextID();
    }

    public Set<String> keySet() {
        return this.localMap.keySet();
    }

    public Set<Map.Entry<String, Data>> entrySet() {
        return this.localMap.entrySet();
    }

    public Data get(String name) {
        return this.localMap.get(name);
    }

    public void put(String name, Data val) {
        this.localMap.put(name, val);
    }

    public void putAll(Map<String, Data> vals) {
        this.localMap.putAll(vals);
    }

    public Data remove(String name) {
        return this.localMap.remove(name);
    }

    public void removeAll() {
        this.localMap.clear();
    }

    public void removeAllIn(Set<String> blacklist) {
        this.localMap.entrySet().removeIf(e -> blacklist.contains(e.getKey()));
    }

    public void removeAllNotIn(Set<String> blacklist) {
        this.localMap.entrySet().removeIf(e -> !blacklist.contains(e.getKey()));
    }

    public boolean hasReferences(Data d) {
        return this.localMap.values().stream().anyMatch(e -> e instanceof ListObject ? ((ListObject)e).getData().contains(d) : e == d);
    }

    public void setRegisteredOutputs(HashSet<String> outputs) {
        this.outputs = outputs;
    }

    public HashSet<String> getRegisteredOutputs() {
        return this.outputs;
    }

    public double getPinnedDataSize() {
        HashMap<Integer, Data> dict = new HashMap<Integer, Data>();
        double total = 0.0;
        for (Map.Entry<String, Data> e : this.localMap.entrySet()) {
            int hash = System.identityHashCode(e.getValue());
            if (dict.containsKey(hash) || !(e.getValue() instanceof CacheableData)) continue;
            dict.put(hash, e.getValue());
            double size = ((CacheableData)e.getValue()).getDataSize();
            if (DMLScript.JMLC_MEM_STATISTICS && DMLScript.FINEGRAINED_STATISTICS) {
                Statistics.maintainCPHeavyHittersMem(e.getKey(), size);
            }
            total += size;
        }
        return total;
    }

    public long countPinnedData() {
        return this.localMap.values().stream().filter(d -> d instanceof CacheableData).count();
    }

    public String serialize() {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (Map.Entry<String, Data> e : this.localMap.entrySet()) {
            if (count != 0) {
                sb.append(ELEMENT_DELIM);
            }
            sb.append(ProgramConverter.serializeDataObject(e.getKey(), e.getValue()));
            ++count;
        }
        return sb.toString();
    }

    public static LocalVariableMap deserialize(String varStr) {
        StringTokenizer st2 = new StringTokenizer(varStr, ELEMENT_DELIM);
        LocalVariableMap vars = new LocalVariableMap();
        while (st2.hasMoreTokens()) {
            String tmp = st2.nextToken().trim();
            Object[] tmp2 = ProgramConverter.parseDataObject(tmp);
            vars.put((String)tmp2[0], (Data)tmp2[1]);
        }
        return vars;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Local Variable Map ID = \"");
        sb.append(this.localID);
        sb.append("\":");
        sb.append(eol);
        for (Map.Entry<String, Data> pair : this.localMap.entrySet()) {
            sb.append("  ");
            sb.append(pair.getKey());
            sb.append(" = ");
            sb.append(pair.getValue());
            sb.append(eol);
        }
        return sb.toString();
    }

    public Object clone() {
        return new LocalVariableMap(this);
    }
}

