/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xqj;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom.DOMObjectModel;
import net.sf.saxon.javax.xml.xquery.XQCommonHandler;
import net.sf.saxon.javax.xml.xquery.XQDataFactory;
import net.sf.saxon.javax.xml.xquery.XQException;
import net.sf.saxon.javax.xml.xquery.XQItem;
import net.sf.saxon.javax.xml.xquery.XQItemType;
import net.sf.saxon.javax.xml.xquery.XQSequence;
import net.sf.saxon.javax.xml.xquery.XQSequenceType;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.sort.IntToIntHashMap;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.QualifiedNameValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xqj.SaxonXQForwardSequence;
import net.sf.saxon.xqj.SaxonXQItem;
import net.sf.saxon.xqj.SaxonXQItemType;
import net.sf.saxon.xqj.SaxonXQSequence;
import net.sf.saxon.xqj.SaxonXQSequenceType;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public abstract class SaxonXQDataFactory
implements XQDataFactory {
    private static IntToIntHashMap XQJtoSaxonTypeTranslation = new IntToIntHashMap(80);
    private static IntToIntHashMap SaxonToXQJTypeTranslation = new IntToIntHashMap(80);

    abstract Configuration getConfiguration();

    abstract XQCommonHandler getCommonHandler();

    private static void map(int n, int n2) {
        XQJtoSaxonTypeTranslation.put(n, n2);
        SaxonToXQJTypeTranslation.put(n2, n);
    }

    static int mapSaxonTypeToXQJ(int n) {
        return SaxonToXQJTypeTranslation.get(n);
    }

    public XQItemType createAtomicItemType(int n) throws XQException {
        int n2 = XQJtoSaxonTypeTranslation.get(n);
        if (n2 == XQJtoSaxonTypeTranslation.getDefaultValue()) {
            throw new XQException("Unknown base type " + n);
        }
        SchemaType schemaType = BuiltInType.getSchemaType((int)n2);
        if (schemaType instanceof AtomicType) {
            return new SaxonXQItemType((ItemType)((AtomicType)schemaType), this.getConfiguration());
        }
        throw new XQException("baseType " + n + " is not atomic");
    }

    public XQItem createItem(XQItem xQItem) {
        return new SaxonXQItem(((SaxonXQItem)xQItem).getItem(), ((SaxonXQItem)xQItem).getConfiguration());
    }

    public XQItem createItemFromAtomicValue(String string, XQItemType xQItemType) throws XQException {
        if (string == null || xQItemType == null) {
            throw new XQException("The " + (string == null ? "value" : "type") + " argument must not be null");
        }
        AtomicType atomicType = this.testAtomic(xQItemType);
        StringValue stringValue = new StringValue((CharSequence)string);
        return new SaxonXQItem((Item)stringValue.convert(atomicType, null, true), this.getConfiguration());
    }

    public XQItem createItemFromBoolean(boolean bl, XQItemType xQItemType) throws XQException {
        if (xQItemType == null) {
            return new SaxonXQItem((Item)BooleanValue.get((boolean)bl), this.getConfiguration());
        }
        AtomicType atomicType = this.testAtomic(xQItemType);
        if (atomicType.getPrimitiveType() == 514) {
            try {
                AtomicValue atomicValue = BooleanValue.get((boolean)bl).convert(atomicType, null, true);
                return new SaxonXQItem((Item)atomicValue, this.getConfiguration());
            }
            catch (Exception exception) {
                throw new XQException("Failed to convert boolean value to required type: " + exception.getMessage());
            }
        }
        throw new XQException("Target type for a boolean must be xs:boolean or a subtype");
    }

    public XQItem createItemFromByte(byte by, XQItemType xQItemType) throws XQException {
        if (xQItemType == null) {
            try {
                return new SaxonXQItem((Item)new Int64Value((long)by, (AtomicType)BuiltInAtomicType.BYTE, false), this.getConfiguration());
            }
            catch (DynamicError dynamicError) {
                throw new XQException(dynamicError.getMessage(), (Throwable)dynamicError, null, null);
            }
        }
        return this.createItemFromLong(by, xQItemType);
    }

    public XQItem createItemFromDocument(InputSource inputSource) throws XQException, IOException {
        try {
            SAXSource sAXSource = new SAXSource(inputSource);
            DocumentInfo documentInfo = this.getConfiguration().buildDocument((Source)sAXSource);
            return new SaxonXQItem((Item)documentInfo, this.getConfiguration());
        }
        catch (XPathException xPathException) {
            throw new XQException(xPathException.getMessage(), (Throwable)xPathException, null, null);
        }
    }

    public XQItem createItemFromDouble(double d, XQItemType xQItemType) throws XQException {
        if (xQItemType == null) {
            return new SaxonXQItem((Item)new DoubleValue(d), this.getConfiguration());
        }
        AtomicType atomicType = this.testAtomic(xQItemType);
        if (atomicType.getPrimitiveType() == 517) {
            try {
                AtomicValue atomicValue = new DoubleValue(d).convert(atomicType, null, true);
                return new SaxonXQItem((Item)atomicValue, this.getConfiguration());
            }
            catch (Exception exception) {
                throw new XQException("Failed to convert double value to required type: " + exception.getMessage());
            }
        }
        throw new XQException("Target type for a double must be xs:double or a subtype");
    }

    public XQItem createItemFromFloat(float f, XQItemType xQItemType) throws XQException {
        if (xQItemType == null) {
            return new SaxonXQItem((Item)new FloatValue(f), this.getConfiguration());
        }
        AtomicType atomicType = this.testAtomic(xQItemType);
        if (atomicType.getPrimitiveType() == 517) {
            try {
                AtomicValue atomicValue = new FloatValue(f).convert(atomicType, null, true);
                return new SaxonXQItem((Item)atomicValue, this.getConfiguration());
            }
            catch (Exception exception) {
                throw new XQException("Failed to convert float value to required type: " + exception.getMessage());
            }
        }
        throw new XQException("Target type for a float must be xs:float or a subtype");
    }

    public XQItem createItemFromInt(int n, XQItemType xQItemType) throws XQException {
        if (xQItemType == null) {
            try {
                return new SaxonXQItem((Item)new Int64Value((long)n, (AtomicType)BuiltInAtomicType.INT, false), this.getConfiguration());
            }
            catch (DynamicError dynamicError) {
                throw new XQException(dynamicError.getMessage(), (Throwable)dynamicError, null, null);
            }
        }
        return this.createItemFromLong(n, xQItemType);
    }

    public XQItem createItemFromLong(long l, XQItemType xQItemType) throws XQException {
        if (xQItemType == null) {
            try {
                return new SaxonXQItem((Item)new Int64Value(l, (AtomicType)BuiltInAtomicType.LONG, false), this.getConfiguration());
            }
            catch (DynamicError dynamicError) {
                throw new XQException(dynamicError.getMessage(), (Throwable)dynamicError, null, null);
            }
        }
        AtomicType atomicType = this.testAtomic(xQItemType);
        int n = atomicType.getPrimitiveType();
        if (n == 532 || n == 515) {
            try {
                AtomicValue atomicValue = Int64Value.makeIntegerValue((long)l).convert(atomicType, null, true);
                return new SaxonXQItem((Item)atomicValue, this.getConfiguration());
            }
            catch (Exception exception) {
                throw new XQException("Failed to convert long|int|short|byte value to required type: " + exception.getMessage());
            }
        }
        throw new XQException("Target type for a long|int|short|byte must be xs:decimal or a subtype");
    }

    public XQItem createItemFromNode(Node node, XQItemType xQItemType) throws XQException {
        try {
            NodeInfo nodeInfo = new DOMObjectModel().wrapOrUnwrapNode(node, this.getConfiguration());
            return new SaxonXQItem((Item)nodeInfo, this.getConfiguration());
        }
        catch (XPathException xPathException) {
            throw new XQException("Failed to convert node: " + xPathException.getMessage(), (Throwable)xPathException, null, null);
        }
    }

    public XQItem createItemFromObject(Object object, XQItemType xQItemType) throws XQException {
        if (xQItemType == null) {
            return this.getCommonHandler().fromObject(object);
        }
        return this.convertToXQItem(object, xQItemType);
    }

    private XQItem convertToXQItem(Object object, XQItemType xQItemType) throws XQException {
        if (object instanceof Boolean) {
            return this.createItemFromBoolean((Boolean)object, xQItemType);
        }
        if (object instanceof byte[]) {
            AtomicValue atomicValue;
            AtomicType atomicType = this.testAtomic(xQItemType);
            int n = atomicType.getPrimitiveType();
            if (n == 527) {
                atomicValue = new HexBinaryValue((byte[])object).convert(atomicType, null, true);
            } else if (n == 528) {
                atomicValue = new Base64BinaryValue((byte[])object).convert(atomicType, null, true);
            } else {
                throw new XQException("Target type must be xs:hexBinary, xs:base64Binary, or a subtype");
            }
            return new SaxonXQItem((Item)atomicValue, this.getConfiguration());
        }
        if (object instanceof Byte) {
            return this.createItemFromByte((Byte)object, xQItemType);
        }
        if (object instanceof Float) {
            return this.createItemFromFloat(((Float)object).floatValue(), xQItemType);
        }
        if (object instanceof Double) {
            return this.createItemFromDouble((Double)object, xQItemType);
        }
        if (object instanceof Integer) {
            return this.createItemFromInt((Integer)object, xQItemType);
        }
        if (object instanceof Long) {
            return this.createItemFromLong((Long)object, xQItemType);
        }
        if (object instanceof Short) {
            return this.createItemFromShort((Short)object, xQItemType);
        }
        if (object instanceof String) {
            UntypedAtomicValue untypedAtomicValue;
            AtomicType atomicType = this.testAtomic(xQItemType);
            int n = atomicType.getPrimitiveType();
            if (n == 631) {
                untypedAtomicValue = new UntypedAtomicValue((CharSequence)((String)object));
            } else if (n == 513) {
                untypedAtomicValue = new StringValue((CharSequence)((String)object)).convert(atomicType, null, true);
            } else if (n == 529) {
                untypedAtomicValue = new AnyURIValue((CharSequence)((String)object)).convert(atomicType, null, true);
            } else {
                throw new XQException("Target type must be string, untypedAtomic, or anyURI");
            }
            return new SaxonXQItem((Item)untypedAtomicValue, this.getConfiguration());
        }
        if (object instanceof BigDecimal) {
            AtomicType atomicType = this.testAtomic(xQItemType);
            int n = atomicType.getPrimitiveType();
            if (n == 515 || n == 532) {
                AtomicValue atomicValue = new DecimalValue((BigDecimal)object).convert(atomicType, null, true);
                return new SaxonXQItem((Item)atomicValue, this.getConfiguration());
            }
            throw new XQException("Target type must be xs:decimal or a subtype");
        }
        if (object instanceof BigInteger) {
            AtomicType atomicType = this.testAtomic(xQItemType);
            int n = atomicType.getPrimitiveType();
            if (n == 515 || n == 532) {
                AtomicValue atomicValue = new DecimalValue(new BigDecimal((BigInteger)object)).convert(atomicType, null, true);
                return new SaxonXQItem((Item)atomicValue, this.getConfiguration());
            }
            throw new XQException("Target type must be xs:decimal or a subtype");
        }
        if (object instanceof Duration) {
            AtomicType atomicType = this.testAtomic(xQItemType);
            int n = atomicType.getPrimitiveType();
            if (n == 518 || n == 634 || n == 633) {
                DurationValue durationValue = (DurationValue)this.getCommonHandler().fromObject(object);
                return new SaxonXQItem((Item)durationValue.convert(atomicType, null, true), this.getConfiguration());
            }
            throw new XQException("Target type must be xs:duration or a subtype");
        }
        if (object instanceof XMLGregorianCalendar) {
            AtomicType atomicType = this.testAtomic(xQItemType);
            int n = atomicType.getPrimitiveType();
            switch (n) {
                case 519: 
                case 520: 
                case 521: 
                case 522: 
                case 523: 
                case 524: 
                case 525: 
                case 526: {
                    AtomicValue atomicValue = (AtomicValue)this.getCommonHandler().fromObject(object);
                    return new SaxonXQItem((Item)atomicValue.convert(atomicType, null, true), this.getConfiguration());
                }
            }
            throw new XQException("Target type must be a date/time type");
        }
        if (object instanceof QName) {
            AtomicType atomicType = this.testAtomic(xQItemType);
            int n = atomicType.getPrimitiveType();
            if (n == 530) {
                QualifiedNameValue qualifiedNameValue = (QualifiedNameValue)this.getCommonHandler().fromObject(object);
                return new SaxonXQItem((Item)qualifiedNameValue.convert(atomicType, null, true), this.getConfiguration());
            }
            throw new XQException("Target type must be xs:QName or a subtype");
        }
        if (object instanceof Node) {
            NodeInfo nodeInfo = (NodeInfo)this.getCommonHandler().fromObject(object);
            return new SaxonXQItem((Item)nodeInfo, this.getConfiguration());
        }
        throw new XQException("Java object cannot be converted to an XQuery value");
    }

    public XQItem createItemFromShort(short s, XQItemType xQItemType) throws XQException {
        if (xQItemType == null) {
            try {
                return new SaxonXQItem((Item)new Int64Value((long)s, (AtomicType)BuiltInAtomicType.SHORT, false), this.getConfiguration());
            }
            catch (DynamicError dynamicError) {
                throw new XQException(dynamicError.getMessage(), (Throwable)dynamicError, null, null);
            }
        }
        return this.createItemFromLong(s, xQItemType);
    }

    public XQItemType createItemType(int n, int n2, QName qName) throws XQException {
        return this.createItemType(n, n2, qName, null, null, false);
    }

    public XQItemType createItemType(int n, int n2, QName qName, QName qName2, URI uRI, boolean bl) throws XQException {
        Configuration configuration = this.getConfiguration();
        switch (n) {
            case 7: {
                return new SaxonXQItemType((ItemType)AnyItemType.getInstance(), configuration);
            }
            case 1: {
                if (qName2 == null) {
                    int n3 = XQJtoSaxonTypeTranslation.get(n2);
                    SchemaType schemaType = BuiltInType.getSchemaType((int)n3);
                    if (schemaType instanceof AtomicType) {
                        return new SaxonXQItemType((ItemType)((AtomicType)schemaType), configuration);
                    }
                    throw new XQException("itemkind is atomic, but basetype is not");
                }
                NamePool namePool = configuration.getNamePool();
                int n4 = namePool.allocate(qName2.getPrefix(), qName2.getNamespaceURI(), qName2.getLocalPart());
                SchemaType schemaType = configuration.getSchemaType(n4 & 0xFFFFF);
                if (schemaType instanceof AtomicType) {
                    return new SaxonXQItemType((ItemType)((AtomicType)schemaType), configuration);
                }
                throw new XQException("Type " + qName2 + " is not a known atomic type");
            }
            case 8: {
                return new SaxonXQItemType((ItemType)AnyNodeTest.getInstance(), configuration);
            }
            case 4: {
                return new SaxonXQItemType((ItemType)NodeKindTest.DOCUMENT, configuration);
            }
            case 3: {
                return new SaxonXQItemType((ItemType)NodeKindTest.COMMENT, configuration);
            }
            case 9: {
                return new SaxonXQItemType((ItemType)NodeKindTest.PROCESSING_INSTRUCTION, configuration);
            }
            case 10: {
                return new SaxonXQItemType((ItemType)NodeKindTest.TEXT, configuration);
            }
            case 5: 
            case 6: {
                NodeKindTest nodeKindTest;
                if (qName == null) {
                    nodeKindTest = NodeKindTest.ELEMENT;
                } else if (qName2 == null) {
                    NamePool namePool = configuration.getNamePool();
                    int n5 = namePool.allocate(qName.getPrefix(), qName.getNamespaceURI(), qName.getLocalPart());
                    nodeKindTest = new NameTest(1, n5, namePool);
                } else {
                    int n6;
                    SchemaType schemaType;
                    NamePool namePool = configuration.getNamePool();
                    int n7 = -1;
                    if (qName != null) {
                        n7 = namePool.allocate(qName.getPrefix(), qName.getNamespaceURI(), qName.getLocalPart());
                    }
                    if ((schemaType = configuration.getSchemaType((n6 = namePool.allocate(qName2.getPrefix(), qName2.getNamespaceURI(), qName2.getLocalPart())) & 0xFFFFF)) == null) {
                        throw new XQException("Unknown schema type " + qName2);
                    }
                    ContentTypeTest contentTypeTest = new ContentTypeTest(1, schemaType, configuration);
                    contentTypeTest.setNillable(bl);
                    NameTest nameTest = new NameTest(1, n7, namePool);
                    nodeKindTest = new CombinedNodeTest((NodeTest)nameTest, 23, (NodeTest)contentTypeTest);
                }
                if (n == 6) {
                    return new SaxonXQItemType((ItemType)nodeKindTest, configuration);
                }
                return new SaxonXQItemType((ItemType)new DocumentNodeTest((NodeTest)nodeKindTest), configuration);
            }
            case 2: {
                int n8;
                SchemaType schemaType;
                if (qName == null) {
                    return new SaxonXQItemType((ItemType)NodeKindTest.ATTRIBUTE, configuration);
                }
                if (qName2 == null) {
                    NamePool namePool = configuration.getNamePool();
                    int n9 = namePool.allocate(qName.getPrefix(), qName.getNamespaceURI(), qName.getLocalPart());
                    return new SaxonXQItemType((ItemType)new NameTest(2, n9, namePool), configuration);
                }
                NamePool namePool = configuration.getNamePool();
                int n10 = -1;
                if (qName != null) {
                    n10 = namePool.allocate(qName.getPrefix(), qName.getNamespaceURI(), qName.getLocalPart());
                }
                if ((schemaType = configuration.getSchemaType((n8 = namePool.allocate(qName2.getPrefix(), qName2.getNamespaceURI(), qName2.getLocalPart())) & 0xFFFFF)) == null) {
                    throw new XQException("Unknown schema type " + qName2);
                }
                ContentTypeTest contentTypeTest = new ContentTypeTest(2, schemaType, configuration);
                if (bl) {
                    throw new XQException("An attribute test cannot be nillable");
                }
                contentTypeTest.setNillable(false);
                NameTest nameTest = new NameTest(2, n10, namePool);
                CombinedNodeTest combinedNodeTest = new CombinedNodeTest((NodeTest)nameTest, 23, (NodeTest)contentTypeTest);
                return new SaxonXQItemType((ItemType)combinedNodeTest, configuration);
            }
        }
        throw new XQException("Unknown itemkind " + n);
    }

    public XQSequence createSequence(Iterator iterator) throws XQException {
        Object object;
        ArrayList<Item> arrayList = new ArrayList<Item>(50);
        while (iterator.hasNext()) {
            object = iterator.next();
            XQItem xQItem = this.createItemFromObject(object, null);
            arrayList.add(((SaxonXQItem)xQItem).getItem());
        }
        object = new SequenceExtent(arrayList);
        return new SaxonXQSequence((Value)object, this.getConfiguration());
    }

    public XQSequence createSequence(XQSequence xQSequence) throws XQException {
        if (xQSequence instanceof SaxonXQSequence) {
            return new SaxonXQSequence(((SaxonXQSequence)xQSequence).getValue(), this.getConfiguration());
        }
        if (xQSequence instanceof SaxonXQForwardSequence) {
            try {
                Value value = Value.asValue((ValueRepresentation)SequenceExtent.makeSequenceExtent((SequenceIterator)((SaxonXQForwardSequence)xQSequence).getCleanIterator()));
                return new SaxonXQSequence(value, this.getConfiguration());
            }
            catch (XPathException xPathException) {
                throw new XQException(xPathException.getMessage(), (Throwable)xPathException, null, null);
            }
        }
        throw new XQException("Supplied sequence is not a Saxon implementation");
    }

    public XQSequenceType createSequenceType(XQItemType xQItemType, int n) throws XQException {
        if (xQItemType instanceof SaxonXQItemType) {
            int n2;
            ItemType itemType = ((SaxonXQItemType)xQItemType).getSaxonItemType();
            switch (n) {
                case 2: {
                    n2 = 16384;
                    break;
                }
                case 4: {
                    n2 = 49152;
                    break;
                }
                case 1: {
                    n2 = 24576;
                    break;
                }
                case 3: {
                    n2 = 57344;
                    break;
                }
                default: {
                    throw new XQException("Invalid occurrence value");
                }
            }
            SequenceType sequenceType = SequenceType.makeSequenceType((ItemType)itemType, (int)n2);
            return new SaxonXQSequenceType(sequenceType, this.getConfiguration());
        }
        throw new XQException("Supplied XQItemType is not a Saxon-created object");
    }

    private AtomicType testAtomic(XQItemType xQItemType) throws XQException {
        if (xQItemType instanceof SaxonXQItemType) {
            AtomicType atomicType = ((SaxonXQItemType)xQItemType).getAtomicType();
            if (atomicType == null) {
                throw new XQException("Requested type is not atomic");
            }
            return atomicType;
        }
        throw new XQException("Supplied XQItemType is not a Saxon-created object");
    }

    static {
        SaxonXQDataFactory.map(4, 573);
        SaxonXQDataFactory.map(3, 572);
        SaxonXQDataFactory.map(9, 529);
        SaxonXQDataFactory.map(10, 528);
        SaxonXQDataFactory.map(11, 514);
        SaxonXQDataFactory.map(32, 538);
        SaxonXQDataFactory.map(12, 521);
        SaxonXQDataFactory.map(17, 519);
        SaxonXQDataFactory.map(18, 515);
        SaxonXQDataFactory.map(19, 517);
        SaxonXQDataFactory.map(20, 518);
        SaxonXQDataFactory.map(51, 564);
        SaxonXQDataFactory.map(49, 563);
        SaxonXQDataFactory.map(21, 516);
        SaxonXQDataFactory.map(22, 525);
        SaxonXQDataFactory.map(23, 526);
        SaxonXQDataFactory.map(24, 524);
        SaxonXQDataFactory.map(25, 523);
        SaxonXQDataFactory.map(26, 522);
        SaxonXQDataFactory.map(27, 527);
        SaxonXQDataFactory.map(47, 560);
        SaxonXQDataFactory.map(48, 561);
        SaxonXQDataFactory.map(50, 562);
        SaxonXQDataFactory.map(13, 536);
        SaxonXQDataFactory.map(14, 532);
        SaxonXQDataFactory.map(43, 555);
        SaxonXQDataFactory.map(16, 535);
        SaxonXQDataFactory.map(44, 558);
        SaxonXQDataFactory.map(45, 559);
        SaxonXQDataFactory.map(35, 534);
        SaxonXQDataFactory.map(46, 556);
        SaxonXQDataFactory.map(52, 557);
        SaxonXQDataFactory.map(34, 539);
        SaxonXQDataFactory.map(33, 533);
        SaxonXQDataFactory.map(41, 553);
        SaxonXQDataFactory.map(28, 531);
        SaxonXQDataFactory.map(36, 540);
        SaxonXQDataFactory.map(29, 530);
        SaxonXQDataFactory.map(15, 537);
        SaxonXQDataFactory.map(30, 513);
        SaxonXQDataFactory.map(31, 520);
        SaxonXQDataFactory.map(42, 554);
        SaxonXQDataFactory.map(40, 544);
        SaxonXQDataFactory.map(38, 542);
        SaxonXQDataFactory.map(37, 541);
        SaxonXQDataFactory.map(39, 543);
        SaxonXQDataFactory.map(5, 632);
        SaxonXQDataFactory.map(8, 634);
        SaxonXQDataFactory.map(1, 630);
        SaxonXQDataFactory.map(6, 631);
        SaxonXQDataFactory.map(8, 633);
    }
}

