/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.securevault.secret;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.securevault.SecretResolver;
import org.apache.synapse.securevault.SecretResolverFactory;
import org.apache.synapse.securevault.commons.MiscellaneousUtil;
import org.apache.synapse.securevault.secret.SecretCallbackHandlerFactory;
import org.apache.synapse.securevault.secret.SecretInformation;

public class SecretInformationFactory {
    private static final Log log = LogFactory.getLog(SecretInformationFactory.class);

    private SecretInformationFactory() {
    }

    public static SecretInformation createSecretInformation(Properties properties, String configurationPrefix, String passwordPrompt) {
        String password;
        SecretInformation secretInformation = new SecretInformation();
        String user = MiscellaneousUtil.getProperty(properties, configurationPrefix + "username", null, String.class);
        if (user != null && !"".equals(user)) {
            secretInformation.setUser(user);
        }
        if ((password = MiscellaneousUtil.getProperty(properties, configurationPrefix + "password", null, String.class)) != null && !"".equals(password)) {
            secretInformation.setAliasSecret(password);
        }
        SecretResolver secretResolver = SecretResolverFactory.create(properties, configurationPrefix);
        secretInformation.setLocalSecretResolver(secretResolver);
        secretInformation.setSecretPrompt(passwordPrompt);
        return secretInformation;
    }

    public static SecretInformation createSecretInformation(String secretProvider, String aliasPassword, String passwordPrompt) {
        SecretInformation secretInformation = new SecretInformation();
        secretInformation.setAliasSecret(aliasPassword);
        SecretResolver secretResolver = new SecretResolver();
        secretResolver.init(SecretCallbackHandlerFactory.createSecretCallbackHandler(secretProvider));
        secretInformation.setLocalSecretResolver(secretResolver);
        secretInformation.setSecretPrompt(passwordPrompt);
        return secretInformation;
    }
}

