/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.vfs;

import java.util.Hashtable;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.base.BaseUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VFSOutTransportInfo
implements OutTransportInfo {
    private static final Log log = LogFactory.getLog(VFSOutTransportInfo.class);
    private String outFileURI = null;
    private String outFileName = null;
    private String contentType = null;
    private int maxRetryCount = 3;
    private long reconnectTimeout = 30000L;
    private boolean append;
    private boolean fileLocking;
    private boolean isUseTempFile = false;

    VFSOutTransportInfo(String outFileURI, boolean fileLocking) {
        this.outFileURI = outFileURI.startsWith("vfs:") ? outFileURI.substring("vfs:".length()) : outFileURI;
        Hashtable properties = BaseUtils.getEPRProperties((String)outFileURI);
        if (properties.containsKey("transport.vfs.MaxRetryCount")) {
            String strMaxRetryCount = (String)properties.get("transport.vfs.MaxRetryCount");
            this.maxRetryCount = Integer.parseInt(strMaxRetryCount);
        } else {
            this.maxRetryCount = 3;
        }
        if (properties.containsKey("transport.vfs.UseTempFile")) {
            String useTempFile = (String)properties.get("transport.vfs.UseTempFile");
            this.isUseTempFile = Boolean.valueOf(useTempFile);
        }
        if (properties.containsKey("transport.vfs.ReconnectTimeout")) {
            String strReconnectTimeout = (String)properties.get("transport.vfs.ReconnectTimeout");
            this.reconnectTimeout = Long.parseLong(strReconnectTimeout) * 1000L;
        } else {
            this.reconnectTimeout = 30000L;
        }
        if (properties.containsKey("transport.vfs.Locking")) {
            String strFileLocking = (String)properties.get("transport.vfs.Locking");
            if ("enable".equals(strFileLocking)) {
                this.fileLocking = true;
            } else if ("disable".equals(strFileLocking)) {
                this.fileLocking = false;
            }
        } else {
            this.fileLocking = fileLocking;
        }
        if (properties.containsKey("transport.vfs.Append")) {
            this.append = Boolean.parseBoolean((String)properties.get("transport.vfs.Append"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using the fileURI        : " + this.outFileURI));
            log.debug((Object)("Using the maxRetryCount  : " + this.maxRetryCount));
            log.debug((Object)("Using the reconnectionTimeout : " + this.reconnectTimeout));
            log.debug((Object)("Using the append         : " + this.append));
            log.debug((Object)("File locking             : " + (this.fileLocking ? "ON" : "OFF")));
        }
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getOutFileURI() {
        return this.outFileURI;
    }

    public String getOutFileName() {
        return this.outFileName;
    }

    public int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    public void setMaxRetryCount(int maxRetryCount) {
        this.maxRetryCount = maxRetryCount;
    }

    public long getReconnectTimeout() {
        return this.reconnectTimeout;
    }

    public boolean isUseTempFile() {
        return this.isUseTempFile;
    }

    public void setReconnectTimeout(long reconnectTimeout) {
        this.reconnectTimeout = reconnectTimeout;
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isFileLockingEnabled() {
        return this.fileLocking;
    }
}

