/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.handler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.LogicalMessage;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.handler.MEPContext;
import org.apache.axis2.jaxws.message.Block;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.databinding.JAXBBlockContext;
import org.apache.axis2.jaxws.message.factory.BlockFactory;
import org.apache.axis2.jaxws.message.factory.JAXBBlockFactory;
import org.apache.axis2.jaxws.message.factory.MessageFactory;
import org.apache.axis2.jaxws.message.factory.SourceBlockFactory;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class LogicalMessageImpl
implements LogicalMessage {
    private static final Log log = LogFactory.getLog(LogicalMessageImpl.class);
    private MEPContext mepCtx;

    protected LogicalMessageImpl(MEPContext m) {
        this.mepCtx = m;
    }

    public Source getPayload() {
        SourceBlockFactory factory = (SourceBlockFactory)FactoryRegistry.getFactory(SourceBlockFactory.class);
        Source payload = (Source)this._getPayload(null, factory);
        return payload;
    }

    public Object getPayload(JAXBContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Retreiving the message payload as a Source object");
        }
        JAXBBlockFactory factory = (JAXBBlockFactory)FactoryRegistry.getFactory(JAXBBlockFactory.class);
        JAXBBlockContext jbc = new JAXBBlockContext(context);
        Object payload = this._getPayload(jbc, factory);
        return payload;
    }

    private Object _getPayload(Object context, BlockFactory factory) {
        Object payload = null;
        try {
            Block block = this.mepCtx.getMessageObject().getBodyBlock(context, factory);
            if (block != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"A message payload was found.");
                }
                Object content = block.getBusinessObject(true);
                Payloads payloads = this.createPayloads(content);
                this._setPayload(payloads.CACHE_PAYLOAD, context, factory);
                payload = payloads.HANDLER_PAYLOAD;
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"There was no payload to be found.  Returning an empty Source object");
                }
                byte[] bytes = new byte[]{};
                payload = new StreamSource(new ByteArrayInputStream(bytes));
            }
        }
        catch (XMLStreamException e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
        return payload;
    }

    public void setPayload(Object obj, JAXBContext context) {
        JAXBBlockFactory factory = (JAXBBlockFactory)FactoryRegistry.getFactory(JAXBBlockFactory.class);
        JAXBBlockContext jbc = new JAXBBlockContext(context);
        this._setPayload(obj, jbc, factory);
    }

    public void setPayload(Source source) {
        SourceBlockFactory factory = (SourceBlockFactory)FactoryRegistry.getFactory(SourceBlockFactory.class);
        this._setPayload(source, null, factory);
    }

    private void _setPayload(Object object, Object context, BlockFactory factory) {
        Block block = factory.createFrom(object, context, null);
        if (this.mepCtx.getMessageObject() != null) {
            if (!this.mepCtx.getMessageObject().isFault()) {
                this.mepCtx.getMessageObject().setBodyBlock(block);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"The payload contains a fault");
                }
                this.mepCtx.getMessageObject().setBodyBlock(block);
                try {
                    SOAPEnvelope env = (SOAPEnvelope)this.mepCtx.getMessageObject().getAsOMElement();
                    String content = env.toStringWithConsume();
                    MessageFactory mf = (MessageFactory)FactoryRegistry.getFactory(MessageFactory.class);
                    StringReader sr = new StringReader(content);
                    XMLStreamReader stream = StAXUtils.createXMLStreamReader((Reader)sr);
                    Message msg = mf.createFrom(stream, this.mepCtx.getMessageObject().getProtocol());
                    msg.getAsOMElement().build();
                    this.mepCtx.setMessage(msg);
                }
                catch (Exception e) {
                    throw ExceptionFactory.makeWebServiceException((Throwable)e);
                }
            }
        }
    }

    private Payloads createPayloads(Object content) {
        if (content == null) {
            return null;
        }
        Payloads payloads = new Payloads();
        if (Source.class.isAssignableFrom(content.getClass())) {
            try {
                Transformer trans = TransformerFactory.newInstance().newTransformer();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                StreamResult result = new StreamResult(baos);
                Source source = (Source)content;
                trans.transform(source, result);
                trans.setOutputProperty("omit-xml-declaration", "yes");
                byte[] bytes = baos.toByteArray();
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                try {
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    dbf.setNamespaceAware(true);
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    Document dom = db.parse(bais);
                    payloads.HANDLER_PAYLOAD = new DOMSource(dom);
                }
                catch (ParserConfigurationException e) {
                    throw ExceptionFactory.makeWebServiceException((Throwable)e);
                }
                catch (IOException e) {
                    throw ExceptionFactory.makeWebServiceException((Throwable)e);
                }
                catch (SAXException e) {
                    throw ExceptionFactory.makeWebServiceException((Throwable)e);
                }
                byte[] cacheBytes = new byte[bytes.length];
                System.arraycopy(bytes, 0, cacheBytes, 0, bytes.length);
                ByteArrayInputStream cacheBais = new ByteArrayInputStream(cacheBytes);
                payloads.CACHE_PAYLOAD = new StreamSource(cacheBais);
            }
            catch (TransformerConfigurationException e) {
                throw ExceptionFactory.makeWebServiceException((Throwable)e);
            }
            catch (TransformerFactoryConfigurationError e) {
                throw ExceptionFactory.makeWebServiceException((Throwable)e);
            }
            catch (TransformerException e) {
                throw ExceptionFactory.makeWebServiceException((Throwable)e);
            }
        }
        payloads.HANDLER_PAYLOAD = content;
        payloads.CACHE_PAYLOAD = content;
        return payloads;
    }

    class Payloads {
        Object HANDLER_PAYLOAD;
        Object CACHE_PAYLOAD;

        Payloads() {
        }
    }
}

