/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.virtualization;

import java.io.IOException;
import java.util.UUID;
import net.sf.jasperreports.engine.virtualization.ObjectSerializer;
import net.sf.jasperreports.engine.virtualization.ReferenceType;
import net.sf.jasperreports.engine.virtualization.VirtualizationInput;
import net.sf.jasperreports.engine.virtualization.VirtualizationOutput;

public class UUIDSerializer
implements ObjectSerializer<UUID> {
    @Override
    public int typeValue() {
        return 17;
    }

    @Override
    public ReferenceType defaultReferenceType() {
        return ReferenceType.OBJECT;
    }

    @Override
    public boolean defaultStoreReference() {
        return true;
    }

    @Override
    public void write(UUID value, VirtualizationOutput out) throws IOException {
        out.writeLong(value.getMostSignificantBits());
        out.writeLong(value.getLeastSignificantBits());
    }

    @Override
    public UUID read(VirtualizationInput in) throws IOException {
        long mostSigBits = in.readLong();
        long leastSigBits = in.readLong();
        return new UUID(mostSigBits, leastSigBits);
    }
}

