/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.view.save;

import java.io.File;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.ooxml.JRDocxExporter;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.view.JRSaveContributor;
import net.sf.jasperreports.view.SaveContributorFactory;

public class JRDocxSaveContributor
extends JRSaveContributor {
    private static final String EXTENSION_DOCX = ".docx";

    public JRDocxSaveContributor(Locale locale, ResourceBundle resBundle) {
        super(locale, resBundle);
    }

    public JRDocxSaveContributor(JasperReportsContext jasperReportsContext, Locale locale, ResourceBundle resBundle) {
        super(jasperReportsContext, locale, resBundle);
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        return file.getName().toLowerCase().endsWith(EXTENSION_DOCX);
    }

    @Override
    public String getDescription() {
        return this.getBundleString("file.desc.docx");
    }

    @Override
    public void save(JasperPrint jasperPrint, File file) throws JRException {
        if (!file.getName().toLowerCase().endsWith(EXTENSION_DOCX)) {
            file = new File(file.getAbsolutePath() + EXTENSION_DOCX);
        }
        if (!file.exists() || 0 == JOptionPane.showConfirmDialog(null, MessageFormat.format(this.getBundleString("file.exists"), file.getName()), this.getBundleString("save"), 2)) {
            JRDocxExporter exporter = new JRDocxExporter(this.getJasperReportsContext());
            exporter.setExporterInput(new SimpleExporterInput(jasperPrint));
            exporter.setExporterOutput(new SimpleOutputStreamExporterOutput(file));
            exporter.exportReport();
        }
    }

    public static class Factory
    implements SaveContributorFactory {
        @Override
        public JRSaveContributor create(JasperReportsContext jasperReportsContext, Locale locale, ResourceBundle resBundle) {
            return new JRDocxSaveContributor(jasperReportsContext, locale, resBundle);
        }
    }
}

