/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml.print;

import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.PrintBookmark;
import net.sf.jasperreports.engine.SimplePrintPageFormat;
import net.sf.jasperreports.engine.SimplePrintPart;
import net.sf.jasperreports.engine.base.BasePrintBookmark;
import net.sf.jasperreports.engine.base.JRBasePrintPage;
import net.sf.jasperreports.engine.type.BandTypeEnum;
import net.sf.jasperreports.engine.type.OrientationEnum;
import net.sf.jasperreports.engine.xml.print.EllipseLoader;
import net.sf.jasperreports.engine.xml.print.FrameLoader;
import net.sf.jasperreports.engine.xml.print.GenericElementLoader;
import net.sf.jasperreports.engine.xml.print.ImageLoader;
import net.sf.jasperreports.engine.xml.print.LineLoader;
import net.sf.jasperreports.engine.xml.print.PropertyLoader;
import net.sf.jasperreports.engine.xml.print.RectangleLoader;
import net.sf.jasperreports.engine.xml.print.StyleLoader;
import net.sf.jasperreports.engine.xml.print.TextLoader;
import net.sf.jasperreports.engine.xml.print.XmlLoader;

public class JasperPrintLoader {
    private static final JasperPrintLoader INSTANCE = new JasperPrintLoader();

    public static JasperPrintLoader instance() {
        return INSTANCE;
    }

    public JasperPrint load(XmlLoader xmlLoader) {
        JasperPrint jasperPrint = new JasperPrint();
        xmlLoader.setAttribute("name", jasperPrint::setName);
        xmlLoader.setIntAttribute("pageWidth", jasperPrint::setPageWidth);
        xmlLoader.setIntAttribute("pageHeight", jasperPrint::setPageHeight);
        xmlLoader.setIntAttribute("topMargin", jasperPrint::setTopMargin);
        xmlLoader.setIntAttribute("leftMargin", jasperPrint::setLeftMargin);
        xmlLoader.setIntAttribute("bottomMargin", jasperPrint::setBottomMargin);
        xmlLoader.setIntAttribute("rightMargin", jasperPrint::setRightMargin);
        xmlLoader.setEnumAttribute("orientation", OrientationEnum::getByName, jasperPrint::setOrientation);
        xmlLoader.setAttribute("formatFactoryClass", jasperPrint::setFormatFactoryClass);
        xmlLoader.setAttribute("locale", jasperPrint::setLocaleCode);
        xmlLoader.setAttribute("timezone", jasperPrint::setTimeZoneId);
        xmlLoader.loadElements(element -> {
            switch (element) {
                case "property": {
                    PropertyLoader.instance().loadProperty(xmlLoader, jasperPrint);
                    break;
                }
                case "origin": {
                    JROrigin origin = this.loadOrigin(xmlLoader);
                    jasperPrint.addOrigin(origin);
                    break;
                }
                case "style": {
                    StyleLoader.instance().loadStyle(xmlLoader, jasperPrint);
                    break;
                }
                case "bookmark": {
                    PrintBookmark bookmark = this.loadBookmark(xmlLoader);
                    jasperPrint.addBookmark(bookmark);
                    break;
                }
                case "part": {
                    this.loadPart(xmlLoader, jasperPrint);
                    break;
                }
                case "page": {
                    this.loadPage(xmlLoader, jasperPrint);
                    break;
                }
                default: {
                    xmlLoader.unexpectedElement((String)element);
                }
            }
        });
        return jasperPrint;
    }

    protected JROrigin loadOrigin(XmlLoader xmlLoader) {
        String report = xmlLoader.getAttribute("report");
        String group = xmlLoader.getAttribute("group");
        BandTypeEnum bandType = xmlLoader.getEnumAttribute("band", BandTypeEnum::getByName);
        xmlLoader.endElement();
        return new JROrigin(report, group, bandType);
    }

    protected PrintBookmark loadBookmark(XmlLoader xmlLoader) {
        String label = xmlLoader.getAttribute("label");
        Integer pageIndexAttr = xmlLoader.getIntAttribute("pageIndex");
        int pageIndex = pageIndexAttr != null ? pageIndexAttr : 0;
        String elementAddress = xmlLoader.getAttribute("elementAddress");
        BasePrintBookmark bookmark = new BasePrintBookmark(label, pageIndex, elementAddress);
        xmlLoader.loadElements(element -> {
            switch (element) {
                case "bookmark": {
                    PrintBookmark subBookmark = this.loadBookmark(xmlLoader);
                    bookmark.addBookmark(subBookmark);
                    break;
                }
                default: {
                    xmlLoader.unexpectedElement((String)element);
                }
            }
        });
        return bookmark;
    }

    protected void loadPart(XmlLoader xmlLoader, JasperPrint jasperPrint) {
        SimplePrintPart part = new SimplePrintPart();
        Integer pageIndex = xmlLoader.getIntAttribute("pageIndex");
        xmlLoader.setAttribute("name", part::setName);
        SimplePrintPageFormat pageFormat = new SimplePrintPageFormat();
        xmlLoader.setIntAttribute("pageWidth", pageFormat::setPageWidth);
        xmlLoader.setIntAttribute("pageHeight", pageFormat::setPageHeight);
        xmlLoader.setIntAttribute("topMargin", pageFormat::setTopMargin);
        xmlLoader.setIntAttribute("leftMargin", pageFormat::setLeftMargin);
        xmlLoader.setIntAttribute("bottomMargin", pageFormat::setBottomMargin);
        xmlLoader.setIntAttribute("rightMargin", pageFormat::setRightMargin);
        xmlLoader.setEnumAttribute("orientation", OrientationEnum::getByName, pageFormat::setOrientation);
        part.setPageFormat(pageFormat);
        xmlLoader.loadElements(element -> {
            switch (element) {
                case "property": {
                    PropertyLoader.instance().loadProperty(xmlLoader, part);
                    break;
                }
                default: {
                    xmlLoader.unexpectedElement((String)element);
                }
            }
        });
        jasperPrint.addPart(pageIndex, part);
    }

    protected void loadPage(XmlLoader xmlLoader, JasperPrint jasperPrint) {
        JRBasePrintPage page = new JRBasePrintPage();
        xmlLoader.loadElements(element -> {
            switch (element) {
                case "line": {
                    LineLoader.instance().loadLine(xmlLoader, jasperPrint, page::addElement);
                    break;
                }
                case "rectangle": {
                    RectangleLoader.instance().loadRectangle(xmlLoader, jasperPrint, page::addElement);
                    break;
                }
                case "ellipse": {
                    EllipseLoader.instance().loadEllipse(xmlLoader, jasperPrint, page::addElement);
                    break;
                }
                case "image": {
                    ImageLoader.instance().loadImage(xmlLoader, jasperPrint, page::addElement);
                    break;
                }
                case "text": {
                    TextLoader.instance().loadText(xmlLoader, jasperPrint, page::addElement);
                    break;
                }
                case "frame": {
                    FrameLoader.instance().loadFrame(xmlLoader, jasperPrint, page::addElement);
                    break;
                }
                case "genericElement": {
                    GenericElementLoader.instance().loadGenericElement(xmlLoader, jasperPrint, page::addElement);
                    break;
                }
                default: {
                    xmlLoader.unexpectedElement((String)element);
                }
            }
        });
        jasperPrint.addPage(page);
    }
}

