/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.Writer;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.LengthUtil;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.export.ooxml.DocxBorderInfo;
import net.sf.jasperreports.engine.util.JRColorUtil;

public class DocxBorderHelper
extends BaseHelper {
    public DocxBorderHelper(JasperReportsContext jasperReportsContext, Writer writer) {
        super(jasperReportsContext, writer);
    }

    public void exportBorder(JRLineBox box) {
        if (box != null) {
            this.exportBorder(new DocxBorderInfo(box));
        }
    }

    private void exportBorder(DocxBorderInfo info) {
        if (info.hasBorder()) {
            this.write("      <w:tcBorders>\n");
            this.exportBorder(info, 0);
            this.exportBorder(info, 1);
            this.exportBorder(info, 2);
            this.exportBorder(info, 3);
            this.write("      </w:tcBorders>\n");
        }
    }

    public void exportPadding(JRLineBox box) {
        this.write("      <w:tcMar>\n");
        this.exportPadding(box.getTopPadding(), 0);
        this.exportPadding(box.getLeftPadding(), 1);
        this.exportPadding(box.getBottomPadding(), 2);
        this.exportPadding(box.getRightPadding(), 3);
        this.write("      </w:tcMar>\n");
    }

    private void exportBorder(DocxBorderInfo info, int side) {
        if (info.borderWidth[side] != null) {
            this.write("<w:" + DocxBorderInfo.BORDER[side] + " w:val=\"" + info.borderStyle[side] + "\" w:sz=\"" + info.borderWidth[side] + "\" w:space=\"0\"");
            if (info.borderColor[side] != null) {
                this.write(" w:color=\"" + JRColorUtil.getColorHexa(info.borderColor[side]) + "\"");
            }
            this.write(" />\n");
        }
    }

    private void exportPadding(Integer padding, int side) {
        if (padding != null) {
            this.write("       <w:" + DocxBorderInfo.BORDER[side] + " w:w=\"" + LengthUtil.twip(padding.intValue()) + "\" w:type=\"dxa\" />\n");
        }
    }
}

