/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.cache;

import java.sql.Timestamp;
import net.sf.jasperreports.data.cache.ColumnValuesIterator;

class TimestampValuesIterator
implements ColumnValuesIterator {
    private final ColumnValuesIterator timeIterator;
    private final ColumnValuesIterator nanoIterator;

    public TimestampValuesIterator(ColumnValuesIterator timeIterator, ColumnValuesIterator nanoIterator) {
        this.timeIterator = timeIterator;
        this.nanoIterator = nanoIterator;
    }

    @Override
    public void moveFirst() {
        this.timeIterator.moveFirst();
        this.nanoIterator.moveFirst();
    }

    @Override
    public boolean next() {
        return this.timeIterator.next() && this.nanoIterator.next();
    }

    @Override
    public Object get() {
        long time = ((Number)this.timeIterator.get()).longValue();
        int nano = ((Number)this.nanoIterator.get()).intValue();
        Timestamp timestamp = new Timestamp(time);
        timestamp.setNanos(nano);
        return timestamp;
    }
}

