/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.json;

import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.struts2.json.JSONException;

public class JSONReader {
    private static final Object OBJECT_END = new Object();
    private static final Object ARRAY_END = new Object();
    private static final Object COLON = new Object();
    private static final Object COMMA = new Object();
    private static Map<Character, Character> escapes = new HashMap<Character, Character>();
    private CharacterIterator it;
    private char c;
    private Object token;
    private StringBuilder buf = new StringBuilder();

    protected char next() {
        this.c = this.it.next();
        return this.c;
    }

    protected void skipWhiteSpace() {
        while (Character.isWhitespace(this.c)) {
            this.next();
        }
    }

    public Object read(String string) throws JSONException {
        this.it = new StringCharacterIterator(string);
        this.c = this.it.first();
        return this.read();
    }

    protected Object read() throws JSONException {
        Object ret;
        this.skipWhiteSpace();
        if (this.c == '\"') {
            this.next();
            ret = this.string('\"');
        } else if (this.c == '\'') {
            this.next();
            ret = this.string('\'');
        } else if (this.c == '[') {
            this.next();
            ret = this.array();
        } else if (this.c == ']') {
            ret = ARRAY_END;
            this.next();
        } else if (this.c == ',') {
            ret = COMMA;
            this.next();
        } else if (this.c == '{') {
            this.next();
            ret = this.object();
        } else if (this.c == '}') {
            ret = OBJECT_END;
            this.next();
        } else if (this.c == ':') {
            ret = COLON;
            this.next();
        } else if (this.c == 't' && this.next() == 'r' && this.next() == 'u' && this.next() == 'e') {
            ret = Boolean.TRUE;
            this.next();
        } else if (this.c == 'f' && this.next() == 'a' && this.next() == 'l' && this.next() == 's' && this.next() == 'e') {
            ret = Boolean.FALSE;
            this.next();
        } else if (this.c == 'n' && this.next() == 'u' && this.next() == 'l' && this.next() == 'l') {
            ret = null;
            this.next();
        } else if (Character.isDigit(this.c) || this.c == '-') {
            ret = this.number();
        } else {
            throw this.buildInvalidInputException();
        }
        this.token = ret;
        return ret;
    }

    protected Map object() throws JSONException {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        Object next = this.read();
        if (next != OBJECT_END) {
            String key = (String)next;
            while (this.token != OBJECT_END) {
                this.read();
                if (this.token == OBJECT_END) continue;
                ret.put(key, this.read());
                if (this.read() != COMMA) continue;
                Object name = this.read();
                if (name instanceof String) {
                    key = (String)name;
                    continue;
                }
                throw this.buildInvalidInputException();
            }
        }
        return ret;
    }

    protected JSONException buildInvalidInputException() {
        return new JSONException("Input string is not well formed JSON (invalid char " + this.c + ")");
    }

    protected List array() throws JSONException {
        ArrayList<Object> ret = new ArrayList<Object>();
        Object value = this.read();
        while (this.token != ARRAY_END) {
            ret.add(value);
            Object read = this.read();
            if (read == COMMA) {
                value = this.read();
                continue;
            }
            if (read == ARRAY_END) continue;
            throw this.buildInvalidInputException();
        }
        return ret;
    }

    protected Object number() throws JSONException {
        this.buf.setLength(0);
        boolean toDouble = false;
        if (this.c == '-') {
            this.add();
        }
        this.addDigits();
        if (this.c == '.') {
            toDouble = true;
            this.add();
            this.addDigits();
        }
        if (this.c == 'e' || this.c == 'E') {
            toDouble = true;
            this.add();
            if (this.c == '+' || this.c == '-') {
                this.add();
            }
            this.addDigits();
        }
        if (toDouble) {
            try {
                return Double.parseDouble(this.buf.toString());
            }
            catch (NumberFormatException e) {
                throw this.buildInvalidInputException();
            }
        }
        try {
            return Long.parseLong(this.buf.toString());
        }
        catch (NumberFormatException e) {
            throw this.buildInvalidInputException();
        }
    }

    protected Object string(char quote) {
        this.buf.setLength(0);
        while (this.c != quote && this.c != '\uffff') {
            if (this.c == '\\') {
                this.next();
                if (this.c == 'u') {
                    this.add(this.unicode());
                    continue;
                }
                Character value = escapes.get(Character.valueOf(this.c));
                if (value == null) continue;
                this.add(value.charValue());
                continue;
            }
            this.add();
        }
        this.next();
        return this.buf.toString();
    }

    protected void add(char cc) {
        this.buf.append(cc);
        this.next();
    }

    protected void add() {
        this.add(this.c);
    }

    protected void addDigits() {
        while (Character.isDigit(this.c)) {
            this.add();
        }
    }

    protected char unicode() {
        int value = 0;
        block5: for (int i = 0; i < 4; ++i) {
            switch (this.next()) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    value = (value << 4) + (this.c - 48);
                    continue block5;
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    value = (value << 4) + (this.c - 87);
                    continue block5;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    value = (value << 4) + (this.c - 55);
                }
            }
        }
        return (char)value;
    }

    static {
        escapes.put(Character.valueOf('\"'), Character.valueOf('\"'));
        escapes.put(Character.valueOf('\\'), Character.valueOf('\\'));
        escapes.put(Character.valueOf('/'), Character.valueOf('/'));
        escapes.put(Character.valueOf('b'), Character.valueOf('\b'));
        escapes.put(Character.valueOf('f'), Character.valueOf('\f'));
        escapes.put(Character.valueOf('n'), Character.valueOf('\n'));
        escapes.put(Character.valueOf('r'), Character.valueOf('\r'));
        escapes.put(Character.valueOf('t'), Character.valueOf('\t'));
    }
}

