/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.internal;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.apache.sling.ide.eclipse.ui.internal.SelectionUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;

public class SlingLaunchpadCombo {
    private final Combo repositoryCombo;
    private IProject project;

    public SlingLaunchpadCombo(Composite parent, IProject project) {
        this.repositoryCombo = new Combo(parent, 12);
        this.repositoryCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.project = project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public Combo getWidget() {
        return this.repositoryCombo;
    }

    public void refreshRepositoryList(IProgressMonitor monitor) {
        this.repositoryCombo.removeAll();
        List<IServer> servers = this.project != null ? SelectionUtils.getServersLinkedToProject(this.project, monitor) : Arrays.asList(ServerCore.getServers());
        for (IServer server : servers) {
            this.repositoryCombo.add(server.getId());
        }
        if (servers.size() > 0) {
            this.repositoryCombo.select(0);
        }
    }

    public IServer getServer() {
        IServer[] iServerArray = ServerCore.getServers();
        int n = iServerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IServer server = iServerArray[n2];
            if (server.getId().equals(this.repositoryCombo.getText())) {
                return server;
            }
            ++n2;
        }
        return null;
    }

    public boolean hasServers() {
        return this.repositoryCombo.getItemCount() > 0;
    }

    public String getErrorMessage(ValidationFlag ... flags) {
        EnumSet<ValidationFlag> flagSet;
        if (!this.hasServers() && this.project != null) {
            return "The selected project is not configured with/added to any Sling server";
        }
        IServer server = this.getServer();
        if (server == null) {
            return "Please select a repository";
        }
        EnumSet<ValidationFlag> enumSet = flagSet = flags.length == 0 ? EnumSet.noneOf(ValidationFlag.class) : EnumSet.copyOf(Arrays.asList(flags));
        if (!flagSet.contains((Object)ValidationFlag.SKIP_SERVER_STARTED) && server.getServerState() != 2) {
            return "Selected server is not started";
        }
        return null;
    }

    public static enum ValidationFlag {
        SKIP_SERVER_STARTED;

    }
}

