/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.link.ui;

import com.day.cq.wcm.api.WCMMode;
import io.wcm.handler.link.LinkHandler;
import io.wcm.sling.models.annotations.AemObject;
import java.io.IOException;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;

@Model(adaptables={SlingHttpServletRequest.class})
public class Redirect {
    @SlingObject
    private Resource resource;
    @Self
    private LinkHandler linkHandler;
    @SlingObject
    private SlingHttpServletResponse response;
    @AemObject
    private WCMMode wcmMode;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    private String redirectStatus;
    private boolean renderPage = true;

    @PostConstruct
    private void activate() throws IOException {
        String redirectUrl = this.linkHandler.get(this.resource).buildUrl();
        if (this.wcmMode == WCMMode.DISABLED) {
            this.renderPage = false;
            if (StringUtils.isNotEmpty((CharSequence)redirectUrl)) {
                if (StringUtils.equals((CharSequence)this.redirectStatus, (CharSequence)Integer.toString(302))) {
                    this.response.sendRedirect(redirectUrl);
                } else {
                    this.response.setStatus(301);
                    this.response.setHeader("Location", redirectUrl);
                }
            } else {
                this.response.sendError(404);
            }
        }
    }

    public boolean isRenderPage() {
        return this.renderPage;
    }
}

