/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.spring.cloud.gateway.v412x;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.ServerWebExchangeDecorator;
import org.springframework.web.server.adapter.DefaultServerWebExchange;

public class GatewayFilterV412Interceptor
implements InstanceMethodsAroundInterceptor {
    private static final ThreadLocal<AtomicInteger> STACK_DEEP = ThreadLocal.withInitial(() -> new AtomicInteger(0));

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        if (this.isEntry()) {
            ServerWebExchange exchange = (ServerWebExchange)allArguments[0];
            EnhancedInstance enhancedInstance = GatewayFilterV412Interceptor.getInstance(exchange);
            AbstractSpan span = ContextManager.createLocalSpan((String)"SpringCloudGateway/GatewayFilter");
            if (enhancedInstance != null && enhancedInstance.getSkyWalkingDynamicField() != null) {
                ContextManager.continued((ContextSnapshot)((ContextSnapshot)enhancedInstance.getSkyWalkingDynamicField()));
            }
            span.setComponent((Component)ComponentsDefine.SPRING_CLOUD_GATEWAY);
        }
    }

    public static EnhancedInstance getInstance(Object o) {
        EnhancedInstance instance = null;
        if (o instanceof DefaultServerWebExchange) {
            instance = (EnhancedInstance)o;
        } else if (o instanceof ServerWebExchangeDecorator) {
            ServerWebExchange delegate = ((ServerWebExchangeDecorator)o).getDelegate();
            return GatewayFilterV412Interceptor.getInstance(delegate);
        }
        return instance;
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        if (this.isExit() && ContextManager.isActive()) {
            ContextManager.stopSpan();
        }
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }

    private boolean isEntry() {
        return STACK_DEEP.get().getAndIncrement() == 0;
    }

    private boolean isExit() {
        boolean isExit;
        boolean bl = isExit = STACK_DEEP.get().decrementAndGet() == 0;
        if (isExit) {
            STACK_DEEP.remove();
        }
        return isExit;
    }
}

