/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.c3p0;

import com.mchange.v2.c3p0.C3P0Registry;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.meter.Gauge;
import org.apache.skywalking.apm.agent.core.meter.MeterFactory;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser.URLParser;
import org.apache.skywalking.apm.plugin.jdbc.trace.ConnectionInfo;

public class PoolingCreationInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final Set<String> TOKEN_MAP = new HashSet<String>(16);

    public void beforeMethod(EnhancedInstance enhancedInstance, Method method, Object[] objects, Class<?>[] classes, MethodInterceptResult methodInterceptResult) throws Throwable {
    }

    public Object afterMethod(EnhancedInstance enhancedInstance, Method method, Object[] objects, Class<?>[] classes, Object ret) throws Throwable {
        C3P0Registry.getPooledDataSources().forEach(obj -> {
            ComboPooledDataSource pooledDataSource = (ComboPooledDataSource)obj;
            if (!TOKEN_MAP.contains(pooledDataSource.getIdentityToken())) {
                ConnectionInfo connectionInfo = URLParser.parser((String)pooledDataSource.getJdbcUrl());
                String tagValue = connectionInfo.getDatabaseName() + "_" + connectionInfo.getDatabasePeer();
                Map<String, Function<ComboPooledDataSource, Supplier<Double>>> metricMap = this.getMetrics();
                metricMap.forEach((key, value) -> ((Gauge.Builder)((Gauge.Builder)MeterFactory.gauge((String)"datasource", (Supplier)((Supplier)value.apply(pooledDataSource))).tag("name", tagValue)).tag("status", key)).build());
                TOKEN_MAP.add(pooledDataSource.getIdentityToken());
            }
        });
        return ret;
    }

    public void handleMethodException(EnhancedInstance enhancedInstance, Method method, Object[] objects, Class<?>[] classes, Throwable t) {
        ContextManager.activeSpan().errorOccurred().log(t);
    }

    private Map<String, Function<ComboPooledDataSource, Supplier<Double>>> getMetrics() {
        HashMap<String, Function<ComboPooledDataSource, Supplier<Double>>> metricMap = new HashMap<String, Function<ComboPooledDataSource, Supplier<Double>>>();
        metricMap.put("numTotalConnections", pooledDataSource -> () -> {
            double numConnections = 0.0;
            try {
                numConnections = pooledDataSource.getNumConnections();
            }
            catch (SQLException e) {
                ContextManager.activeSpan().errorOccurred().log((Throwable)e);
            }
            return numConnections;
        });
        metricMap.put("numBusyConnections", pooledDataSource -> () -> {
            double numBusyConnections = 0.0;
            try {
                numBusyConnections = pooledDataSource.getNumBusyConnections();
            }
            catch (SQLException e) {
                ContextManager.activeSpan().errorOccurred().log((Throwable)e);
            }
            return numBusyConnections;
        });
        metricMap.put("numIdleConnections", pooledDataSource -> () -> {
            double numIdleConnections = 0.0;
            try {
                numIdleConnections = pooledDataSource.getNumIdleConnections();
            }
            catch (SQLException e) {
                ContextManager.activeSpan().errorOccurred().log((Throwable)e);
            }
            return numIdleConnections;
        });
        metricMap.put("maxIdleTime", pooledDataSource -> () -> pooledDataSource.getMaxIdleTime());
        metricMap.put("minPoolSize", pooledDataSource -> () -> pooledDataSource.getMinPoolSize());
        metricMap.put("maxPoolSize", pooledDataSource -> () -> pooledDataSource.getMaxPoolSize());
        metricMap.put("initialPoolSize", pooledDataSource -> () -> pooledDataSource.getInitialPoolSize());
        return metricMap;
    }
}

