/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.version;

import org.apache.servicecomb.foundation.common.Version;
import org.apache.servicecomb.registry.version.VersionRule;
import org.apache.servicecomb.registry.version.VersionRuleParser;

public class VersionRuleRangeParser
implements VersionRuleParser {
    @Override
    public VersionRule parse(String strVersionRule) {
        int pos = strVersionRule.indexOf(45);
        if (pos <= 0 || pos == strVersionRule.length() - 1) {
            return null;
        }
        Version from = new Version(strVersionRule.substring(0, pos));
        Version to = new Version(strVersionRule.substring(pos + 1));
        return new RangeVersionRule(from.getVersion() + "-" + to.getVersion(), from, to);
    }

    static class RangeVersionRule
    extends VersionRule {
        private final Version from;
        private final Version to;

        public RangeVersionRule(String versionRule, Version from, Version to) {
            super(versionRule);
            this.from = from;
            this.to = to;
        }

        @Override
        public boolean isMatch(Version version, Version latestVersion) {
            return version.compareTo(this.from) >= 0 && version.compareTo(this.to) < 0;
        }
    }
}

